/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexOptions;
import com.stratio.cassandra.lucene.IndexPagingState;
import com.stratio.cassandra.lucene.IndexReader;
import com.stratio.cassandra.lucene.IndexService$;
import com.stratio.cassandra.lucene.IndexServiceMBean;
import com.stratio.cassandra.lucene.IndexWriter;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.index.DocumentIterator;
import com.stratio.cassandra.lucene.index.PartitionedIndex;
import com.stratio.cassandra.lucene.mapping.ColumnsMapper;
import com.stratio.cassandra.lucene.mapping.ExpressionMapper;
import com.stratio.cassandra.lucene.mapping.PartitionMapper;
import com.stratio.cassandra.lucene.mapping.TokenMapper;
import com.stratio.cassandra.lucene.partitioning.Partitioner;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.util.Locker;
import com.stratio.cassandra.lucene.util.Logging;
import com.stratio.cassandra.lucene.util.TaskQueue;
import com.stratio.cassandra.lucene.util.TaskQueue$;
import com.stratio.cassandra.lucene.util.Tracer;
import com.stratio.cassandra.lucene.util.Tracing;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import java.lang.management.ManagementFactory;
import java.util.Set;
import javax.management.JMException;
import javax.management.ObjectName;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.RowFilter;
import org.apache.cassandra.db.partitions.PartitionUpdate;
import org.apache.cassandra.db.partitions.UnfilteredPartitionIterator;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.FBUtilities;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0011}b!B\u0001\u0003\u0003\u0003Y!\u0001D%oI\u0016D8+\u001a:wS\u000e,'BA\u0002\u0005\u0003\u0019aWoY3oK*\u0011QAB\u0001\nG\u0006\u001c8/\u00198ee\u0006T!a\u0002\u0005\u0002\u000fM$(/\u0019;j_*\t\u0011\"A\u0002d_6\u001c\u0001aE\u0003\u0001\u0019I1B\u0004\u0005\u0002\u000e!5\taBC\u0001\u0010\u0003\u0015\u00198-\u00197b\u0013\t\tbB\u0001\u0004B]f\u0014VM\u001a\t\u0003'Qi\u0011AA\u0005\u0003+\t\u0011\u0011#\u00138eKb\u001cVM\u001d<jG\u0016l%)Z1o!\t9\"$D\u0001\u0019\u0015\tI\"!\u0001\u0003vi&d\u0017BA\u000e\u0019\u0005\u001daunZ4j]\u001e\u0004\"aF\u000f\n\u0005yA\"a\u0002+sC\u000eLgn\u001a\u0005\tA\u0001\u0011)\u0019!C\u0001C\u0005)A/\u00192mKV\t!\u0005\u0005\u0002$W5\tAE\u0003\u0002&M\u0005\u0011AM\u0019\u0006\u0003\u000b\u001dR!\u0001K\u0015\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u0005Q\u0013aA8sO&\u0011A\u0006\n\u0002\u0012\u0007>dW/\u001c8GC6LG._*u_J,\u0007\u0002\u0003\u0018\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0012\u0002\rQ\f'\r\\3!\u0011!\u0001\u0004A!b\u0001\n\u0003\t\u0014!D5oI\u0016DX*\u001a;bI\u0006$\u0018-F\u00013!\t\u0019d'D\u00015\u0015\t)d%\u0001\u0004tG\",W.Y\u0005\u0003oQ\u0012Q\"\u00138eKblU\r^1eCR\f\u0007\u0002C\u001d\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u001a\u0002\u001d%tG-\u001a=NKR\fG-\u0019;bA!)1\b\u0001C\u0001y\u00051A(\u001b8jiz\"2!\u0010 @!\t\u0019\u0002\u0001C\u0003!u\u0001\u0007!\u0005C\u00031u\u0001\u0007!\u0007C\u0004B\u0001\t\u0007I\u0011\u0001\"\u0002\u00115,G/\u00193bi\u0006,\u0012a\u0011\t\u0003\t\u001ek\u0011!\u0012\u0006\u0003\r\u001a\naaY8oM&<\u0017B\u0001%F\u0005)\u0019e)T3uC\u0012\u000bG/\u0019\u0005\u0007\u0015\u0002\u0001\u000b\u0011B\"\u0002\u00135,G/\u00193bi\u0006\u0004\u0003b\u0002'\u0001\u0005\u0004%\t!T\u0001\u0007WNt\u0015-\\3\u0016\u00039\u0003\"a\u0014+\u000e\u0003AS!!\u0015*\u0002\t1\fgn\u001a\u0006\u0002'\u0006!!.\u0019<b\u0013\t)\u0006K\u0001\u0004TiJLgn\u001a\u0005\u0007/\u0002\u0001\u000b\u0011\u0002(\u0002\u000f-\u001ch*Y7fA!9\u0011\f\u0001b\u0001\n\u0003i\u0015AB2g\u001d\u0006lW\r\u0003\u0004\\\u0001\u0001\u0006IAT\u0001\bG\u001at\u0015-\\3!\u0011\u001di\u0006A1A\u0005\u00025\u000bq!\u001b3y\u001d\u0006lW\r\u0003\u0004`\u0001\u0001\u0006IAT\u0001\tS\u0012Dh*Y7fA!9\u0011\r\u0001b\u0001\n\u0003\u0011\u0017!D9vC2Lg-[3e\u001d\u0006lW-F\u0001d!\t!7N\u0004\u0002fSB\u0011aMD\u0007\u0002O*\u0011\u0001NC\u0001\u0007yI|w\u000e\u001e \n\u0005)t\u0011A\u0002)sK\u0012,g-\u0003\u0002VY*\u0011!N\u0004\u0005\u0007]\u0002\u0001\u000b\u0011B2\u0002\u001dE,\u0018\r\\5gS\u0016$g*Y7fA!9\u0001\u000f\u0001b\u0001\n\u0003\t\u0018aB8qi&|gn]\u000b\u0002eB\u00111c]\u0005\u0003i\n\u0011A\"\u00138eKb|\u0005\u000f^5p]NDaA\u001e\u0001!\u0002\u0013\u0011\u0018\u0001C8qi&|gn\u001d\u0011\t\u000fU\u0002!\u0019!C\u0001qV\t\u0011\u0010\u0005\u0002{y6\t1P\u0003\u00026\u0005%\u0011Qp\u001f\u0002\u0007'\u000eDW-\\1\t\r}\u0004\u0001\u0015!\u0003z\u0003\u001d\u00198\r[3nC\u0002B\u0011\"a\u0001\u0001\u0005\u0004%\t!!\u0002\u0002\u0011I,w-\u001e7beN,\"!a\u0002\u0011\r\u0005%\u00111CA\f\u001b\t\tYA\u0003\u0003\u0002\u000e\u0005=\u0011!C5n[V$\u0018M\u00197f\u0015\r\t\tBD\u0001\u000bG>dG.Z2uS>t\u0017\u0002BA\u000b\u0003\u0017\u00111aU3u!\r!\u0015\u0011D\u0005\u0004\u00037)%\u0001E\"pYVlg\u000eR3gS:LG/[8o\u0011!\ty\u0002\u0001Q\u0001\n\u0005\u001d\u0011!\u0003:fOVd\u0017M]:!\u0011%\t\u0019\u0003\u0001b\u0001\n\u0003\t)#\u0001\bnCB\u0004X\r\u001a*fOVd\u0017M]:\u0016\u0005\u0005\u001d\u0002#BA\u0005\u0003'q\u0005\u0002CA\u0016\u0001\u0001\u0006I!a\n\u0002\u001f5\f\u0007\u000f]3e%\u0016<W\u000f\\1sg\u0002B\u0011\"a\f\u0001\u0005\u0004%\t!!\r\u0002\u001b5\f\u0007o]'vYRL7)\u001a7m+\t\t\u0019\u0004E\u0002\u000e\u0003kI1!a\u000e\u000f\u0005\u001d\u0011un\u001c7fC:D\u0001\"a\u000f\u0001A\u0003%\u00111G\u0001\u000f[\u0006\u00048/T;mi&\u001cU\r\u001c7!\u0011%\ty\u0004\u0001b\u0001\n\u0003\t\t$\u0001\bnCB\u001c\bK]5nCJL8*Z=\t\u0011\u0005\r\u0003\u0001)A\u0005\u0003g\tq\"\\1qgB\u0013\u0018.\\1ss.+\u0017\u0010\t\u0005\n\u0003\u000f\u0002!\u0019!C\u0001\u0003\u0013\n1\u0002^8lK:l\u0015\r\u001d9feV\u0011\u00111\n\t\u0005\u0003\u001b\n\u0019&\u0004\u0002\u0002P)\u0019\u0011\u0011\u000b\u0002\u0002\u000f5\f\u0007\u000f]5oO&!\u0011QKA(\u0005-!vn[3o\u001b\u0006\u0004\b/\u001a:\t\u0011\u0005e\u0003\u0001)A\u0005\u0003\u0017\nA\u0002^8lK:l\u0015\r\u001d9fe\u0002B\u0011\"!\u0018\u0001\u0005\u0004%\t!a\u0018\u0002\u001fA\f'\u000f^5uS>tW*\u00199qKJ,\"!!\u0019\u0011\t\u00055\u00131M\u0005\u0005\u0003K\nyEA\bQCJ$\u0018\u000e^5p]6\u000b\u0007\u000f]3s\u0011!\tI\u0007\u0001Q\u0001\n\u0005\u0005\u0014\u0001\u00059beRLG/[8o\u001b\u0006\u0004\b/\u001a:!\u0011%\ti\u0007\u0001b\u0001\n\u0003\ty'A\u0007d_2,XN\\:NCB\u0004XM]\u000b\u0003\u0003c\u0002B!!\u0014\u0002t%!\u0011QOA(\u00055\u0019u\u000e\\;n]Nl\u0015\r\u001d9fe\"A\u0011\u0011\u0010\u0001!\u0002\u0013\t\t(\u0001\bd_2,XN\\:NCB\u0004XM\u001d\u0011\t\u0013\u0005u\u0004A1A\u0005\u0002\u0005}\u0014\u0001E3yaJ,7o]5p]6\u000b\u0007\u000f]3s+\t\t\t\t\u0005\u0003\u0002N\u0005\r\u0015\u0002BAC\u0003\u001f\u0012\u0001#\u0012=qe\u0016\u001c8/[8o\u001b\u0006\u0004\b/\u001a:\t\u0011\u0005%\u0005\u0001)A\u0005\u0003\u0003\u000b\u0011#\u001a=qe\u0016\u001c8/[8o\u001b\u0006\u0004\b/\u001a:!\u0011%\ti\t\u0001b\u0001\n\u0003\ty)A\u0003rk\u0016,X-\u0006\u0002\u0002\u0012B\u0019q#a%\n\u0007\u0005U\u0005DA\u0005UCN\\\u0017+^3vK\"A\u0011\u0011\u0014\u0001!\u0002\u0013\t\t*\u0001\u0004rk\u0016,X\r\t\u0005\n\u0003;\u0003!\u0019!C\u0001\u0003?\u000b1\u0002]1si&$\u0018n\u001c8feV\u0011\u0011\u0011\u0015\t\u0005\u0003G\u000bI+\u0004\u0002\u0002&*\u0019\u0011q\u0015\u0002\u0002\u0019A\f'\u000f^5uS>t\u0017N\\4\n\t\u0005-\u0016Q\u0015\u0002\f!\u0006\u0014H/\u001b;j_:,'\u000f\u0003\u0005\u00020\u0002\u0001\u000b\u0011BAQ\u00031\u0001\u0018M\u001d;ji&|g.\u001a:!\u0011!\u0019\u0001A1A\u0005\u0002\u0005MVCAA[!\u0011\t9,!0\u000e\u0005\u0005e&bAA^\u0005\u0005)\u0011N\u001c3fq&!\u0011qXA]\u0005A\u0001\u0016M\u001d;ji&|g.\u001a3J]\u0012,\u0007\u0010\u0003\u0005\u0002D\u0002\u0001\u000b\u0011BA[\u0003\u001daWoY3oK\u0002B1\"a2\u0001\u0001\u0004\u0005\r\u0011\"\u0001\u0002J\u0006)QNQ3b]V\u0011\u00111\u001a\t\u0005\u0003\u001b\f9.\u0004\u0002\u0002P*!\u0011\u0011[Aj\u0003)i\u0017M\\1hK6,g\u000e\u001e\u0006\u0003\u0003+\fQA[1wCbLA!!7\u0002P\nQqJ\u00196fGRt\u0015-\\3\t\u0017\u0005u\u0007\u00011AA\u0002\u0013\u0005\u0011q\\\u0001\n[\n+\u0017M\\0%KF$B!!9\u0002hB\u0019Q\"a9\n\u0007\u0005\u0015hB\u0001\u0003V]&$\bBCAu\u00037\f\t\u00111\u0001\u0002L\u0006\u0019\u0001\u0010J\u0019\t\u0011\u00055\b\u0001)Q\u0005\u0003\u0017\fa!\u001c\"fC:\u0004\u0003\"CAy\u0001\t\u0007I\u0011AAz\u0003U\u0011X-\u00193CK\u001a|'/Z,sSR,Gj\\2lKJ,\"!!>\u0011\u0007]\t90C\u0002\u0002zb\u0011a\u0001T8dW\u0016\u0014\b\u0002CA\u007f\u0001\u0001\u0006I!!>\u0002-I,\u0017\r\u001a\"fM>\u0014Xm\u0016:ji\u0016dunY6fe\u0002BqA!\u0001\u0001\t\u0003\u0011\u0019!\u0001\u0003j]&$HCAAq\u0011\u001d\u00119\u0001\u0001D\u0001\u0005\u0013\tQb[3z'>\u0014HOR5fY\u0012\u001cXC\u0001B\u0006!\u0019\u0011iAa\u0006\u0003\u001e9!!q\u0002B\n\u001d\r1'\u0011C\u0005\u0002\u001f%\u0019!Q\u0003\b\u0002\u000fA\f7m[1hK&!!\u0011\u0004B\u000e\u0005\u0011a\u0015n\u001d;\u000b\u0007\tUa\u0002\u0005\u0003\u0003 \t\u001dRB\u0001B\u0011\u0015\u0011\u0011\u0019C!\n\u0002\rM,\u0017M]2i\u0015\t\u0019q%\u0003\u0003\u0003*\t\u0005\"!C*peR4\u0015.\u001a7e\u0011\u001d\u0011i\u0003\u0001D\u0001\u0005_\tABZ5fY\u0012\u001cHk\u001c'pC\u0012,\"A!\r\u0011\u000b\tM\"qG2\u000e\u0005\tU\"BA\rS\u0013\u0011\t)B!\u000e\t\u000f\tm\u0002A\"\u0001\u0003>\u0005\u00112.Z=J]\u0012,\u00070\u00192mK\u001aKW\r\u001c3t)\u0019\u0011yDa\u0013\u0003VA1!Q\u0002B\f\u0005\u0003\u0002BAa\u0011\u0003H5\u0011!Q\t\u0006\u0005\u0003w\u0013)#\u0003\u0003\u0003J\t\u0015#AD%oI\u0016D\u0018M\u00197f\r&,G\u000e\u001a\u0005\t\u0005\u001b\u0012I\u00041\u0001\u0003P\u0005\u00191.Z=\u0011\u0007\r\u0012\t&C\u0002\u0003T\u0011\u0012A\u0002R3d_J\fG/\u001a3LKfD\u0001Ba\u0016\u0003:\u0001\u0007!\u0011L\u0001\u000bG2,8\u000f^3sS:<\u0007cA\u0012\u0003\\%\u0019!Q\f\u0013\u0003\u0015\rcWo\u001d;fe&tw\rC\u0004\u0003b\u0001!\tAa\u0019\u0002\u0013\u0011,\u0007/\u001a8eg>sG\u0003BA\u001a\u0005KB\u0001Ba\u001a\u0003`\u0001\u0007\u0011qC\u0001\nG>dW/\u001c8EK\u001aDqAa\u001b\u0001\t\u0003\u0011i'\u0001\u0005wC2LG-\u0019;f)\u0011\u0011yG!\u001f\u0011\t\tE$QO\u0007\u0003\u0005gR1Aa\t\u0003\u0013\u0011\u00119Ha\u001d\u0003\rM+\u0017M]2i\u0011!\u0011YH!\u001bA\u0002\tu\u0014AC3yaJ,7o]5p]B!!q\u0010BF\u001d\u0011\u0011\tIa\"\u000e\u0005\t\r%b\u0001BCI\u00051a-\u001b7uKJLAA!#\u0003\u0004\u0006I!k\\<GS2$XM]\u0005\u0005\u0005\u001b\u0013yI\u0001\u0006FqB\u0014Xm]:j_:TAA!#\u0003\u0004\"9!1\u0013\u0001\u0007\u0002\tU\u0015\u0001\u0002;fe6$bAa&\u0003\u001e\n}\u0005\u0003\u0002B\"\u00053KAAa'\u0003F\t!A+\u001a:n\u0011!\u0011iE!%A\u0002\t=\u0003\u0002\u0003B,\u0005#\u0003\rA!\u0017\t\u000f\tM\u0005\u0001\"\u0001\u0003$R!!q\u0013BS\u0011!\u0011iE!)A\u0002\t=\u0003b\u0002BU\u0001\u0011\u0005!1V\u0001\u0015]\u0016,Gm\u001d*fC\u0012\u0014UMZ8sK^\u0013\u0018\u000e^3\u0015\r\u0005M\"Q\u0016BX\u0011!\u0011iEa*A\u0002\t=\u0003\u0002\u0003BY\u0005O\u0003\rAa-\u0002\u0007I|w\u000f\u0005\u0003\u00036\nmVB\u0001B\\\u0015\r\u0011I\fJ\u0001\u0005e><8/\u0003\u0003\u0003>\n]&a\u0001*po\"9!\u0011\u0019\u0001\u0005\u0002\t\r\u0017a\u00043pKN\feMZ3di&sG-\u001a=\u0015\t\u0005M\"Q\u0019\u0005\t\u0005c\u0013y\f1\u0001\u00034\"9!\u0011\u001a\u0001\u0005\u0002\t-\u0017\u0001\u00043fG>\u0014\u0018\r^3e\u0017\u0016LH\u0003\u0002B(\u0005\u001bD\u0001Ba4\u0003H\u0002\u0007!\u0011[\u0001\tI>\u001cW/\\3oiB!!1\u001bBl\u001b\t\u0011)N\u0003\u0003\u0003P\n\u0015\u0012\u0002\u0002Bm\u0005+\u0014\u0001\u0002R8dk6,g\u000e\u001e\u0005\b\u0005;\u0004a\u0011\u0001Bp\u0003\u00199(/\u001b;feRQ!\u0011\u001dBt\u0005S\u0014\u0019pa\u0004\u0011\u0007M\u0011\u0019/C\u0002\u0003f\n\u00111\"\u00138eKb<&/\u001b;fe\"A!Q\nBn\u0001\u0004\u0011y\u0005\u0003\u0005\u0003l\nm\u0007\u0019\u0001Bw\u0003!qwn^%o'\u0016\u001c\u0007cA\u0007\u0003p&\u0019!\u0011\u001f\b\u0003\u0007%sG\u000f\u0003\u0005\u0003v\nm\u0007\u0019\u0001B|\u0003)y'\u000fZ3s\u000fJ|W\u000f\u001d\t\u0005\u0005s\u001cIA\u0004\u0003\u0003|\u000e\u0015QB\u0001B\u007f\u0015\u0011\u0011yp!\u0001\u0002\u0015\r|gnY;se\u0016tGOC\u0002\u0004\u0004\u0019\nQ!\u001e;jYNLAaa\u0002\u0003~\u00069q\n](sI\u0016\u0014\u0018\u0002BB\u0006\u0007\u001b\u0011Qa\u0012:pkBTAaa\u0002\u0003~\"A1\u0011\u0003Bn\u0001\u0004\u0019\u0019\"A\bue\u0006t7/Y2uS>tG+\u001f9f!\u0011\u0019)ba\t\u000f\t\r]1qD\u0007\u0003\u00073QAaa\u0007\u0004\u001e\u0005aAO]1og\u0006\u001cG/[8og*\u0019\u00111\u0018\u0014\n\t\r\u00052\u0011D\u0001\u0011\u0013:$W\r\u001f+sC:\u001c\u0018m\u0019;j_:LAa!\n\u0004(\t!A+\u001f9f\u0015\u0011\u0019\tc!\u0007\t\u000f\r-\u0002\u0001\"\u0001\u0003\u0004\u0005AAO];oG\u0006$X\rC\u0004\u00040\u0001!\tAa\u0001\u0002\r\u0011,G.\u001a;f\u0011\u001d\u0019\u0019\u0004\u0001C\u0001\u0007k\ta!\u001e9tKJ$H\u0003CAq\u0007o\u0019Ida\u000f\t\u0011\t53\u0011\u0007a\u0001\u0005\u001fB\u0001B!-\u00042\u0001\u0007!1\u0017\u0005\t\u0005W\u001c\t\u00041\u0001\u0003n\"91q\u0006\u0001\u0005\u0002\r}BCBAq\u0007\u0003\u001a\u0019\u0005\u0003\u0005\u0003N\ru\u0002\u0019\u0001B(\u0011!\u00119f!\u0010A\u0002\te\u0003bBB\u0018\u0001\u0011\u00051q\t\u000b\u0005\u0003C\u001cI\u0005\u0003\u0005\u0003N\r\u0015\u0003\u0019\u0001B(\u0011\u001d\u0011\u0019\u0003\u0001C\u0001\u0007\u001b\"baa\u0014\u0004\\\r\u0015\u0004\u0003BB)\u0007/j!aa\u0015\u000b\u0007\rUC%\u0001\u0006qCJ$\u0018\u000e^5p]NLAa!\u0017\u0004T\tYRK\u001c4jYR,'/\u001a3QCJ$\u0018\u000e^5p]&#XM]1u_JD\u0001b!\u0018\u0004L\u0001\u00071qL\u0001\bG>lW.\u00198e!\r\u00193\u0011M\u0005\u0004\u0007G\"#a\u0003*fC\u0012\u001cu.\\7b]\u0012D\u0001ba\u001a\u0004L\u0001\u00071\u0011N\u0001\u000bG>tGO]8mY\u0016\u0014\bcA\u0012\u0004l%\u00191Q\u000e\u0013\u0003/I+\u0017\rZ#yK\u000e,H/[8o\u0007>tGO]8mY\u0016\u0014\bbBB9\u0001\u0011\u000511O\u0001\u0006cV,'/\u001f\u000b\u0005\u0007k\u001a\t\tE\u0003\u000e\u0007o\u001aY(C\u0002\u0004z9\u0011aa\u00149uS>t\u0007\u0003\u0002B\u0010\u0007{JAaa \u0003\"\t)\u0011+^3ss\"A1QLB8\u0001\u0004\u0019y\u0006C\u0004\u0004r\u00011\ta!\"\u0015\r\rm4qQBE\u0011!\u0011iea!A\u0002\t=\u0003\u0002\u0003BC\u0007\u0007\u0003\raa#\u0011\t\t\u00055QR\u0005\u0005\u0007\u001f\u0013\u0019IA\u000bDYV\u001cH/\u001a:j]\u001eLe\u000eZ3y\r&dG/\u001a:\t\u000f\rE\u0004A\"\u0001\u0004\u0014R!1QOBK\u0011!\u00199j!%A\u0002\re\u0015!\u00033bi\u0006\u0014\u0016M\\4f!\r\u001931T\u0005\u0004\u0007;##!\u0003#bi\u0006\u0014\u0016M\\4f\u0011\u001d\u0019\t\u000b\u0001C\u0001\u0007G\u000bQ!\u00194uKJ$ba!*\u00040\u000ee\u0006C\u0002B\u0007\u0005/\u00199\u000bE\u0004\u000e\u0007S\u0013io!,\n\u0007\r-fB\u0001\u0004UkBdWM\r\t\u0006\u001b\r]$q\u0013\u0005\t\u0007c\u001by\n1\u0001\u00044\u0006Y\u0001/Y4j]\u001e\u001cF/\u0019;f!\r\u00192QW\u0005\u0004\u0007o\u0013!\u0001E%oI\u0016D\b+Y4j]\u001e\u001cF/\u0019;f\u0011!\u0019ifa(A\u0002\r}\u0003bBBQ\u0001\u0019\u00051Q\u0018\u000b\u0007\u0005/\u001byl!1\t\u0011\t531\u0018a\u0001\u0005\u001fB\u0001Ba\u0016\u0004<\u0002\u0007!\u0011\f\u0005\b\u0007\u000b\u0004A\u0011ABd\u0003\u0011\u0019xN\u001d;\u0015\t\r%7q\u001a\t\u0005\u0005?\u0019Y-\u0003\u0003\u0004N\n\u0005\"\u0001B*peRD\u0001Ba\t\u0004D\u0002\u0007!q\u000e\u0005\b\u0007'\u0004a\u0011ABk\u0003\u0019\u0011X-\u00193feRA1q[Bo\u0007O\u001cI\u000fE\u0002\u0014\u00073L1aa7\u0003\u0005-Ie\u000eZ3y%\u0016\fG-\u001a:\t\u0011\r}7\u0011\u001ba\u0001\u0007C\f\u0011\u0002Z8dk6,g\u000e^:\u0011\t\u0005]61]\u0005\u0005\u0007K\fIL\u0001\tE_\u000e,X.\u001a8u\u0013R,'/\u0019;pe\"A1QLBi\u0001\u0004\u0019y\u0006\u0003\u0005\u0004h\rE\u0007\u0019AB5\u0011\u001d\u0011Y\u0007\u0001C\u0001\u0007[$B!!9\u0004p\"A1\u0011_Bv\u0001\u0004\u0019\u00190\u0001\u0004va\u0012\fG/\u001a\t\u0005\u0007#\u001a)0\u0003\u0003\u0004x\u000eM#a\u0004)beRLG/[8o+B$\u0017\r^3\t\u000f\rm\b\u0001\"\u0011\u0003\u0004\u000511m\\7nSRDqaa@\u0001\t\u0003\"\t!\u0001\u0006hKRtU/\u001c#pGN,\"\u0001b\u0001\u0011\u00075!)!C\u0002\u0005\b9\u0011A\u0001T8oO\"9A1\u0002\u0001\u0005B\u0011\u0005\u0011!E4fi:+X\u000eR3mKR,G\rR8dg\"9Aq\u0002\u0001\u0005B\u0011E\u0011A\u00034pe\u000e,W*\u001a:hKR1\u0011\u0011\u001dC\n\t/A\u0001\u0002\"\u0006\u0005\u000e\u0001\u0007!Q^\u0001\u000f[\u0006Dh*^7TK\u001elWM\u001c;t\u0011!!I\u0002\"\u0004A\u0002\u0005M\u0012A\u00023p/\u0006LG\u000fC\u0004\u0005\u001e\u0001!\t\u0005b\b\u0002#\u0019|'oY3NKJ<W\rR3mKR,7\u000f\u0006\u0003\u0002b\u0012\u0005\u0002\u0002\u0003C\r\t7\u0001\r!a\r\t\u000f\u0011\u0015\u0002\u0001\"\u0011\u0003\u0004\u00059!/\u001a4sKNDwa\u0002C\u0015\u0005!\u0005A1F\u0001\r\u0013:$W\r_*feZL7-\u001a\t\u0004'\u00115bAB\u0001\u0003\u0011\u0003!ycE\u0002\u0005.1Aqa\u000fC\u0017\t\u0003!\u0019\u0004\u0006\u0002\u0005,!AAq\u0007C\u0017\t\u0003!I$A\u0003ck&dG\rF\u0003>\tw!i\u0004\u0003\u0004!\tk\u0001\rA\t\u0005\u0007a\u0011U\u0002\u0019\u0001\u001a")
public abstract class IndexService
implements IndexServiceMBean,
Logging,
Tracing {
    private final ColumnFamilyStore table;
    private final IndexMetadata indexMetadata;
    private final CFMetaData metadata;
    private final String ksName;
    private final String cfName;
    private final String idxName;
    private final String qualifiedName;
    private final IndexOptions options;
    private final Schema schema;
    private final scala.collection.immutable.Set<ColumnDefinition> regulars;
    private final scala.collection.immutable.Set<String> mappedRegulars;
    private final boolean mapsMultiCell;
    private final boolean mapsPrimaryKey;
    private final TokenMapper tokenMapper;
    private final PartitionMapper partitionMapper;
    private final ColumnsMapper columnsMapper;
    private final ExpressionMapper expressionMapper;
    private final TaskQueue queue;
    private final Partitioner partitioner;
    private final PartitionedIndex lucene;
    private ObjectName mBean;
    private final Locker readBeforeWriteLocker;
    private final Tracer tracer;
    private final Logger logger;

    public static IndexService build(ColumnFamilyStore columnFamilyStore, IndexMetadata indexMetadata) {
        return IndexService$.MODULE$.build(columnFamilyStore, indexMetadata);
    }

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public void com$stratio$cassandra$lucene$util$Tracing$_setter_$tracer_$eq(Tracer x$1) {
        this.tracer = x$1;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public ColumnFamilyStore table() {
        return this.table;
    }

    public IndexMetadata indexMetadata() {
        return this.indexMetadata;
    }

    public CFMetaData metadata() {
        return this.metadata;
    }

    public String ksName() {
        return this.ksName;
    }

    public String cfName() {
        return this.cfName;
    }

    public String idxName() {
        return this.idxName;
    }

    public String qualifiedName() {
        return this.qualifiedName;
    }

    public IndexOptions options() {
        return this.options;
    }

    public Schema schema() {
        return this.schema;
    }

    public scala.collection.immutable.Set<ColumnDefinition> regulars() {
        return this.regulars;
    }

    public scala.collection.immutable.Set<String> mappedRegulars() {
        return this.mappedRegulars;
    }

    public boolean mapsMultiCell() {
        return this.mapsMultiCell;
    }

    public boolean mapsPrimaryKey() {
        return this.mapsPrimaryKey;
    }

    public TokenMapper tokenMapper() {
        return this.tokenMapper;
    }

    public PartitionMapper partitionMapper() {
        return this.partitionMapper;
    }

    public ColumnsMapper columnsMapper() {
        return this.columnsMapper;
    }

    public ExpressionMapper expressionMapper() {
        return this.expressionMapper;
    }

    public TaskQueue queue() {
        return this.queue;
    }

    public Partitioner partitioner() {
        return this.partitioner;
    }

    public PartitionedIndex lucene() {
        return this.lucene;
    }

    public ObjectName mBean() {
        return this.mBean;
    }

    public void mBean_$eq(ObjectName x$1) {
        this.mBean = x$1;
    }

    public Locker readBeforeWriteLocker() {
        return this.readBeforeWriteLocker;
    }

    public void init() {
        block6: {
            BoxedUnit boxedUnit;
            try {
                Sort sort = new Sort((SortField[])this.keySortFields().toArray(ClassTag$.MODULE$.apply(SortField.class)));
                this.lucene().init(sort, this.fieldsToLoad());
                boxedUnit = BoxedUnit.UNIT;
            }
            catch (Exception e) {
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Initialization of Lucene FS directory for index '", "' has failed"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.idxName()})), (Throwable)e);
                    boxedUnit = BoxedUnit.UNIT;
                }
                boxedUnit = BoxedUnit.UNIT;
            }
            try {
                String mBeanName = "com.stratio.cassandra.lucene:type=Lucene," + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"keyspace=", ",table=", ",index=", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.ksName(), this.cfName(), this.idxName()}));
                this.mBean_$eq(new ObjectName(mBeanName));
                ManagementFactory.getPlatformMBeanServer().registerMBean(this, this.mBean());
            }
            catch (JMException e) {
                BoxedUnit boxedUnit2;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Error while registering Lucene index JMX MBean", (Throwable)e);
                    boxedUnit2 = BoxedUnit.UNIT;
                    break block6;
                }
                boxedUnit2 = BoxedUnit.UNIT;
            }
        }
    }

    public abstract List<SortField> keySortFields();

    public abstract Set<String> fieldsToLoad();

    public abstract List<IndexableField> keyIndexableFields(DecoratedKey var1, Clustering var2);

    public boolean dependsOn(ColumnDefinition columnDef) {
        return this.schema().mapsCell(columnDef.name.toString());
    }

    public Search validate(RowFilter.Expression expression) {
        return this.expressionMapper().search(expression).validate(this.schema());
    }

    public abstract Term term(DecoratedKey var1, Clustering var2);

    public Term term(DecoratedKey key) {
        return this.partitionMapper().term(key);
    }

    public boolean needsReadBeforeWrite(DecoratedKey key, Row row) {
        return this.mapsMultiCell() || !this.mappedRegulars().subsetOf(((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(row.columns()).asScala()).map((Function1<ColumnDefinition, String> & Serializable & scala.Serializable)x$2 -> x$2.name.toString(), Iterable$.MODULE$.canBuildFrom())).toSet());
    }

    public boolean doesAffectIndex(Row row) {
        return !this.options().sparse() || this.mapsPrimaryKey() || ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(row.columns()).asScala()).exists((Function1<ColumnDefinition, Object> & Serializable & scala.Serializable)c -> BoxesRunTime.boxToBoolean(IndexService.$anonfun$doesAffectIndex$1(this, c)));
    }

    public DecoratedKey decoratedKey(Document document) {
        return this.partitionMapper().decoratedKey(document);
    }

    public abstract IndexWriter writer(DecoratedKey var1, int var2, OpOrder.Group var3, IndexTransaction.Type var4);

    public void truncate() {
        this.queue().submitSynchronous((JFunction0$mcV$sp & scala.Serializable)() -> this.lucene().truncate());
    }

    public void delete() {
        block6: {
            try {
                try {
                    this.queue().close();
                    ManagementFactory.getPlatformMBeanServer().unregisterMBean(this.mBean());
                }
                catch (JMException e) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Error while unregistering Lucene index MBean", (Throwable)e);
                        boxedUnit = BoxedUnit.UNIT;
                        break block6;
                    }
                    boxedUnit = BoxedUnit.UNIT;
                }
            }
            finally {
                this.lucene().delete();
            }
        }
    }

    public void upsert(DecoratedKey key, Row row, int nowInSec) {
        this.queue().submitAsynchronous(key, (JFunction0$mcV$sp & scala.Serializable)() -> {
            int partition = this.partitioner().partition(key);
            Clustering clustering = row.clustering();
            Term term = this.term(key, clustering);
            Columns columns = this.columnsMapper().columns(key, row, nowInSec);
            java.util.List<IndexableField> fields = this.schema().indexableFields(columns);
            if (fields.isEmpty()) {
                this.lucene().delete(partition, term);
            } else {
                Document doc = new Document();
                this.keyIndexableFields(key, clustering).foreach((Function1<IndexableField, Object> & Serializable & scala.Serializable)x$1 -> {
                    doc.add(x$1);
                    return BoxedUnit.UNIT;
                });
                fields.forEach(x$3 -> doc.add((IndexableField)x$3));
                this.lucene().upsert(partition, term, doc);
            }
        });
    }

    public void delete(DecoratedKey key, Clustering clustering) {
        this.queue().submitAsynchronous(key, (JFunction0$mcV$sp & scala.Serializable)() -> {
            int partition = this.partitioner().partition(key);
            Term term = this.term(key, clustering);
            this.lucene().delete(partition, term);
        });
    }

    public void delete(DecoratedKey key) {
        this.queue().submitAsynchronous(key, (JFunction0$mcV$sp & scala.Serializable)() -> {
            int partition = this.partitioner().partition(key);
            Term term = this.term(key);
            this.lucene().delete(partition, term);
        });
    }

    public UnfilteredPartitionIterator search(ReadCommand command, ReadExecutionController controller) {
        this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Building Lucene search");
        Search search = this.expressionMapper().search(command);
        Query query = search.query(this.schema(), (Query)this.query(command).orNull(Predef$.MODULE$.$conforms()));
        List<Tuple2<Object, Option<Term>>> afters = this.after(search.paging(), command);
        Sort sort = this.sort(search);
        int count = command.limits().count();
        if (search.refresh()) {
            this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Refreshing Lucene index searcher");
            this.refresh();
        }
        this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene index searching for ", " rows"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(count)})));
        List<Object> partitions = this.partitioner().partitions(command);
        List readers = (List)afters.filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)a -> BoxesRunTime.boxToBoolean(partitions.contains(BoxesRunTime.boxToInteger(a._1$mcI$sp()))));
        DocumentIterator documents = this.lucene().search(readers, query, sort, count);
        return this.reader(documents, command, controller);
    }

    public Option<Query> query(ReadCommand command) {
        Option<Query> option;
        ReadCommand readCommand = command;
        if (readCommand instanceof SinglePartitionReadCommand) {
            SinglePartitionReadCommand singlePartitionReadCommand = (SinglePartitionReadCommand)readCommand;
            DecoratedKey key = singlePartitionReadCommand.partitionKey();
            ClusteringIndexFilter filter = singlePartitionReadCommand.clusteringIndexFilter(key);
            option = new Some<Query>(this.query(key, filter));
        } else if (readCommand instanceof PartitionRangeReadCommand) {
            PartitionRangeReadCommand partitionRangeReadCommand = (PartitionRangeReadCommand)readCommand;
            option = this.query(partitionRangeReadCommand.dataRange());
        } else {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported read command ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{command.getClass()})));
        }
        return option;
    }

    public abstract Query query(DecoratedKey var1, ClusteringIndexFilter var2);

    public abstract Option<Query> query(DataRange var1);

    public List<Tuple2<Object, Option<Term>>> after(IndexPagingState pagingState, ReadCommand command) {
        List<Object> partitions = this.partitioner().partitions(command);
        List afters = pagingState == null ? ((TraversableOnce)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.partitioner().numPartitions()).map((Function1<Object, None$> & Serializable & scala.Serializable)x$4 -> IndexService.$anonfun$after$1(BoxesRunTime.unboxToInt(x$4)), IndexedSeq$.MODULE$.canBuildFrom())).toList() : pagingState.forCommand(command, this.partitioner()).map((Function1<Option, Option> & Serializable & scala.Serializable)x$5 -> x$5.map((Function1<Tuple2, Term> & Serializable & scala.Serializable)x0$1 -> {
            Clustering c;
            Tuple2 tuple2;
            block3: {
                Tuple2 tuple22;
                block2: {
                    tuple22 = x0$1;
                    if (tuple22 == null) break block2;
                    tuple2 = (Tuple2)tuple22._1();
                    c = (Clustering)tuple22._2();
                    if (tuple2 != null) break block3;
                }
                throw new MatchError(tuple22);
            }
            DecoratedKey k = (DecoratedKey)tuple2._2();
            Term term = this.after(k, c);
            return term;
        }), List$.MODULE$.canBuildFrom());
        return partitions.map((Function1<Object, Tuple2> & Serializable & scala.Serializable)i -> IndexService.$anonfun$after$4(afters, BoxesRunTime.unboxToInt(i)), List$.MODULE$.canBuildFrom());
    }

    public abstract Term after(DecoratedKey var1, Clustering var2);

    public Sort sort(Search search) {
        ListBuffer sortFields = (ListBuffer)ListBuffer$.MODULE$.apply(Nil$.MODULE$);
        Object object = search.usesSorting() ? sortFields.$plus$plus$eq((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(search.sortFields(this.schema())).asScala()) : BoxedUnit.UNIT;
        Object object2 = search.usesRelevance() ? sortFields.$plus$eq(SortField.FIELD_SCORE) : BoxedUnit.UNIT;
        sortFields.$plus$plus$eq((TraversableOnce)this.keySortFields());
        return new Sort((SortField[])sortFields.toArray(ClassTag$.MODULE$.apply(SortField.class)));
    }

    public abstract IndexReader reader(DocumentIterator var1, ReadCommand var2, ReadExecutionController var3);

    public void validate(PartitionUpdate update) {
        DecoratedKey key = update.partitionKey();
        int now = FBUtilities.nowInSeconds();
        update.forEach(row -> this.schema().validate(this.columnsMapper().columns(key, (Row)row, now)));
    }

    @Override
    public void commit() {
        this.queue().submitSynchronous((JFunction0$mcV$sp & scala.Serializable)() -> this.lucene().commit());
    }

    @Override
    public long getNumDocs() {
        return this.lucene().getNumDocs();
    }

    @Override
    public long getNumDeletedDocs() {
        return this.lucene().getNumDeletedDocs();
    }

    @Override
    public void forceMerge(int maxNumSegments, boolean doWait) {
        this.queue().submitSynchronous((JFunction0$mcV$sp & scala.Serializable)() -> this.lucene().forceMerge(maxNumSegments, doWait));
    }

    @Override
    public void forceMergeDeletes(boolean doWait) {
        this.queue().submitSynchronous((JFunction0$mcV$sp & scala.Serializable)() -> this.lucene().forceMergeDeletes(doWait));
    }

    @Override
    public void refresh() {
        this.queue().submitSynchronous((JFunction0$mcV$sp & scala.Serializable)() -> this.lucene().refresh());
    }

    public static final /* synthetic */ boolean $anonfun$mapsMultiCell$1(IndexService $this, ColumnDefinition x) {
        return x.type.isMultiCell() && $this.schema().mapsCell(x.name.toString());
    }

    public static final /* synthetic */ boolean $anonfun$mapsPrimaryKey$1(IndexService $this, ColumnDefinition x) {
        return $this.schema().mapsCell(x.name.toString());
    }

    public static final /* synthetic */ boolean $anonfun$doesAffectIndex$1(IndexService $this, ColumnDefinition c) {
        return $this.mappedRegulars().contains(c.name.toString());
    }

    public static final /* synthetic */ None$ $anonfun$after$1(int x$4) {
        return None$.MODULE$;
    }

    public static final /* synthetic */ Tuple2 $anonfun$after$4(List afters$1, int i) {
        return new Tuple2(BoxesRunTime.boxToInteger(i), afters$1.apply(i));
    }

    public IndexService(ColumnFamilyStore table, IndexMetadata indexMetadata) {
        this.table = table;
        this.indexMetadata = indexMetadata;
        StrictLogging.$init$(this);
        Tracing.$init$(this);
        this.metadata = table.metadata;
        this.ksName = this.metadata().ksName;
        this.cfName = this.metadata().cfName;
        this.idxName = indexMetadata.name;
        this.qualifiedName = new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", ".", ".", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.ksName(), this.cfName(), this.idxName()}));
        this.options = new IndexOptions(this.metadata(), indexMetadata);
        this.schema = this.options().schema();
        this.regulars = ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.metadata().partitionColumns().regulars).asScala()).toSet();
        Set<String> set = this.schema().mappedCells();
        this.mappedRegulars = (scala.collection.immutable.Set)((TraversableLike)this.regulars().map((Function1<ColumnDefinition, String> & Serializable & scala.Serializable)x$1 -> x$1.name.toString(), Set$.MODULE$.canBuildFrom())).filter((Function1<Object, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(set.contains(x$1)));
        this.mapsMultiCell = this.regulars().exists((Function1<ColumnDefinition, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean(IndexService.$anonfun$mapsMultiCell$1(this, x)));
        this.mapsPrimaryKey = ((IterableLike)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(this.metadata().primaryKeyColumns()).asScala()).exists((Function1<ColumnDefinition, Object> & Serializable & scala.Serializable)x -> BoxesRunTime.boxToBoolean(IndexService.$anonfun$mapsPrimaryKey$1(this, x)));
        this.tokenMapper = new TokenMapper();
        this.partitionMapper = new PartitionMapper(this.metadata());
        this.columnsMapper = new ColumnsMapper(this.schema(), this.metadata());
        this.expressionMapper = new ExpressionMapper(this.metadata(), indexMetadata);
        this.queue = TaskQueue$.MODULE$.build(this.options().indexingThreads(), this.options().indexingQueuesSize());
        this.partitioner = this.options().partitioner();
        this.lucene = new PartitionedIndex(this.partitioner().numPartitions(), this.idxName(), this.options().path(), this.options().schema().analyzer, this.options().refreshSeconds(), this.options().ramBufferMB(), this.options().maxMergeMB(), this.options().maxCachedMB());
        this.readBeforeWriteLocker = new Locker(DatabaseDescriptor.getConcurrentWriters() * 128);
    }
}

