/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.google.common.collect.Sets;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexReader;
import com.stratio.cassandra.lucene.IndexReaderWide;
import com.stratio.cassandra.lucene.IndexService;
import com.stratio.cassandra.lucene.IndexWriter;
import com.stratio.cassandra.lucene.IndexWriterWide;
import com.stratio.cassandra.lucene.index.DocumentIterator;
import com.stratio.cassandra.lucene.mapping.ClusteringMapper;
import com.stratio.cassandra.lucene.mapping.ClusteringMapper$;
import com.stratio.cassandra.lucene.mapping.KeyMapper;
import com.stratio.cassandra.lucene.mapping.PartitionMapper$;
import java.io.Serializable;
import java.util.Set;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.schema.IndexMetadata;
import org.apache.cassandra.utils.concurrent.OpOrder;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.StringContext;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\tEb\u0001B\u0001\u0003\u0001-\u0011\u0001#\u00138eKb\u001cVM\u001d<jG\u0016<\u0016\u000eZ3\u000b\u0005\r!\u0011A\u00027vG\u0016tWM\u0003\u0002\u0006\r\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000f!\tqa\u001d;sCRLwNC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\ta\u0011J\u001c3fqN+'O^5dK\"I\u0011\u0003\u0001B\u0001B\u0003%!#H\u0001\u0006i\u0006\u0014G.\u001a\t\u0003'mi\u0011\u0001\u0006\u0006\u0003+Y\t!\u0001\u001a2\u000b\u0005\u00159\"B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001eL!\u0001\b\u000b\u0003#\r{G.^7o\r\u0006l\u0017\u000e\\=Ti>\u0014X-\u0003\u0002\u0012\u001d!Iq\u0004\u0001B\u0001B\u0003%\u0001EJ\u0001\u0006S:$W\r\u001f\t\u0003C\u0011j\u0011A\t\u0006\u0003GY\taa]2iK6\f\u0017BA\u0013#\u00055Ie\u000eZ3y\u001b\u0016$\u0018\rZ1uC&\u0011qED\u0001\u000eS:$W\r_'fi\u0006$\u0017\r^1\t\u000b%\u0002A\u0011\u0001\u0016\u0002\rqJg.\u001b;?)\rYC&\f\t\u0003\u001b\u0001AQ!\u0005\u0015A\u0002IAQa\b\u0015A\u0002\u0001Bqa\f\u0001C\u0002\u0013\u0005\u0001'\u0001\tdYV\u001cH/\u001a:j]\u001el\u0015\r\u001d9feV\t\u0011\u0007\u0005\u00023k5\t1G\u0003\u00025\u0005\u00059Q.\u00199qS:<\u0017B\u0001\u001c4\u0005A\u0019E.^:uKJLgnZ'baB,'\u000f\u0003\u00049\u0001\u0001\u0006I!M\u0001\u0012G2,8\u000f^3sS:<W*\u00199qKJ\u0004\u0003b\u0002\u001e\u0001\u0005\u0004%\taO\u0001\nW\u0016LX*\u00199qKJ,\u0012\u0001\u0010\t\u0003euJ!AP\u001a\u0003\u0013-+\u00170T1qa\u0016\u0014\bB\u0002!\u0001A\u0003%A(\u0001\u0006lKfl\u0015\r\u001d9fe\u0002BQA\u0011\u0001\u0005B\r\u000bABZ5fY\u0012\u001cHk\u001c'pC\u0012,\u0012\u0001\u0012\t\u0004\u000b*cU\"\u0001$\u000b\u0005\u001dC\u0015\u0001B;uS2T\u0011!S\u0001\u0005U\u00064\u0018-\u0003\u0002L\r\n\u00191+\u001a;\u0011\u000553fB\u0001(U!\ty%+D\u0001Q\u0015\t\t&\"\u0001\u0004=e>|GO\u0010\u0006\u0002'\u0006)1oY1mC&\u0011QKU\u0001\u0007!J,G-\u001a4\n\u0005]C&AB*ue&twM\u0003\u0002V%\")!\f\u0001C!7\u0006i1.Z=T_J$h)[3mIN,\u0012\u0001\u0018\t\u0004;\n,gB\u00010a\u001d\tyu,C\u0001T\u0013\t\t'+A\u0004qC\u000e\\\u0017mZ3\n\u0005\r$'\u0001\u0002'jgRT!!\u0019*\u0011\u0005\u0019TW\"A4\u000b\u0005!L\u0017AB:fCJ\u001c\u0007N\u0003\u0002\u0004/%\u00111n\u001a\u0002\n'>\u0014HOR5fY\u0012DQ!\u001c\u0001\u0005\u00029\f!b\u00197vgR,'/\u001b8h)\ty'\u000f\u0005\u0002\u0014a&\u0011\u0011\u000f\u0006\u0002\u000b\u00072,8\u000f^3sS:<\u0007\"B:m\u0001\u0004!\u0018\u0001\u00033pGVlWM\u001c;\u0011\u0005U<X\"\u0001<\u000b\u0005ML\u0017B\u0001=w\u0005!!unY;nK:$\b\"\u0002>\u0001\t\u0003Z\u0018AB<sSR,'\u000f\u0006\u0005}\u007f\u0006%\u0011QCA\u0019!\tiQ0\u0003\u0002\u007f\u0005\tY\u0011J\u001c3fq^\u0013\u0018\u000e^3s\u0011\u001d\t\t!\u001fa\u0001\u0003\u0007\t1a[3z!\r\u0019\u0012QA\u0005\u0004\u0003\u000f!\"\u0001\u0004#fG>\u0014\u0018\r^3e\u0017\u0016L\bbBA\u0006s\u0002\u0007\u0011QB\u0001\t]><\u0018J\\*fGB!\u0011qBA\t\u001b\u0005\u0011\u0016bAA\n%\n\u0019\u0011J\u001c;\t\u000f\u0005]\u0011\u00101\u0001\u0002\u001a\u00059q\u000e]$s_V\u0004\b\u0003BA\u000e\u0003WqA!!\b\u0002(5\u0011\u0011q\u0004\u0006\u0005\u0003C\t\u0019#\u0001\u0006d_:\u001cWO\u001d:f]RT1!!\n\u0017\u0003\u0015)H/\u001b7t\u0013\u0011\tI#a\b\u0002\u000f=\u0003xJ\u001d3fe&!\u0011QFA\u0018\u0005\u00159%o\\;q\u0015\u0011\tI#a\b\t\u000f\u0005M\u0012\u00101\u0001\u00026\u0005yAO]1og\u0006\u001cG/[8o)f\u0004X\r\u0005\u0003\u00028\u0005\u0015c\u0002BA\u001d\u0003\u0003j!!a\u000f\u000b\t\u0005u\u0012qH\u0001\riJ\fgn]1di&|gn\u001d\u0006\u0003?YIA!a\u0011\u0002<\u0005\u0001\u0012J\u001c3fqR\u0013\u0018M\\:bGRLwN\\\u0005\u0005\u0003\u000f\nIE\u0001\u0003UsB,'\u0002BA\"\u0003wAq!!\u0014\u0001\t\u0003\ny%\u0001\nlKfLe\u000eZ3yC\ndWMR5fY\u0012\u001cHCBA)\u0003;\ny\u0006\u0005\u0003^E\u0006M\u0003\u0003BA+\u00033j!!a\u0016\u000b\u0005}I\u0017\u0002BA.\u0003/\u0012a\"\u00138eKb\f'\r\\3GS\u0016dG\r\u0003\u0005\u0002\u0002\u0005-\u0003\u0019AA\u0002\u0011\u0019i\u00171\na\u0001_\"9\u00111\r\u0001\u0005\u0002\u0005\u0015\u0014\u0001\u0002;fe6$b!a\u001a\u0002n\u0005=\u0004\u0003BA+\u0003SJA!a\u001b\u0002X\t!A+\u001a:n\u0011!\t\t!!\u0019A\u0002\u0005\r\u0001BB7\u0002b\u0001\u0007q\u000eC\u0004\u0002t\u0001!\t%!\u001e\u0002\u001f\u0011|Wm]!gM\u0016\u001cG/\u00138eKb$B!a\u001e\u0002~A!\u0011qBA=\u0013\r\tYH\u0015\u0002\b\u0005>|G.Z1o\u0011!\ty(!\u001dA\u0002\u0005\u0005\u0015a\u0001:poB!\u00111QAE\u001b\t\t)IC\u0002\u0002\bR\tAA]8xg&!\u00111RAC\u0005\r\u0011vn\u001e\u0005\b\u0003\u001f\u0003A\u0011IAI\u0003\u0015\tX/\u001a:z)\u0019\t\u0019*!'\u0002\u001cB\u0019a-!&\n\u0007\u0005]uMA\u0003Rk\u0016\u0014\u0018\u0010\u0003\u0005\u0002\u0002\u00055\u0005\u0019AA\u0002\u0011!\ti*!$A\u0002\u0005}\u0015A\u00024jYR,'\u000f\u0005\u0003\u0002\"\u0006\u0015VBAAR\u0015\r\ti\nF\u0005\u0005\u0003O\u000b\u0019KA\u000bDYV\u001cH/\u001a:j]\u001eLe\u000eZ3y\r&dG/\u001a:\t\u000f\u0005=\u0005\u0001\"\u0001\u0002,R!\u00111SAW\u0011!\ty+!+A\u0002\u0005E\u0016\u0001\u00039pg&$\u0018n\u001c8\u0011\u0007M\t\u0019,C\u0002\u00026R\u0011\u0011\u0003U1si&$\u0018n\u001c8Q_NLG/[8o\u0011\u001d\ty\t\u0001C\u0001\u0003s#\u0002\"a%\u0002<\u0006u\u0016Q\u001a\u0005\t\u0003_\u000b9\f1\u0001\u00022\"A\u0011qXA\\\u0001\u0004\t\t-A\u0003ti\u0006\u0014H\u000f\u0005\u0004\u0002\u0010\u0005\r\u0017qY\u0005\u0004\u0003\u000b\u0014&AB(qi&|g\u000eE\u0002\u0014\u0003\u0013L1!a3\u0015\u0005A\u0019E.^:uKJLgn\u001a)sK\u001aL\u0007\u0010\u0003\u0005\u0002P\u0006]\u0006\u0019AAa\u0003\u0011\u0019Ho\u001c9\t\u000f\u0005=\u0005\u0001\"\u0011\u0002TR!\u0011Q[Al!\u0019\ty!a1\u0002\u0014\"A\u0011\u0011\\Ai\u0001\u0004\tY.A\u0005eCR\f'+\u00198hKB\u00191#!8\n\u0007\u0005}GCA\u0005ECR\f'+\u00198hK\"9\u00111\u001d\u0001\u0005B\u0005\u0015\u0018!B1gi\u0016\u0014HCBA4\u0003O\fI\u000f\u0003\u0005\u0002\u0002\u0005\u0005\b\u0019AA\u0002\u0011\u0019i\u0017\u0011\u001da\u0001_\"9\u0011Q\u001e\u0001\u0005B\u0005=\u0018A\u0002:fC\u0012,'\u000f\u0006\u0005\u0002r\u0006](Q\u0001B\b!\ri\u00111_\u0005\u0004\u0003k\u0014!aC%oI\u0016D(+Z1eKJD\u0001\"!?\u0002l\u0002\u0007\u00111`\u0001\nI>\u001cW/\\3oiN\u0004B!!@\u0003\u00025\u0011\u0011q \u0006\u0003?\tIAAa\u0001\u0002\u0000\n\u0001Bi\\2v[\u0016tG/\u0013;fe\u0006$xN\u001d\u0005\t\u0005\u000f\tY\u000f1\u0001\u0003\n\u000591m\\7nC:$\u0007cA\n\u0003\f%\u0019!Q\u0002\u000b\u0003\u0017I+\u0017\rZ\"p[6\fg\u000e\u001a\u0005\t\u0005#\tY\u000f1\u0001\u0003\u0014\u0005Q1m\u001c8ue>dG.\u001a:\u0011\u0007M\u0011)\"C\u0002\u0003\u0018Q\u0011qCU3bI\u0016CXmY;uS>t7i\u001c8ue>dG.\u001a:\t\u000f\tm\u0001\u0001\"\u0001\u0003\u001e\u00051A-\u001a7fi\u0016$bAa\b\u0003&\t\u001d\u0002\u0003BA\b\u0005CI1Aa\tS\u0005\u0011)f.\u001b;\t\u0011\u0005\u0005!\u0011\u0004a\u0001\u0003\u0007A\u0001B!\u000b\u0003\u001a\u0001\u0007!1F\u0001\u0006g2L7-\u001a\t\u0004'\t5\u0012b\u0001B\u0018)\t)1\u000b\\5dK\u0002")
public class IndexServiceWide
extends IndexService {
    private final ClusteringMapper clusteringMapper = new ClusteringMapper(this.metadata());
    private final KeyMapper keyMapper = new KeyMapper(this.metadata());

    public ClusteringMapper clusteringMapper() {
        return this.clusteringMapper;
    }

    public KeyMapper keyMapper() {
        return this.keyMapper;
    }

    @Override
    public Set<String> fieldsToLoad() {
        return Sets.newHashSet((Object[])new String[]{PartitionMapper$.MODULE$.FIELD_NAME(), ClusteringMapper$.MODULE$.FIELD_NAME()});
    }

    @Override
    public List<SortField> keySortFields() {
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new SortField[]{this.tokenMapper().sortField(), this.partitionMapper().sortField(), this.clusteringMapper().sortField()}));
    }

    public Clustering clustering(Document document) {
        return this.clusteringMapper().clustering(document);
    }

    @Override
    public IndexWriter writer(DecoratedKey key, int nowInSec, OpOrder.Group opGroup, IndexTransaction.Type transactionType) {
        return new IndexWriterWide(this, key, nowInSec, opGroup, transactionType);
    }

    @Override
    public List<IndexableField> keyIndexableFields(DecoratedKey key, Clustering clustering) {
        ListBuffer fields = (ListBuffer)ListBuffer$.MODULE$.empty();
        fields.$plus$eq(this.tokenMapper().indexableField(key));
        fields.$plus$eq(this.partitionMapper().indexableField(key));
        fields.$plus$eq(this.keyMapper().indexableField(key, clustering));
        fields.$plus$plus$eq((TraversableOnce)this.clusteringMapper().indexableFields(key, clustering));
        return fields.toList();
    }

    @Override
    public Term term(DecoratedKey key, Clustering clustering) {
        return this.keyMapper().term(key, clustering);
    }

    @Override
    public boolean doesAffectIndex(Row row) {
        return !row.isStatic() && super.doesAffectIndex(row);
    }

    @Override
    public Query query(DecoratedKey key, ClusteringIndexFilter filter) {
        Query query;
        ClusteringIndexFilter clusteringIndexFilter = filter;
        if (clusteringIndexFilter.selectsAllPartition()) {
            query = this.partitionMapper().query(key);
        } else if (clusteringIndexFilter instanceof ClusteringIndexNamesFilter) {
            ClusteringIndexNamesFilter clusteringIndexNamesFilter = (ClusteringIndexNamesFilter)clusteringIndexFilter;
            query = this.keyMapper().query(key, clusteringIndexNamesFilter);
        } else if (clusteringIndexFilter instanceof ClusteringIndexSliceFilter) {
            ClusteringIndexSliceFilter clusteringIndexSliceFilter = (ClusteringIndexSliceFilter)clusteringIndexFilter;
            query = this.clusteringMapper().query(key, clusteringIndexSliceFilter);
        } else {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unknown filter type ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{filter})));
        }
        return query;
    }

    public Query query(PartitionPosition position) {
        Query query;
        PartitionPosition partitionPosition = position;
        if (partitionPosition instanceof DecoratedKey) {
            DecoratedKey decoratedKey = (DecoratedKey)partitionPosition;
            query = this.partitionMapper().query(decoratedKey);
        } else {
            query = this.tokenMapper().query(position.getToken());
        }
        return query;
    }

    public Query query(PartitionPosition position, Option<ClusteringPrefix> start, Option<ClusteringPrefix> stop) {
        if (start.isEmpty() && stop.isEmpty()) {
            return this.query(position);
        }
        return new BooleanQuery.Builder().add(this.query(position), BooleanClause.Occur.FILTER).add(this.clusteringMapper().query(position, start, stop), BooleanClause.Occur.FILTER).build();
    }

    @Override
    public Option<Query> query(DataRange dataRange) {
        if (dataRange.isUnrestricted()) {
            return None$.MODULE$;
        }
        PartitionPosition startPosition = dataRange.startKey();
        PartitionPosition stopPosition = dataRange.stopKey();
        Token startToken = startPosition.getToken();
        Token stopToken = stopPosition.getToken();
        Option<ClusteringPrefix> startClustering = ClusteringMapper$.MODULE$.startClusteringPrefix(dataRange).filter((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean(IndexServiceWide.$anonfun$query$1(x$1)));
        Option<ClusteringPrefix> stopClustering = ClusteringMapper$.MODULE$.stopClusteringPrefix(dataRange).filter((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(IndexServiceWide.$anonfun$query$2(x$2)));
        if (startToken.compareTo((Object)stopToken) == 0) {
            if (startClustering.isEmpty() && stopClustering.isEmpty()) {
                return new Some<Query>(this.query(startPosition));
            }
            return new Some<Query>(this.query(startPosition, startClustering, stopClustering));
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        PartitionPosition.Kind kind = startPosition.kind();
        PartitionPosition.Kind kind2 = PartitionPosition.Kind.MIN_BOUND;
        boolean includeStartToken = !(kind != null ? !kind.equals(kind2) : kind2 != null) && startClustering.isEmpty();
        PartitionPosition.Kind kind3 = stopPosition.kind();
        PartitionPosition.Kind kind4 = PartitionPosition.Kind.MAX_BOUND;
        boolean includeStopToken = !(kind3 != null ? !kind3.equals(kind4) : kind4 != null) && stopClustering.isEmpty();
        this.tokenMapper().query(startToken, stopToken, includeStartToken, includeStopToken).foreach((Function1<Query, BooleanQuery.Builder> & Serializable & scala.Serializable)x$3 -> builder.add((Query)x$3, BooleanClause.Occur.SHOULD));
        Object object = startClustering.isDefined() ? builder.add(this.query(startPosition, startClustering, None$.MODULE$), BooleanClause.Occur.SHOULD) : BoxedUnit.UNIT;
        Object object2 = stopClustering.isDefined() ? builder.add(this.query(stopPosition, None$.MODULE$, stopClustering), BooleanClause.Occur.SHOULD) : BoxedUnit.UNIT;
        BooleanQuery booleanQuery = builder.build();
        return booleanQuery.clauses().isEmpty() ? None$.MODULE$ : new Some<BooleanQuery>(booleanQuery);
    }

    @Override
    public Term after(DecoratedKey key, Clustering clustering) {
        return this.keyMapper().term(key, clustering);
    }

    @Override
    public IndexReader reader(DocumentIterator documents, ReadCommand command, ReadExecutionController controller) {
        return new IndexReaderWide(this, command, super.table(), controller, documents);
    }

    public void delete(DecoratedKey key, Slice slice) {
        this.queue().submitAsynchronous(key, (JFunction0$mcV$sp & scala.Serializable)() -> {
            int partition = this.partitioner().partition(key);
            Query query = this.clusteringMapper().query(key, slice);
            this.lucene().delete(partition, query);
        });
    }

    public static final /* synthetic */ boolean $anonfun$query$1(ClusteringPrefix x$1) {
        return x$1.size() > 0;
    }

    public static final /* synthetic */ boolean $anonfun$query$2(ClusteringPrefix x$2) {
        return x$2.size() > 0;
    }

    public IndexServiceWide(ColumnFamilyStore table, IndexMetadata index) {
        super(table, index);
        this.init();
    }
}

