/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexService;
import com.stratio.cassandra.lucene.util.Logging;
import com.stratio.cassandra.lucene.util.Tracer;
import com.stratio.cassandra.lucene.util.Tracing;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.ColumnFamilyStore;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.DeletionTime;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.ReadExecutionController;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterator;
import org.apache.cassandra.db.rows.UnfilteredRowIterators;
import org.apache.cassandra.index.Index;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import scala.Function0;
import scala.Predef$;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.java8.JFunction0$mcV$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005Me!B\u0001\u0003\u0003\u0003Y!aC%oI\u0016DxK]5uKJT!a\u0001\u0003\u0002\r1,8-\u001a8f\u0015\t)a!A\u0005dCN\u001c\u0018M\u001c3sC*\u0011q\u0001C\u0001\bgR\u0014\u0018\r^5p\u0015\u0005I\u0011aA2p[\u000e\u00011#\u0002\u0001\r)5\u001a\u0004CA\u0007\u0013\u001b\u0005q!BA\b\u0011\u0003\u0011a\u0017M\\4\u000b\u0003E\tAA[1wC&\u00111C\u0004\u0002\u0007\u001f\nTWm\u0019;\u0011\u0005UQcB\u0001\f(\u001d\t9BE\u0004\u0002\u0019E9\u0011\u0011d\b\b\u00035ui\u0011a\u0007\u0006\u00039)\ta\u0001\u0010:p_Rt\u0014\"\u0001\u0010\u0002\u0007=\u0014x-\u0003\u0002!C\u00051\u0011\r]1dQ\u0016T\u0011AH\u0005\u0003\u000b\rR!\u0001I\u0011\n\u0005\u00152\u0013!B5oI\u0016D(BA\u0003$\u0013\tA\u0013&A\u0003J]\u0012,\u0007P\u0003\u0002&M%\u00111\u0006\f\u0002\b\u0013:$W\r_3s\u0015\tA\u0013\u0006\u0005\u0002/c5\tqF\u0003\u00021\u0005\u0005!Q\u000f^5m\u0013\t\u0011tFA\u0004M_\u001e<\u0017N\\4\u0011\u00059\"\u0014BA\u001b0\u0005\u001d!&/Y2j]\u001eD\u0001b\u000e\u0001\u0003\u0002\u0003\u0006I\u0001O\u0001\bg\u0016\u0014h/[2f!\tI$(D\u0001\u0003\u0013\tY$A\u0001\u0007J]\u0012,\u0007pU3sm&\u001cW\r\u0003\u0005>\u0001\t\u0005\t\u0015!\u0003?\u0003\rYW-\u001f\t\u0003\u007f\tk\u0011\u0001\u0011\u0006\u0003\u0003\u001a\n!\u0001\u001a2\n\u0005\r\u0003%\u0001\u0004#fG>\u0014\u0018\r^3e\u0017\u0016L\b\u0002C#\u0001\u0005\u0003\u0005\u000b\u0011\u0002$\u0002\u00119|w/\u00138TK\u000e\u0004\"a\u0012&\u000e\u0003!S\u0011!S\u0001\u0006g\u000e\fG.Y\u0005\u0003\u0017\"\u00131!\u00138u\u0011!i\u0005A!A!\u0002\u0013q\u0015aB8q\u000fJ|W\u000f\u001d\t\u0003\u001f^s!\u0001U+\u000e\u0003ES!AU*\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002UM\u0005)Q\u000f^5mg&\u0011a+U\u0001\b\u001fB|%\u000fZ3s\u0013\tA\u0016LA\u0003He>,\bO\u0003\u0002W#\"A1\f\u0001B\u0001B\u0003%A,A\bue\u0006t7/Y2uS>tG+\u001f9f!\ti6M\u0004\u0002_C6\tqL\u0003\u0002aS\u0005aAO]1og\u0006\u001cG/[8og&\u0011!mX\u0001\u0011\u0013:$W\r\u001f+sC:\u001c\u0018m\u0019;j_:L!\u0001Z3\u0003\tQK\b/\u001a\u0006\u0003E~CQa\u001a\u0001\u0005\u0002!\fa\u0001P5oSRtDCB5kW2lg\u000e\u0005\u0002:\u0001!)qG\u001aa\u0001q!)QH\u001aa\u0001}!)QI\u001aa\u0001\r\")QJ\u001aa\u0001\u001d\")1L\u001aa\u00019\"9\u0001\u000f\u0001b\u0001\n\u0003\t\u0018\u0001C7fi\u0006$\u0017\r^1\u0016\u0003I\u0004\"a\u001d<\u000e\u0003QT!!\u001e\u0014\u0002\r\r|gNZ5h\u0013\t9HO\u0001\u0006D\r6+G/\u0019#bi\u0006Da!\u001f\u0001!\u0002\u0013\u0011\u0018!C7fi\u0006$\u0017\r^1!\u0011\u001dY\bA1A\u0005\u0002q\fQ\u0001^1cY\u0016,\u0012! \t\u0003\u007fyL!a !\u0003#\r{G.^7o\r\u0006l\u0017\u000e\\=Ti>\u0014X\rC\u0004\u0002\u0004\u0001\u0001\u000b\u0011B?\u0002\rQ\f'\r\\3!\u0011\u001d\t9\u0001\u0001C!\u0003\u0013\tQAY3hS:$\"!a\u0003\u0011\u0007\u001d\u000bi!C\u0002\u0002\u0010!\u0013A!\u00168ji\"9\u00111\u0003\u0001\u0005B\u0005U\u0011a\u00049beRLG/[8o\t\u0016dW\r^3\u0015\t\u0005-\u0011q\u0003\u0005\t\u00033\t\t\u00021\u0001\u0002\u001c\u0005aA-\u001a7fi&|g\u000eV5nKB\u0019q(!\b\n\u0007\u0005}\u0001I\u0001\u0007EK2,G/[8o)&lW\rC\u0004\u0002$\u0001!\t%!\n\u0002\u001dI\fgnZ3U_6\u00147\u000f^8oKR!\u00111BA\u0014\u0011!\tI#!\tA\u0002\u0005-\u0012!\u0003;p[\n\u001cHo\u001c8f!\ry\u0014QF\u0005\u0004\u0003_\u0001%A\u0004*b]\u001e,Gk\\7cgR|g.\u001a\u0005\b\u0003g\u0001A\u0011IA\u001b\u0003%Ign]3siJ{w\u000f\u0006\u0003\u0002\f\u0005]\u0002\u0002CA\u001d\u0003c\u0001\r!a\u000f\u0002\u0007I|w\u000f\u0005\u0003\u0002>\u0005\rSBAA \u0015\r\t\t\u0005Q\u0001\u0005e><8/\u0003\u0003\u0002F\u0005}\"a\u0001*po\"9\u0011\u0011\n\u0001\u0005B\u0005-\u0013!C;qI\u0006$XMU8x)\u0019\tY!!\u0014\u0002R!A\u0011qJA$\u0001\u0004\tY$\u0001\u0006pY\u0012\u0014vn\u001e#bi\u0006D\u0001\"a\u0015\u0002H\u0001\u0007\u00111H\u0001\u000b]\u0016<(k\\<ECR\f\u0007bBA,\u0001\u0011\u0005\u0013\u0011L\u0001\ne\u0016lwN^3S_^$B!a\u0003\u0002\\!A\u0011\u0011HA+\u0001\u0004\tY\u0004C\u0004\u0002`\u00011\t\"!\u0003\u0002\r\u0011,G.\u001a;f\u0011\u001d\ty\u0006\u0001D\t\u0003G\"B!a\u0003\u0002f!A\u0011\u0011FA1\u0001\u0004\tY\u0003\u0003\u0005\u0002j\u0001\u0001K\u0011BA6\u0003!!(/_%oI\u0016DH\u0003BA\u0006\u0003[B\u0001\"!\u000f\u0002h\u0001\u0007\u00111\b\u0005\u0007K\u00011\t\"!\u001d\u0015\t\u0005-\u00111\u000f\u0005\t\u0003s\ty\u00071\u0001\u0002<!9\u0011q\u000f\u0001\u0005\u0012\u0005e\u0014\u0001\u0002:fC\u0012$B!a\u001f\u0002\u0002B!\u0011QHA?\u0013\u0011\ty(a\u0010\u0003\u0017I{w/\u0013;fe\u0006$xN\u001d\u0005\t\u0003\u0007\u000b)\b1\u0001\u0002\u0006\u000691m\\7nC:$\u0007cA \u0002\b&\u0019\u0011\u0011\u0012!\u00035MKgn\u001a7f!\u0006\u0014H/\u001b;j_:\u0014V-\u00193D_6l\u0017M\u001c3\t\u000f\u00055\u0005\u0001\"\u0012\u0002\n\u00051a-\u001b8jg\"Dq!!%\u0001\r#\tI!\u0001\u0004d_6l\u0017\u000e\u001e")
public abstract class IndexWriter
implements Index.Indexer,
Logging,
Tracing {
    private final IndexService service;
    private final DecoratedKey key;
    private final int nowInSec;
    private final IndexTransaction.Type transactionType;
    private final CFMetaData metadata;
    private final ColumnFamilyStore table;
    private final Tracer tracer;
    private final Logger logger;

    @Override
    public Tracer tracer() {
        return this.tracer;
    }

    @Override
    public void com$stratio$cassandra$lucene$util$Tracing$_setter_$tracer_$eq(Tracer x$1) {
        this.tracer = x$1;
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public CFMetaData metadata() {
        return this.metadata;
    }

    public ColumnFamilyStore table() {
        return this.table;
    }

    public void begin() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Begin transaction ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void partitionDelete(DeletionTime deletionTime) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Delete partition during ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType, deletionTime})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.delete();
    }

    public void rangeTombstone(RangeTombstone tombstone) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Range tombstone during ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType, tombstone})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.delete(tombstone);
    }

    public void insertRow(Row row) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Insert rows during ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType, row})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.tryIndex(row);
    }

    public void updateRow(Row oldRowData, Row newRowData) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Update row during ", ": ", " TO ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType, oldRowData, newRowData})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.tryIndex(newRowData);
    }

    public void removeRow(Row row) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isTraceEnabled()) {
            this.logger().underlying().trace(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Remove row during ", ": ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.transactionType, row})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.tryIndex(row);
    }

    public abstract void delete();

    public abstract void delete(RangeTombstone var1);

    private void tryIndex(Row row) {
        if (this.service.doesAffectIndex(row)) {
            this.index(row);
        } else {
            this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Lucene index skipping row");
        }
    }

    public abstract void index(Row var1);

    public RowIterator read(SinglePartitionReadCommand command) {
        RowIterator rowIterator;
        try (ReadExecutionController controller = command.executionController();){
            UnfilteredRowIterator unfilteredRows = command.queryMemtableAndDisk(this.table(), controller);
            rowIterator = UnfilteredRowIterators.filter((UnfilteredRowIterator)unfilteredRows, (int)this.nowInSec);
        }
        return rowIterator;
    }

    public final void finish() {
        IndexTransaction.Type type = this.transactionType;
        IndexTransaction.Type type2 = IndexTransaction.Type.CLEANUP;
        if (!(type != null ? !type.equals(type2) : type2 != null)) {
            return;
        }
        this.service.readBeforeWriteLocker().run(this.key, (JFunction0$mcV$sp & scala.Serializable)() -> this.commit());
    }

    public abstract void commit();

    public IndexWriter(IndexService service, DecoratedKey key, int nowInSec, OpOrder.Group opGroup, IndexTransaction.Type transactionType) {
        this.service = service;
        this.key = key;
        this.nowInSec = nowInSec;
        this.transactionType = transactionType;
        StrictLogging.$init$(this);
        Tracing.$init$(this);
        this.metadata = service.metadata();
        this.table = service.table();
    }
}

