/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexServiceSkinny;
import com.stratio.cassandra.lucene.IndexWriter;
import java.io.Serializable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.db.rows.RowIterator;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0001Q4A!\u0001\u0002\u0001\u0017\t\t\u0012J\u001c3fq^\u0013\u0018\u000e^3s'.LgN\\=\u000b\u0005\r!\u0011A\u00027vG\u0016tWM\u0003\u0002\u0006\r\u0005I1-Y:tC:$'/\u0019\u0006\u0003\u000f!\tqa\u001d;sCRLwNC\u0001\n\u0003\r\u0019w.\\\u0002\u0001'\t\u0001A\u0002\u0005\u0002\u000e\u001d5\t!!\u0003\u0002\u0010\u0005\tY\u0011J\u001c3fq^\u0013\u0018\u000e^3s\u0011!\t\u0002A!A!\u0002\u0013\u0011\u0012aB:feZL7-\u001a\t\u0003\u001bMI!\u0001\u0006\u0002\u0003%%sG-\u001a=TKJ4\u0018nY3TW&tg.\u001f\u0005\t-\u0001\u0011\t\u0011)A\u0005/\u0005\u00191.Z=\u0011\u0005a\u0001S\"A\r\u000b\u0005iY\u0012A\u00013c\u0015\t)AD\u0003\u0002\u001e=\u00051\u0011\r]1dQ\u0016T\u0011aH\u0001\u0004_J<\u0017BA\u0011\u001a\u00051!UmY8sCR,GmS3z\u0011!\u0019\u0003A!A!\u0002\u0013!\u0013\u0001\u00038po&s7+Z2\u0011\u0005\u0015BS\"\u0001\u0014\u000b\u0003\u001d\nQa]2bY\u0006L!!\u000b\u0014\u0003\u0007%sG\u000f\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003\u001dy\u0007o\u0012:pkB\u0004\"!L\u001b\u000f\u00059\u001aT\"A\u0018\u000b\u0005A\n\u0014AC2p]\u000e,(O]3oi*\u0011!gG\u0001\u0006kRLGn]\u0005\u0003i=\nqa\u00149Pe\u0012,'/\u0003\u00027o\t)qI]8va*\u0011Ag\f\u0005\ts\u0001\u0011\t\u0011)A\u0005u\u0005yAO]1og\u0006\u001cG/[8o)f\u0004X\r\u0005\u0002<\u0007:\u0011A(Q\u0007\u0002{)\u0011ahP\u0001\riJ\fgn]1di&|gn\u001d\u0006\u0003\u0001n\tQ!\u001b8eKbL!AQ\u001f\u0002!%sG-\u001a=Ue\u0006t7/Y2uS>t\u0017B\u0001#F\u0005\u0011!\u0016\u0010]3\u000b\u0005\tk\u0004\"B$\u0001\t\u0003A\u0015A\u0002\u001fj]&$h\b\u0006\u0004J\u0015.cUJ\u0014\t\u0003\u001b\u0001AQ!\u0005$A\u0002IAQA\u0006$A\u0002]AQa\t$A\u0002\u0011BQa\u000b$A\u00021BQ!\u000f$A\u0002iBq\u0001\u0015\u0001A\u0002\u0013%\u0011+A\u0002s_^,\u0012A\u0015\t\u0004KM+\u0016B\u0001+'\u0005\u0019y\u0005\u000f^5p]B\u0011a+W\u0007\u0002/*\u0011\u0001,G\u0001\u0005e><8/\u0003\u0002[/\n\u0019!k\\<\t\u000fq\u0003\u0001\u0019!C\u0005;\u00069!o\\<`I\u0015\fHC\u00010b!\t)s,\u0003\u0002aM\t!QK\\5u\u0011\u001d\u00117,!AA\u0002I\u000b1\u0001\u001f\u00132\u0011\u0019!\u0007\u0001)Q\u0005%\u0006!!o\\<!\u0011\u00151\u0007\u0001\"\u0011h\u0003\u0019!W\r\\3uKR\ta\fC\u0003g\u0001\u0011\u0005\u0013\u000e\u0006\u0002_U\")1\u000e\u001ba\u0001Y\u0006IAo\\7cgR|g.\u001a\t\u000315L!A\\\r\u0003\u001dI\u000bgnZ3U_6\u00147\u000f^8oK\")\u0001\t\u0001C!aR\u0011a,\u001d\u0005\u0006!>\u0004\r!\u0016\u0005\u0006g\u0002!\teZ\u0001\u0007G>lW.\u001b;")
public class IndexWriterSkinny
extends IndexWriter {
    private final IndexServiceSkinny service;
    private final DecoratedKey key;
    private final int nowInSec;
    private final IndexTransaction.Type transactionType;
    private Option<Row> row;

    private Option<Row> row() {
        return this.row;
    }

    private void row_$eq(Option<Row> x$1) {
        this.row = x$1;
    }

    @Override
    public void delete() {
        this.service.delete(this.key);
        this.row_$eq(None$.MODULE$);
    }

    @Override
    public void delete(RangeTombstone tombstone) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isWarnEnabled()) {
            this.logger().underlying().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Ignoring range tombstone ", " in skinny table"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{tombstone})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    @Override
    public void index(Row row) {
        this.row_$eq(Option$.MODULE$.apply(row));
    }

    @Override
    public void commit() {
        this.row().map((Function1<Row, Row> & Serializable & scala.Serializable)row -> {
            Row row2;
            IndexTransaction.Type type = $this.transactionType;
            IndexTransaction.Type type2 = IndexTransaction.Type.COMPACTION;
            if (!(type == null ? type2 != null : !type.equals(type2)) || $this.service.needsReadBeforeWrite($this.key, (Row)row)) {
                this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Lucene index reading before write");
                SinglePartitionReadCommand command = SinglePartitionReadCommand.fullPartitionRead((CFMetaData)this.metadata(), (int)$this.nowInSec, (DecoratedKey)$this.key);
                RowIterator readRows = this.read(command);
                row2 = readRows.hasNext() ? (Row)readRows.next() : row;
            } else {
                row2 = row;
            }
            return row2;
        }).foreach((Function1<Row, Object> & Serializable & scala.Serializable)row -> {
            IndexWriterSkinny.$anonfun$commit$3(this, row);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$commit$3(IndexWriterSkinny $this, Row row) {
        if (row.hasLiveData($this.nowInSec)) {
            $this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Lucene index writing document");
            $this.service.upsert($this.key, row, $this.nowInSec);
        } else {
            $this.tracer().trace((Function0<String> & Serializable & scala.Serializable)() -> "Lucene index deleting document");
            $this.service.delete($this.key);
        }
    }

    public IndexWriterSkinny(IndexServiceSkinny service, DecoratedKey key, int nowInSec, OpOrder.Group opGroup, IndexTransaction.Type transactionType) {
        this.service = service;
        this.key = key;
        this.nowInSec = nowInSec;
        this.transactionType = transactionType;
        super(service, key, nowInSec, opGroup, transactionType);
        this.row = None$.MODULE$;
    }
}

