/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene;

import com.stratio.cassandra.lucene.IndexServiceWide;
import com.stratio.cassandra.lucene.IndexWriter;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.RangeTombstone;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.rows.Row;
import org.apache.cassandra.index.transactions.IndexTransaction;
import org.apache.cassandra.utils.concurrent.OpOrder;
import scala.Function0;
import scala.Function1;
import scala.Serializable;
import scala.collection.JavaConverters$;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001}4A!\u0001\u0002\u0001\u0017\ty\u0011J\u001c3fq^\u0013\u0018\u000e^3s/&$WM\u0003\u0002\u0004\t\u00051A.^2f]\u0016T!!\u0002\u0004\u0002\u0013\r\f7o]1oIJ\f'BA\u0004\t\u0003\u001d\u0019HO]1uS>T\u0011!C\u0001\u0004G>l7\u0001A\n\u0003\u00011\u0001\"!\u0004\b\u000e\u0003\tI!a\u0004\u0002\u0003\u0017%sG-\u001a=Xe&$XM\u001d\u0005\t#\u0001\u0011\t\u0011)A\u0005%\u000591/\u001a:wS\u000e,\u0007CA\u0007\u0014\u0013\t!\"A\u0001\tJ]\u0012,\u0007pU3sm&\u001cWmV5eK\"Aa\u0003\u0001B\u0001B\u0003%q#A\u0002lKf\u0004\"\u0001\u0007\u0011\u000e\u0003eQ!AG\u000e\u0002\u0005\u0011\u0014'BA\u0003\u001d\u0015\tib$\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002?\u0005\u0019qN]4\n\u0005\u0005J\"\u0001\u0004#fG>\u0014\u0018\r^3e\u0017\u0016L\b\u0002C\u0012\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u0013\u0002\u00119|w/\u00138TK\u000e\u0004\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u00121!\u00138u\u0011!Y\u0003A!A!\u0002\u0013a\u0013aB8q\u000fJ|W\u000f\u001d\t\u0003[Ur!AL\u001a\u000e\u0003=R!\u0001M\u0019\u0002\u0015\r|gnY;se\u0016tGO\u0003\u000237\u0005)Q\u000f^5mg&\u0011AgL\u0001\b\u001fB|%\u000fZ3s\u0013\t1tGA\u0003He>,\bO\u0003\u00025_!A\u0011\b\u0001B\u0001B\u0003%!(A\bue\u0006t7/Y2uS>tG+\u001f9f!\tY4I\u0004\u0002=\u00036\tQH\u0003\u0002?\u007f\u0005aAO]1og\u0006\u001cG/[8og*\u0011\u0001iG\u0001\u0006S:$W\r_\u0005\u0003\u0005v\n\u0001#\u00138eKb$&/\u00198tC\u000e$\u0018n\u001c8\n\u0005\u0011+%\u0001\u0002+za\u0016T!AQ\u001f\t\u000b\u001d\u0003A\u0011\u0001%\u0002\rqJg.\u001b;?)\u0019I%j\u0013'N\u001dB\u0011Q\u0002\u0001\u0005\u0006#\u0019\u0003\rA\u0005\u0005\u0006-\u0019\u0003\ra\u0006\u0005\u0006G\u0019\u0003\r\u0001\n\u0005\u0006W\u0019\u0003\r\u0001\f\u0005\u0006s\u0019\u0003\rA\u000f\u0005\b!\u0002\u0011\r\u0011\"\u0003R\u0003-\u0019G.^:uKJLgnZ:\u0016\u0003I\u00032a\u0015-[\u001b\u0005!&BA+W\u0003\u0011)H/\u001b7\u000b\u0003]\u000bAA[1wC&\u0011\u0011\f\u0016\u0002\b)J,WmU3u!\tA2,\u0003\u0002]3\tQ1\t\\;ti\u0016\u0014\u0018N\\4\t\ry\u0003\u0001\u0015!\u0003S\u00031\u0019G.^:uKJLgnZ:!\u0011\u001d\u0001\u0007A1A\u0005\n\u0005\fAA]8xgV\t!\r\u0005\u0003TGj+\u0017B\u00013U\u0005\u001d!&/Z3NCB\u0004\"A\u001a5\u000e\u0003\u001dT!\u0001Y\r\n\u0005%<'a\u0001*po\"11\u000e\u0001Q\u0001\n\t\fQA]8xg\u0002BQ!\u001c\u0001\u0005B9\fa\u0001Z3mKR,G#A8\u0011\u0005\u0015\u0002\u0018BA9'\u0005\u0011)f.\u001b;\t\u000b5\u0004A\u0011I:\u0015\u0005=$\b\"B;s\u0001\u00041\u0018!\u0003;p[\n\u001cHo\u001c8f!\tAr/\u0003\u0002y3\tq!+\u00198hKR{WNY:u_:,\u0007\"\u0002!\u0001\t\u0003RHCA8|\u0011\u0015a\u0018\u00101\u0001f\u0003\r\u0011xn\u001e\u0005\u0006}\u0002!\tE\\\u0001\u0007G>lW.\u001b;")
public class IndexWriterWide
extends IndexWriter {
    private final IndexServiceWide service;
    private final DecoratedKey key;
    private final int nowInSec;
    private final TreeSet<Clustering> clusterings;
    private final TreeMap<Clustering, Row> rows;

    private TreeSet<Clustering> clusterings() {
        return this.clusterings;
    }

    private TreeMap<Clustering, Row> rows() {
        return this.rows;
    }

    @Override
    public void delete() {
        this.service.delete(this.key);
        this.clusterings().clear();
        this.rows().clear();
    }

    @Override
    public void delete(RangeTombstone tombstone) {
        Slice slice = tombstone.deletedSlice();
        this.service.delete(this.key, slice);
        this.clusterings().removeIf(x$1 -> slice.includes($this.metadata().comparator, (ClusteringPrefix)x$1));
        this.rows().keySet().removeIf(x$2 -> slice.includes($this.metadata().comparator, (ClusteringPrefix)x$2));
    }

    @Override
    public void index(Row row) {
        Clustering clustering = row.clustering();
        if (this.service.needsReadBeforeWrite(this.key, row)) {
            this.tracer().trace((Function0<String> & java.io.Serializable & Serializable)() -> "Lucene index doing read before write");
            this.clusterings().add(clustering);
        } else {
            this.tracer().trace((Function0<String> & java.io.Serializable & Serializable)() -> "Lucene index skipping read before write");
            this.rows().put(clustering, row);
        }
    }

    @Override
    public void commit() {
        if (!this.clusterings().isEmpty()) {
            SinglePartitionReadCommand command = SinglePartitionReadCommand.create((CFMetaData)this.metadata(), (int)this.nowInSec, (DecoratedKey)this.key, this.clusterings());
            JavaConverters$.MODULE$.asScalaIteratorConverter(this.read(command)).asScala().foreach((Function1<Row, Row> & java.io.Serializable & Serializable)row -> this.rows().put(row.clustering(), (Row)row));
        }
        this.rows().forEach((clustering, row) -> {
            if (row.hasLiveData($this.nowInSec)) {
                this.tracer().trace((Function0<String> & java.io.Serializable & Serializable)() -> "Lucene index writing document");
                $this.service.upsert($this.key, (Row)row, $this.nowInSec);
            } else {
                this.tracer().trace((Function0<String> & java.io.Serializable & Serializable)() -> "Lucene index deleting document");
                $this.service.delete($this.key, (Clustering)clustering);
            }
        });
    }

    public IndexWriterWide(IndexServiceWide service, DecoratedKey key, int nowInSec, OpOrder.Group opGroup, IndexTransaction.Type transactionType) {
        this.service = service;
        this.key = key;
        this.nowInSec = nowInSec;
        super(service, key, nowInSec, opGroup, transactionType);
        this.clusterings = new TreeSet(this.metadata().comparator);
        this.rows = new TreeMap(this.metadata().comparator);
    }
}

