/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.stratio.cassandra.lucene.IndexException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.UUID;
import org.apache.cassandra.utils.UUIDGen;

public class DateParser {
    public static final String DEFAULT_PATTERN = "yyyy/MM/dd HH:mm:ss.SSS Z";
    public final String pattern;
    private final ThreadLocal<DateFormat> formatter;

    public DateParser(String pattern) {
        this.pattern = pattern == null ? DEFAULT_PATTERN : pattern;
        this.formatter = DateParser.formatter(this.pattern);
    }

    private static ThreadLocal<DateFormat> formatter(String pattern) {
        new SimpleDateFormat(pattern);
        ThreadLocal<DateFormat> formatter = ThreadLocal.withInitial(() -> new SimpleDateFormat(pattern));
        formatter.get().setLenient(false);
        return formatter;
    }

    public final <K> Date parse(K value) {
        if (value == null) {
            return null;
        }
        try {
            if (value instanceof Date) {
                Date date = (Date)value;
                if (date.getTime() == Long.MAX_VALUE || date.getTime() == Long.MIN_VALUE) {
                    return date;
                }
                String string = this.formatter.get().format(date);
                return this.formatter.get().parse(string);
            }
            if (value instanceof UUID) {
                long timestamp = UUIDGen.unixTimestamp((UUID)((UUID)value));
                Date date = new Date(timestamp);
                return this.formatter.get().parse(this.formatter.get().format(date));
            }
            if (Number.class.isAssignableFrom(value.getClass())) {
                Long number = ((Number)value).longValue();
                return this.formatter.get().parse(number.toString());
            }
            return this.formatter.get().parse(value.toString());
        }
        catch (Exception e) {
            throw new IndexException(e, "Error parsing {} with value '{}' using date pattern {}", (Object)value.getClass().getSimpleName(), value, (Object)this.pattern);
        }
    }

    public String toString(Date date) {
        return this.formatter.get().format(date);
    }

    public String toString() {
        return this.pattern;
    }
}

