/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.base.MoreObjects;
import com.spatial4j.core.distance.DistanceUtils;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoDistanceUnit;

public final class GeoDistance
implements Comparable<GeoDistance> {
    private final double value;
    private final GeoDistanceUnit unit;

    private GeoDistance(double value, GeoDistanceUnit unit) {
        this.value = value;
        this.unit = unit;
    }

    public double getValue(GeoDistanceUnit unit) {
        return this.unit.getMetres() * this.value / unit.getMetres();
    }

    public double getDegrees() {
        double kms = this.getValue(GeoDistanceUnit.KILOMETRES);
        return DistanceUtils.dist2Degrees(kms, 6371.0087714);
    }

    @JsonCreator
    public static GeoDistance parse(String json2) {
        try {
            String unit = null;
            for (GeoDistanceUnit geoDistanceUnit : GeoDistanceUnit.values()) {
                for (String name : geoDistanceUnit.getNames()) {
                    if (!json2.endsWith(name) || unit != null && unit.length() >= name.length()) continue;
                    unit = name;
                }
            }
            if (unit != null) {
                double value = Double.parseDouble(json2.substring(0, json2.indexOf(unit)));
                return new GeoDistance(value, GeoDistanceUnit.create(unit));
            }
            double value = Double.parseDouble(json2);
            return new GeoDistance(value, GeoDistanceUnit.METRES);
        }
        catch (Exception e) {
            throw new IndexException(e, "Unparseable distance: {}", (Object)json2);
        }
    }

    @Override
    public int compareTo(GeoDistance other) {
        return Double.valueOf(this.getValue(GeoDistanceUnit.MILLIMETRES)).compareTo(other.getValue(GeoDistanceUnit.MILLIMETRES));
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("value", this.value).add("unit", (Object)this.unit).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoDistance that = (GeoDistance)o;
        return Double.compare(that.value, this.value) == 0 && this.unit == that.unit;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.value);
        int result2 = (int)(temp ^ temp >>> 32);
        result2 = 31 * result2 + (this.unit != null ? this.unit.hashCode() : 0);
        return result2;
    }
}

