/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonCreator;

public enum GeoDistanceUnit {
    MILLIMETRES(0.001, "mm", "millimetres"),
    CENTIMETRES(0.01, "cm", "centimetres"),
    DECIMETRES(0.1, "dm", "decimetres"),
    DECAMETRES(10.0, "dam", "decametres"),
    HECTOMETRES(100.0, "hm", "hectometres"),
    KILOMETRES(1000.0, "km", "kilometres"),
    FOOTS(0.3048, "ft", "foots"),
    YARDS(0.9144, "yd", "yards"),
    INCHES(0.0254, "in", "inches"),
    MILES(1609.344, "mi", "miles"),
    METRES(1.0, "m", "metres"),
    NAUTICAL_MILES(1850.0, "M", "NM", "mil", "nautical_miles");

    private final String[] names;
    private final Double metres;

    private GeoDistanceUnit(double metres, String ... names) {
        this.names = names;
        this.metres = metres;
    }

    public Double getMetres() {
        return this.metres;
    }

    public String[] getNames() {
        return this.names;
    }

    @JsonCreator
    public static GeoDistanceUnit create(String value) {
        if (value == null) {
            throw new IllegalArgumentException();
        }
        for (GeoDistanceUnit v : GeoDistanceUnit.values()) {
            for (String s : v.names) {
                if (!s.equals(value)) continue;
                return v;
            }
        }
        throw new IllegalArgumentException();
    }
}

