/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.stratio.cassandra.lucene.IndexException;
import org.apache.lucene.spatial.query.SpatialOperation;

public enum GeoOperation {
    INTERSECTS("intersects", SpatialOperation.Intersects),
    IS_WITHIN("is_within", SpatialOperation.IsWithin),
    CONTAINS("contains", SpatialOperation.Contains);

    private final String name;
    private final SpatialOperation spatialOperation;

    private GeoOperation(String name, SpatialOperation spatialOperation) {
        this.name = name;
        this.spatialOperation = spatialOperation;
    }

    public SpatialOperation getSpatialOperation() {
        return this.spatialOperation;
    }

    @JsonCreator
    public static GeoOperation parse(String value) {
        for (GeoOperation geoOperation : GeoOperation.values()) {
            String name = geoOperation.name;
            if (!name.equalsIgnoreCase(value)) continue;
            return geoOperation;
        }
        throw new IndexException("Invalid geographic operation {}", (Object)value);
    }
}

