/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.common.GeoDistance;
import com.stratio.cassandra.lucene.common.GeospatialUtilsJTS;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.util.Arrays;
import java.util.List;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type", defaultImpl=WKT.class)
@JsonSubTypes(value={@JsonSubTypes.Type(value=WKT.class, name="wkt"), @JsonSubTypes.Type(value=BBox.class, name="bbox"), @JsonSubTypes.Type(value=Buffer.class, name="buffer"), @JsonSubTypes.Type(value=Centroid.class, name="centroid"), @JsonSubTypes.Type(value=ConvexHull.class, name="convex_hull"), @JsonSubTypes.Type(value=Difference.class, name="difference"), @JsonSubTypes.Type(value=Intersection.class, name="intersection"), @JsonSubTypes.Type(value=Union.class, name="union")})
public interface GeoShape {
    public JtsGeometry apply();

    public static class Union
    implements GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        @JsonCreator
        public Union(GeoShape ... shapes) {
            this.shapes = Arrays.asList(shapes);
        }

        @Override
        public JtsGeometry apply() {
            Geometry result2 = this.shapes.get(0).apply().getGeom();
            for (int i = 1; i < this.shapes.size(); ++i) {
                result2 = result2.union(this.shapes.get(i).apply().getGeom());
            }
            return GeospatialUtilsJTS.CONTEXT.makeShape(result2);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("shapes", this.shapes).toString();
        }
    }

    public static class Intersection
    implements GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        @JsonCreator
        public Intersection(GeoShape ... shapes) {
            this.shapes = Arrays.asList(shapes);
        }

        @Override
        public JtsGeometry apply() {
            Geometry result2 = this.shapes.get(0).apply().getGeom();
            for (int i = 1; i < this.shapes.size(); ++i) {
                result2 = result2.intersection(this.shapes.get(i).apply().getGeom());
            }
            return GeospatialUtilsJTS.CONTEXT.makeShape(result2);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("shapes", this.shapes).toString();
        }
    }

    public static class Difference
    implements GeoShape {
        @JsonProperty(value="shapes")
        public final List<GeoShape> shapes;

        @JsonCreator
        public Difference(GeoShape ... shapes) {
            this.shapes = Arrays.asList(shapes);
        }

        @Override
        public JtsGeometry apply() {
            Geometry result2 = this.shapes.get(0).apply().getGeom();
            for (int i = 1; i < this.shapes.size(); ++i) {
                result2 = result2.difference(this.shapes.get(i).apply().getGeom());
            }
            return GeospatialUtilsJTS.CONTEXT.makeShape(result2);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("shapes", this.shapes).toString();
        }
    }

    public static class ConvexHull
    implements GeoShape {
        @JsonProperty(value="shape")
        public final GeoShape shape;

        @JsonCreator
        public ConvexHull(@JsonProperty(value="shape") GeoShape shape) {
            this.shape = shape;
        }

        @Override
        public JtsGeometry apply() {
            Geometry centroid = this.shape.apply().getGeom().convexHull();
            return GeospatialUtilsJTS.CONTEXT.makeShape(centroid);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class Centroid
    implements GeoShape {
        @JsonProperty(value="shape")
        public final GeoShape shape;

        @JsonCreator
        public Centroid(@JsonProperty(value="shape") GeoShape shape) {
            this.shape = shape;
        }

        @Override
        public JtsGeometry apply() {
            Point centroid = this.shape.apply().getGeom().getCentroid();
            return GeospatialUtilsJTS.CONTEXT.makeShape((Geometry)centroid);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class Buffer
    implements GeoShape {
        @JsonProperty(value="shape")
        public final GeoShape shape;
        @JsonProperty(value="max_distance")
        public final GeoDistance maxDistance;
        @JsonProperty(value="min_distance")
        public final GeoDistance minDistance;

        @JsonCreator
        public Buffer(@JsonProperty(value="shape") GeoShape shape, @JsonProperty(value="min_distance") GeoDistance minDistance, @JsonProperty(value="max_distance") GeoDistance maxDistance) {
            this.shape = shape;
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public JtsGeometry apply() {
            JtsGeometry max;
            JtsGeometry jts = this.shape.apply();
            JtsGeometry jtsGeometry = max = this.maxDistance == null ? GeospatialUtilsJTS.CONTEXT.makeShape(jts.getGeom()) : jts.getBuffered(this.maxDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
            if (this.minDistance != null) {
                JtsGeometry min = jts.getBuffered(this.minDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
                Geometry difference = max.getGeom().difference(min.getGeom());
                return GeospatialUtilsJTS.CONTEXT.makeShape(difference);
            }
            return max;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("minDistance", (Object)this.minDistance).add("maxDistance", (Object)this.maxDistance).toString();
        }
    }

    public static class BBox
    implements GeoShape {
        @JsonProperty(value="shape")
        public final GeoShape shape;

        @JsonCreator
        public BBox(@JsonProperty(value="shape") GeoShape shape) {
            this.shape = shape;
        }

        @Override
        public JtsGeometry apply() {
            Rectangle rectangle = this.shape.apply().getBoundingBox();
            Geometry geometry = GeospatialUtilsJTS.CONTEXT.getGeometryFrom(rectangle);
            return GeospatialUtilsJTS.CONTEXT.makeShape(geometry);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class WKT
    implements GeoShape {
        @JsonProperty(value="value")
        public final String value;

        @JsonCreator
        public WKT(@JsonProperty(value="value") String value) {
            this.value = value;
        }

        @Override
        public JtsGeometry apply() {
            return GeospatialUtilsJTS.geometry(this.value);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("value", (Object)this.value).toString();
        }
    }
}

