/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.Rectangle;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.common.GeoDistance;
import com.stratio.cassandra.lucene.common.GeospatialUtilsJTS;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=BBox.class, name="bbox"), @JsonSubTypes.Type(value=Buffer.class, name="buffer"), @JsonSubTypes.Type(value=Centroid.class, name="centroid"), @JsonSubTypes.Type(value=ConvexHull.class, name="convex_hull")})
public interface GeoTransformation {
    public JtsGeometry apply(JtsGeometry var1);

    public static class ConvexHull
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Geometry centroid = shape.getGeom().convexHull();
            return GeospatialUtilsJTS.CONTEXT.makeShape(centroid);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class Centroid
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Point centroid = shape.getGeom().getCentroid();
            return GeospatialUtilsJTS.CONTEXT.makeShape((Geometry)centroid);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }

    public static class Buffer
    implements GeoTransformation {
        @JsonProperty(value="max_distance")
        public final GeoDistance maxDistance;
        @JsonProperty(value="min_distance")
        public final GeoDistance minDistance;

        @JsonCreator
        public Buffer(@JsonProperty(value="min_distance") GeoDistance minDistance, @JsonProperty(value="max_distance") GeoDistance maxDistance) {
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
        }

        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            JtsGeometry max;
            JtsGeometry jtsGeometry = max = this.maxDistance == null ? GeospatialUtilsJTS.CONTEXT.makeShape(shape.getGeom()) : shape.getBuffered(this.maxDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
            if (this.minDistance != null) {
                JtsGeometry min = shape.getBuffered(this.minDistance.getDegrees(), GeospatialUtilsJTS.CONTEXT);
                Geometry difference = max.getGeom().difference(min.getGeom());
                return GeospatialUtilsJTS.CONTEXT.makeShape(difference);
            }
            return max;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("minDistance", (Object)this.minDistance).add("maxDistance", (Object)this.maxDistance).toString();
        }
    }

    public static class BBox
    implements GeoTransformation {
        @Override
        public JtsGeometry apply(JtsGeometry shape) {
            Rectangle rectangle = shape.getBoundingBox();
            Geometry geometry = GeospatialUtilsJTS.CONTEXT.getGeometryFrom(rectangle);
            return GeospatialUtilsJTS.CONTEXT.makeShape(geometry);
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).toString();
        }
    }
}

