/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.spatial4j.core.context.SpatialContext;
import com.stratio.cassandra.lucene.IndexException;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;

public class GeospatialUtils {
    public static final SpatialContext CONTEXT = SpatialContext.GEO;
    public static final double MIN_LATITUDE = -90.0;
    public static final double MAX_LATITUDE = 90.0;
    public static final double MIN_LONGITUDE = -180.0;
    public static final double MAX_LONGITUDE = 180.0;

    public static int validateGeohashMaxLevels(Integer userMaxLevels, int defaultMaxLevels) {
        int maxLevels;
        int n = maxLevels = userMaxLevels == null ? defaultMaxLevels : userMaxLevels;
        if (maxLevels < 1 || maxLevels > GeohashPrefixTree.getMaxLevelsPossible()) {
            throw new IndexException("max_levels must be in range [1, {}], but found {}", GeohashPrefixTree.getMaxLevelsPossible(), (Object)maxLevels);
        }
        return maxLevels;
    }

    public static Double checkLatitude(String name, Double latitude) {
        if (latitude == null) {
            throw new IndexException("{} required", (Object)name);
        }
        if (latitude < -90.0 || latitude > 90.0) {
            throw new IndexException("{} must be in range [{}, {}], but found {}", (Object)name, (Object)-90.0, (Object)90.0, (Object)latitude);
        }
        return latitude;
    }

    public static Double checkLongitude(String name, Double longitude) {
        if (longitude == null) {
            throw new IndexException("{} required", (Object)name);
        }
        if (longitude < -180.0 || longitude > 180.0) {
            throw new IndexException("{} must be in range [{}, {}], but found {}", (Object)name, (Object)-180.0, (Object)180.0, (Object)longitude);
        }
        return longitude;
    }
}

