/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.common;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;

public final class JsonSerializer {
    public static final JsonSerializer INSTANCE = new JsonSerializer();
    public final ObjectMapper mapper = new ObjectMapper();

    private JsonSerializer() {
        this.mapper.configure(JsonGenerator.Feature.QUOTE_FIELD_NAMES, false);
        this.mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_FIELD_NAMES, true);
        this.mapper.configure(MapperFeature.AUTO_DETECT_IS_GETTERS, false);
        this.mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, true);
        this.mapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        this.mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
    }

    public static String toString(Object value) throws IOException {
        return JsonSerializer.INSTANCE.mapper.writeValueAsString(value);
    }

    public static <T> T fromString(String value, Class<T> valueType) throws IOException {
        return JsonSerializer.INSTANCE.mapper.readValue(value, valueType);
    }
}

