/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.index;

import com.stratio.cassandra.lucene.index.NoIDFSimilarity;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Set;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.index.SortingMergePolicy;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TieredMergePolicy;
import org.apache.lucene.index.TrackingIndexWriter;
import org.apache.lucene.search.ControlledRealTimeReopenThread;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherFactory;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.NRTCachingDirectory;
import scala.Function1;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005mf\u0001B\u0001\u0003\u00015\u0011qAR*J]\u0012,\u0007P\u0003\u0002\u0004\t\u0005)\u0011N\u001c3fq*\u0011QAB\u0001\u0007YV\u001cWM\\3\u000b\u0005\u001dA\u0011!C2bgN\fg\u000e\u001a:b\u0015\tI!\"A\u0004tiJ\fG/[8\u000b\u0003-\t1aY8n\u0007\u0001\u0019\"\u0001\u0001\b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g\u0011!)\u0002A!A!\u0002\u00131\u0012\u0001\u00028b[\u0016\u0004\"a\u0006\u0010\u000f\u0005aa\u0002CA\r\u0011\u001b\u0005Q\"BA\u000e\r\u0003\u0019a$o\\8u}%\u0011Q\u0004E\u0001\u0007!J,G-\u001a4\n\u0005}\u0001#AB*ue&twM\u0003\u0002\u001e!!A!\u0005\u0001B\u0001B\u0003%1%\u0001\u0003qCRD\u0007C\u0001\u0013,\u001b\u0005)#B\u0001\u0014(\u0003\u00111\u0017\u000e\\3\u000b\u0005!J\u0013a\u00018j_*\t!&\u0001\u0003kCZ\f\u0017B\u0001\u0017&\u0005\u0011\u0001\u0016\r\u001e5\t\u00119\u0002!\u0011!Q\u0001\n=\n\u0001\"\u00198bYfTXM\u001d\t\u0003aaj\u0011!\r\u0006\u0003eM\n\u0001\"\u00198bYf\u001c\u0018n\u001d\u0006\u0003\u000bQR!!\u000e\u001c\u0002\r\u0005\u0004\u0018m\u00195f\u0015\u00059\u0014aA8sO&\u0011\u0011(\r\u0002\t\u0003:\fG.\u001f>fe\"A1\b\u0001B\u0001B\u0003%A(\u0001\bsK\u001a\u0014Xm\u001d5TK\u000e|g\u000eZ:\u0011\u0005=i\u0014B\u0001 \u0011\u0005\u0019!u.\u001e2mK\"A\u0001\t\u0001B\u0001B\u0003%\u0011)A\u0006sC6\u0014UO\u001a4fe6\u0013\u0005CA\bC\u0013\t\u0019\u0005CA\u0002J]RD\u0001\"\u0012\u0001\u0003\u0002\u0003\u0006I!Q\u0001\u000b[\u0006DX*\u001a:hK6\u0013\u0005\u0002C$\u0001\u0005\u0003\u0005\u000b\u0011B!\u0002\u00175\f\u0007pQ1dQ\u0016$WJ\u0011\u0005\u0006\u0013\u0002!\tAS\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0011-kej\u0014)R%N\u0003\"\u0001\u0014\u0001\u000e\u0003\tAQ!\u0006%A\u0002YAQA\t%A\u0002\rBQA\f%A\u0002=BQa\u000f%A\u0002qBQ\u0001\u0011%A\u0002\u0005CQ!\u0012%A\u0002\u0005CQa\u0012%A\u0002\u0005C\u0011\"\u0016\u0001A\u0002\u0003\u0005\u000b\u0015\u0002,\u0002\u00135,'oZ3T_J$\bCA,[\u001b\u0005A&BA-4\u0003\u0019\u0019X-\u0019:dQ&\u00111\f\u0017\u0002\u0005'>\u0014H\u000fC\u0005^\u0001\u0001\u0007\t\u0011)Q\u0005=\u00061a-[3mIN\u00042a\u00182\u0017\u001b\u0005\u0001'BA1*\u0003\u0011)H/\u001b7\n\u0005\r\u0004'aA*fi\"IQ\r\u0001a\u0001\u0002\u0003\u0006KAZ\u0001\nI&\u0014Xm\u0019;pef\u0004\"a\u001a6\u000e\u0003!T!![\u001a\u0002\u000bM$xN]3\n\u0005-D'!\u0003#je\u0016\u001cGo\u001c:z\u0011%i\u0007\u00011A\u0001B\u0003&a.\u0001\u0004xe&$XM\u001d\t\u0003_Fl\u0011\u0001\u001d\u0006\u0003\u0007MJ!A\u001d9\u0003\u0017%sG-\u001a=Xe&$XM\u001d\u0005\ni\u0002\u0001\r\u0011!Q!\nU\fq!\\1oC\u001e,'\u000f\u0005\u0002Xm&\u0011q\u000f\u0017\u0002\u0010'\u0016\f'o\u00195fe6\u000bg.Y4fe\"I\u0011\u0010\u0001a\u0001\u0002\u0003\u0006KA_\u0001\te\u0016|\u0007/\u001a8feB\u0019qk_?\n\u0005qD&AH\"p]R\u0014x\u000e\u001c7fIJ+\u0017\r\u001c+j[\u0016\u0014Vm\u001c9f]RC'/Z1e!\t9f0\u0003\u0002\u00001\ni\u0011J\u001c3fqN+\u0017M]2iKJDq!a\u0001\u0001\t\u0003\t)!\u0001\u0003j]&$HCBA\u0004\u0003\u001b\ty\u0001E\u0002\u0010\u0003\u0013I1!a\u0003\u0011\u0005\u0011)f.\u001b;\t\rU\u000b\t\u00011\u0001W\u0011\u0019i\u0016\u0011\u0001a\u0001=\"A\u00111\u0003\u0001!\n\u0013\t)\"\u0001\be_^KG\u000f[*fCJ\u001c\u0007.\u001a:\u0016\t\u0005]\u0011Q\u0004\u000b\u0005\u00033\ty\u0003\u0005\u0003\u0002\u001c\u0005uA\u0002\u0001\u0003\t\u0003?\t\tB1\u0001\u0002\"\t\t\u0011)\u0005\u0003\u0002$\u0005%\u0002cA\b\u0002&%\u0019\u0011q\u0005\t\u0003\u000f9{G\u000f[5oOB\u0019q\"a\u000b\n\u0007\u00055\u0002CA\u0002B]fD\u0001\"!\r\u0002\u0012\u0001\u0007\u00111G\u0001\u0002MB1q\"!\u000e~\u00033I1!a\u000e\u0011\u0005%1UO\\2uS>t\u0017\u0007C\u0004\u0002<\u0001!\t!!\u0010\u0002\u001fM,\u0017M]2iKJl\u0015M\\1hKJ,\u0012!\u001e\u0005\b\u0003\u0003\u0002A\u0011AA\"\u0003\u0019)\bo]3siR1\u0011qAA#\u0003\u001fB\u0001\"a\u0012\u0002@\u0001\u0007\u0011\u0011J\u0001\u0005i\u0016\u0014X\u000eE\u0002p\u0003\u0017J1!!\u0014q\u0005\u0011!VM]7\t\u0011\u0005E\u0013q\ba\u0001\u0003'\n\u0001\u0002Z8dk6,g\u000e\u001e\t\u0005\u0003+\nI&\u0004\u0002\u0002X)\u0019\u0011\u0011K\u001a\n\t\u0005m\u0013q\u000b\u0002\t\t>\u001cW/\\3oi\"9\u0011q\f\u0001\u0005\u0002\u0005\u0005\u0014A\u00023fY\u0016$X\r\u0006\u0003\u0002\b\u0005\r\u0004\u0002CA$\u0003;\u0002\r!!\u0013\t\u000f\u0005}\u0003\u0001\"\u0001\u0002hQ!\u0011qAA5\u0011!\tY'!\u001aA\u0002\u00055\u0014!B9vKJL\bcA,\u0002p%\u0019\u0011\u0011\u000f-\u0003\u000bE+XM]=\t\u000f\u0005U\u0004\u0001\"\u0001\u0002x\u0005AAO];oG\u0006$X\r\u0006\u0002\u0002\b!9\u00111\u0010\u0001\u0005\u0002\u0005]\u0014AB2p[6LG\u000fC\u0004\u0002\u0000\u0001!\t!a\u001e\u0002\u000b\rdwn]3\t\u000f\u0005}\u0003\u0001\"\u0001\u0002x!9\u0011Q\u0011\u0001\u0005\u0002\u0005\u001d\u0015AC4fi:+X\u000eR8dgV\t\u0011\tC\u0004\u0002\f\u0002!\t!a\"\u0002#\u001d,GOT;n\t\u0016dW\r^3e\t>\u001c7\u000fC\u0004\u0002\u0010\u0002!\t!!%\u0002\u0015\u0019|'oY3NKJ<W\r\u0006\u0004\u0002\b\u0005M\u0015q\u0013\u0005\b\u0003+\u000bi\t1\u0001B\u00039i\u0017\r\u001f(v[N+w-\\3oiND\u0001\"!'\u0002\u000e\u0002\u0007\u00111T\u0001\u0007I><\u0016-\u001b;\u0011\u0007=\ti*C\u0002\u0002 B\u0011qAQ8pY\u0016\fg\u000eC\u0004\u0002$\u0002!\t!!*\u0002#\u0019|'oY3NKJ<W\rR3mKR,7\u000f\u0006\u0003\u0002\b\u0005\u001d\u0006\u0002CAM\u0003C\u0003\r!a'\t\u000f\u0005-\u0006\u0001\"\u0001\u0002x\u00059!/\u001a4sKNDwaBAX\u0005!\u0005\u0011\u0011W\u0001\b\rNKe\u000eZ3y!\ra\u00151\u0017\u0004\u0007\u0003\tA\t!!.\u0014\u0007\u0005Mf\u0002C\u0004J\u0003g#\t!!/\u0015\u0005\u0005E\u0006")
public class FSIndex {
    private final Path path;
    private final Analyzer analyzer;
    private final double refreshSeconds;
    private final int ramBufferMB;
    private final int maxMergeMB;
    private final int maxCachedMB;
    private Sort mergeSort;
    private Set<String> fields;
    private Directory directory;
    private IndexWriter writer;
    private SearcherManager manager;
    private ControlledRealTimeReopenThread<IndexSearcher> reopener;

    public void init(Sort mergeSort, Set<String> fields) {
        this.mergeSort = mergeSort;
        this.fields = fields;
        this.directory = new NRTCachingDirectory(FSDirectory.open(this.path), this.maxMergeMB, this.maxCachedMB);
        IndexWriterConfig indexWriterConfig = new IndexWriterConfig(this.analyzer);
        indexWriterConfig.setRAMBufferSizeMB(this.ramBufferMB);
        indexWriterConfig.setOpenMode(IndexWriterConfig.OpenMode.CREATE_OR_APPEND);
        indexWriterConfig.setUseCompoundFile(true);
        indexWriterConfig.setMergePolicy(new SortingMergePolicy(new TieredMergePolicy(), mergeSort));
        this.writer = new IndexWriter(this.directory, indexWriterConfig);
        SearcherFactory searcherFactory = new SearcherFactory(null){

            /*
             * WARNING - void declaration
             */
            public IndexSearcher newSearcher(IndexReader reader, IndexReader previousReader) {
                void var3_3;
                IndexSearcher searcher = new IndexSearcher(reader);
                searcher.setSimilarity(new NoIDFSimilarity());
                return var3_3;
            }
        };
        TrackingIndexWriter tracker = new TrackingIndexWriter(this.writer);
        this.manager = new SearcherManager(this.writer, true, searcherFactory);
        this.reopener = new ControlledRealTimeReopenThread<IndexSearcher>(tracker, this.manager, this.refreshSeconds, this.refreshSeconds);
        this.reopener.start();
    }

    private <A> A doWithSearcher(Function1<IndexSearcher, A> f) {
        A a;
        IndexSearcher searcher = (IndexSearcher)this.manager.acquire();
        try {
            a = f.apply(searcher);
        }
        finally {
            this.manager.release(searcher);
        }
        return a;
    }

    public SearcherManager searcherManager() {
        return this.manager;
    }

    public void upsert(Term term, Document document) {
        this.writer.updateDocument(term, document);
    }

    public void delete(Term term) {
        this.writer.deleteDocuments(term);
    }

    public void delete(Query query) {
        this.writer.deleteDocuments(query);
    }

    public void truncate() {
        this.writer.deleteAll();
        this.writer.commit();
    }

    public void commit() {
        this.writer.commit();
    }

    public void close() {
        this.reopener.close();
        this.manager.close();
        this.writer.close();
        this.directory.close();
    }

    public void delete() {
        try {
            this.close();
        }
        finally {
            FileUtils.deleteRecursive((File)this.path.toFile());
        }
    }

    public int getNumDocs() {
        return BoxesRunTime.unboxToInt(this.doWithSearcher((Function1<IndexSearcher, Object> & Serializable & scala.Serializable)searcher -> BoxesRunTime.boxToInteger(FSIndex.$anonfun$getNumDocs$1(searcher))));
    }

    public int getNumDeletedDocs() {
        return BoxesRunTime.unboxToInt(this.doWithSearcher((Function1<IndexSearcher, Object> & Serializable & scala.Serializable)searcher -> BoxesRunTime.boxToInteger(FSIndex.$anonfun$getNumDeletedDocs$1(searcher))));
    }

    public void forceMerge(int maxNumSegments, boolean doWait) {
        this.writer.forceMerge(maxNumSegments, doWait);
        this.writer.commit();
    }

    public void forceMergeDeletes(boolean doWait) {
        this.writer.forceMergeDeletes(doWait);
        this.writer.commit();
    }

    public void refresh() {
        this.manager.maybeRefreshBlocking();
    }

    public static final /* synthetic */ int $anonfun$getNumDocs$1(IndexSearcher searcher) {
        return searcher.getIndexReader().numDocs();
    }

    public static final /* synthetic */ int $anonfun$getNumDeletedDocs$1(IndexSearcher searcher) {
        return searcher.getIndexReader().numDeletedDocs();
    }

    public FSIndex(String name, Path path, Analyzer analyzer, double refreshSeconds, int ramBufferMB, int maxMergeMB, int maxCachedMB) {
        this.path = path;
        this.analyzer = analyzer;
        this.refreshSeconds = refreshSeconds;
        this.ramBufferMB = ramBufferMB;
        this.maxMergeMB = maxMergeMB;
        this.maxCachedMB = maxCachedMB;
    }
}

