/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.index;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.index.DocumentIterator;
import com.stratio.cassandra.lucene.index.FSIndex;
import com.stratio.cassandra.lucene.util.Logging;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.File;
import java.io.Serializable;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Set;
import org.apache.cassandra.io.util.FileUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SearcherManager;
import org.apache.lucene.search.Sort;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.IndexedSeq$;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.StringOps;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

@ScalaSignature(bytes="\u0006\u0001\u0005%f\u0001B\u0001\u0003\u00015\u0011\u0001\u0003U1si&$\u0018n\u001c8fI&sG-\u001a=\u000b\u0005\r!\u0011!B5oI\u0016D(BA\u0003\u0007\u0003\u0019aWoY3oK*\u0011q\u0001C\u0001\nG\u0006\u001c8/\u00198ee\u0006T!!\u0003\u0006\u0002\u000fM$(/\u0019;j_*\t1\"A\u0002d_6\u001c\u0001aE\u0002\u0001\u001dQ\u0001\"a\u0004\n\u000e\u0003AQ\u0011!E\u0001\u0006g\u000e\fG.Y\u0005\u0003'A\u0011a!\u00118z%\u00164\u0007CA\u000b\u0019\u001b\u00051\"BA\f\u0005\u0003\u0011)H/\u001b7\n\u0005e1\"a\u0002'pO\u001eLgn\u001a\u0005\t7\u0001\u0011\t\u0011)A\u00059\u0005Q\u0001/\u0019:uSRLwN\\:\u0011\u0005=i\u0012B\u0001\u0010\u0011\u0005\rIe\u000e\u001e\u0005\tA\u0001\u0011\t\u0011)A\u0005C\u0005!a.Y7f!\t\u0011\u0013F\u0004\u0002$OA\u0011A\u0005E\u0007\u0002K)\u0011a\u0005D\u0001\u0007yI|w\u000e\u001e \n\u0005!\u0002\u0012A\u0002)sK\u0012,g-\u0003\u0002+W\t11\u000b\u001e:j]\u001eT!\u0001\u000b\t\t\u00115\u0002!\u0011!Q\u0001\n9\nA\u0001]1uQB\u0011qFN\u0007\u0002a)\u0011\u0011GM\u0001\u0005M&dWM\u0003\u00024i\u0005\u0019a.[8\u000b\u0003U\nAA[1wC&\u0011q\u0007\r\u0002\u0005!\u0006$\b\u000e\u0003\u0005:\u0001\t\u0005\t\u0015!\u0003;\u0003!\tg.\u00197zu\u0016\u0014\bCA\u001eD\u001b\u0005a$BA\u001f?\u0003!\tg.\u00197zg&\u001c(BA\u0003@\u0015\t\u0001\u0015)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0005\u0006\u0019qN]4\n\u0005\u0011c$\u0001C!oC2L(0\u001a:\t\u0011\u0019\u0003!\u0011!Q\u0001\n\u001d\u000baB]3ge\u0016\u001c\bnU3d_:$7\u000f\u0005\u0002\u0010\u0011&\u0011\u0011\n\u0005\u0002\u0007\t>,(\r\\3\t\u0011-\u0003!\u0011!Q\u0001\nq\t1B]1n\u0005V4g-\u001a:N\u0005\"AQ\n\u0001B\u0001B\u0003%A$\u0001\u0006nCblUM]4f\u001b\nC\u0001b\u0014\u0001\u0003\u0002\u0003\u0006I\u0001H\u0001\f[\u0006D8)Y2iK\u0012l%\tC\u0003R\u0001\u0011\u0005!+\u0001\u0004=S:LGO\u0010\u000b\n'V3v\u000bW-[7r\u0003\"\u0001\u0016\u0001\u000e\u0003\tAQa\u0007)A\u0002qAQ\u0001\t)A\u0002\u0005BQ!\f)A\u00029BQ!\u000f)A\u0002iBQA\u0012)A\u0002\u001dCQa\u0013)A\u0002qAQ!\u0014)A\u0002qAQa\u0014)A\u0002qAaA\u0018\u0001!\u0002\u0013y\u0016aB5oI\u0016DXm\u001d\t\u0004A\u0016DgBA1d\u001d\t!#-C\u0001\u0012\u0013\t!\u0007#A\u0004qC\u000e\\\u0017mZ3\n\u0005\u0019<'\u0001\u0002'jgRT!\u0001\u001a\t\u0011\u0005QK\u0017B\u00016\u0003\u0005\u001d15+\u00138eKbD\u0011\u0002\u001c\u0001A\u0002\u0003\u0005\u000b\u0015B7\u0002\u00135,'oZ3T_J$\bC\u00018r\u001b\u0005y'B\u00019?\u0003\u0019\u0019X-\u0019:dQ&\u0011!o\u001c\u0002\u0005'>\u0014H\u000fC\u0005u\u0001\u0001\u0007\t\u0011)Q\u0005k\u00061a-[3mIN\u00042A\u001e=\"\u001b\u00059(BA\f5\u0013\tIxOA\u0002TKRDQa\u001f\u0001\u0005\u0002q\fA!\u001b8jiR)Q0!\u0001\u0002\u0004A\u0011qB`\u0005\u0003\u007fB\u0011A!\u00168ji\")AN\u001fa\u0001[\")AO\u001fa\u0001k\"9\u0011q\u0001\u0001\u0005\u0002\u0005%\u0011\u0001\u0003;sk:\u001c\u0017\r^3\u0015\u0003uDq!!\u0004\u0001\t\u0003\tI!\u0001\u0004d_6l\u0017\u000e\u001e\u0005\b\u0003#\u0001A\u0011AA\u0005\u0003\u0015\u0019Gn\\:f\u0011\u001d\t)\u0002\u0001C\u0001\u0003\u0013\ta\u0001Z3mKR,\u0007bBA\r\u0001\u0011\u0005\u00111D\u0001\u000bM>\u00148-Z'fe\u001e,G#B?\u0002\u001e\u0005\u0005\u0002bBA\u0010\u0003/\u0001\r\u0001H\u0001\u000f[\u0006Dh*^7TK\u001elWM\u001c;t\u0011!\t\u0019#a\u0006A\u0002\u0005\u0015\u0012A\u00023p/\u0006LG\u000fE\u0002\u0010\u0003OI1!!\u000b\u0011\u0005\u001d\u0011un\u001c7fC:Dq!!\f\u0001\t\u0003\ty#A\tg_J\u001cW-T3sO\u0016$U\r\\3uKN$2!`A\u0019\u0011!\t\u0019#a\u000bA\u0002\u0005\u0015\u0002bBA\u001b\u0001\u0011\u0005\u0011\u0011B\u0001\be\u00164'/Z:i\u0011\u001d\tI\u0004\u0001C\u0001\u0003w\t!bZ3u\u001dVlGi\\2t+\t\ti\u0004E\u0002\u0010\u0003\u007fI1!!\u0011\u0011\u0005\u0011auN\\4\t\u000f\u0005\u0015\u0003\u0001\"\u0001\u0002<\u0005\tr-\u001a;Ok6$U\r\\3uK\u0012$unY:\t\u000f\u0005%\u0003\u0001\"\u0001\u0002L\u00051Q\u000f]:feR$r!`A'\u0003#\ny\u0006C\u0004\u0002P\u0005\u001d\u0003\u0019\u0001\u000f\u0002\u0013A\f'\u000f^5uS>t\u0007\u0002CA*\u0003\u000f\u0002\r!!\u0016\u0002\tQ,'/\u001c\t\u0005\u0003/\nY&\u0004\u0002\u0002Z)\u00111AP\u0005\u0005\u0003;\nIF\u0001\u0003UKJl\u0007\u0002CA1\u0003\u000f\u0002\r!a\u0019\u0002\u0011\u0011|7-^7f]R\u0004B!!\u001a\u0002j5\u0011\u0011q\r\u0006\u0004\u0003Cr\u0014\u0002BA6\u0003O\u0012\u0001\u0002R8dk6,g\u000e\u001e\u0005\b\u0003+\u0001A\u0011AA8)\u0015i\u0018\u0011OA:\u0011\u001d\ty%!\u001cA\u0002qA\u0001\"a\u0015\u0002n\u0001\u0007\u0011Q\u000b\u0005\b\u0003+\u0001A\u0011AA<)\u0015i\u0018\u0011PA>\u0011\u001d\ty%!\u001eA\u0002qA\u0001\"! \u0002v\u0001\u0007\u0011qP\u0001\u0006cV,'/\u001f\t\u0004]\u0006\u0005\u0015bAAB_\n)\u0011+^3ss\"1\u0001\u000f\u0001C\u0001\u0003\u000f#\"\"!#\u0002\u0010\u0006}\u0015\u0011UAS!\r!\u00161R\u0005\u0004\u0003\u001b\u0013!\u0001\u0005#pGVlWM\u001c;Ji\u0016\u0014\u0018\r^8s\u0011\u001dY\u0012Q\u0011a\u0001\u0003#\u0003B\u0001Y3\u0002\u0014B1q\"!&\u001d\u00033K1!a&\u0011\u0005\u0019!V\u000f\u001d7feA)q\"a'\u0002V%\u0019\u0011Q\u0014\t\u0003\r=\u0003H/[8o\u0011!\ti(!\"A\u0002\u0005}\u0004bBAR\u0003\u000b\u0003\r!\\\u0001\u0005g>\u0014H\u000fC\u0004\u0002(\u0006\u0015\u0005\u0019\u0001\u000f\u0002\u000b\r|WO\u001c;")
public class PartitionedIndex
implements Logging {
    private final int partitions;
    private final String name;
    private final Path path;
    private final Analyzer analyzer;
    private final double refreshSeconds;
    private final int ramBufferMB;
    private final int maxMergeMB;
    private final int maxCachedMB;
    private final List<FSIndex> indexes;
    private Sort mergeSort;
    private Set<String> fields;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public void init(Sort mergeSort, Set<String> fields) {
        this.mergeSort = mergeSort;
        this.fields = fields;
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$4 -> {
            x$4.init(mergeSort, fields);
            return BoxedUnit.UNIT;
        });
    }

    public void truncate() {
        BoxedUnit boxedUnit;
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$5 -> {
            x$5.truncate();
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Truncated ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void commit() {
        BoxedUnit boxedUnit;
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$6 -> {
            x$6.commit();
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Committed ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void close() {
        BoxedUnit boxedUnit;
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$7 -> {
            x$7.close();
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Closed ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void delete() {
        BoxedUnit boxedUnit;
        try {
            this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$8 -> {
                x$8.delete();
                return BoxedUnit.UNIT;
            });
        }
        finally {
            if (this.partitions > 1) {
                FileUtils.deleteRecursive((File)this.path.toFile());
            }
        }
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleted ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void forceMerge(int maxNumSegments, boolean doWait) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Merging ", " segments to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name, BoxesRunTime.boxToInteger(maxNumSegments)})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$9 -> {
            x$9.forceMerge(maxNumSegments, doWait);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Merged ", " segments to ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name, BoxesRunTime.boxToInteger(maxNumSegments)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void forceMergeDeletes(boolean doWait) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Merging ", " segments with deletions"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$10 -> {
            x$10.forceMergeDeletes(doWait);
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Merged ", " segments with deletions"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public void refresh() {
        BoxedUnit boxedUnit;
        this.indexes.foreach((Function1<FSIndex, Object> & Serializable & scala.Serializable)x$11 -> {
            x$11.refresh();
            return BoxedUnit.UNIT;
        });
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Refreshed ", " readers"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
    }

    public long getNumDocs() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting ", " num docs"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long l = 0L;
        return BoxesRunTime.unboxToLong(this.indexes.$div$colon(BoxesRunTime.boxToLong(l), (Function2<Object, FSIndex, Object> & Serializable & scala.Serializable)(x$13, x$14) -> BoxesRunTime.boxToLong(PartitionedIndex.$anonfun$getNumDocs$1(BoxesRunTime.unboxToLong(x$13), x$14))));
    }

    public long getNumDeletedDocs() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Getting ", " num deleted docs"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        long l = 0L;
        return BoxesRunTime.unboxToLong(this.indexes.$div$colon(BoxesRunTime.boxToLong(l), (Function2<Object, FSIndex, Object> & Serializable & scala.Serializable)(x$16, x$17) -> BoxesRunTime.boxToLong(PartitionedIndex.$anonfun$getNumDeletedDocs$1(BoxesRunTime.unboxToLong(x$16), x$17))));
    }

    public void upsert(int partition, Term term, Document document) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Indexing ", " with term ", " in ", " in partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{document, term, this.name, BoxesRunTime.boxToInteger(partition)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.indexes.apply(partition).upsert(term, document);
    }

    public void delete(int partition, Term term) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", " from ", " in partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{term, this.name, BoxesRunTime.boxToInteger(partition)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.indexes.apply(partition).delete(term);
    }

    public void delete(int partition, Query query) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Deleting ", " from ", " in partition ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{query, this.name, BoxesRunTime.boxToInteger(partition)})));
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.indexes.apply(partition).delete(query);
    }

    public DocumentIterator search(List<Tuple2<Object, Option<Term>>> partitions, Query query, Sort sort, int count) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(new StringOps(Predef$.MODULE$.augmentString(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Searching in ", "\n         | partitions : ", "\n         |      after : ", "\n         |      query : ", "\n         |      count : ", "\n         |       sort : ", "\n       "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.name, ((TraversableOnce)partitions.map((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$18 -> BoxesRunTime.boxToInteger(x$18._1$mcI$sp()), List$.MODULE$.canBuildFrom())).mkString(", "), ((TraversableOnce)partitions.map((Function1<Tuple2, Option> & Serializable & scala.Serializable)x$19 -> (Option)x$19._2(), List$.MODULE$.canBuildFrom())).mkString(", "), query, BoxesRunTime.boxToInteger(count), sort})))).stripMargin());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        List<Tuple2<SearcherManager, Option<Term>>> cursors = partitions.map((Function1<Tuple2, Tuple2> & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int p = tuple2._1$mcI$sp();
            Option a = (Option)tuple2._2();
            Tuple2<SearcherManager, Option> tuple22 = new Tuple2<SearcherManager, Option>($this.indexes.apply(p).searcherManager(), a);
            return tuple22;
        }, List$.MODULE$.canBuildFrom());
        return new DocumentIterator(cursors, this.mergeSort, sort, query, count, this.fields);
    }

    public static final /* synthetic */ String $anonfun$indexes$1(String root$1, int x$1) {
        return root$1 + File.separator + x$1;
    }

    public static final /* synthetic */ long $anonfun$getNumDocs$1(long x$13, FSIndex x$14) {
        return x$13 + (long)x$14.getNumDocs();
    }

    public static final /* synthetic */ long $anonfun$getNumDeletedDocs$1(long x$16, FSIndex x$17) {
        return x$16 + (long)x$17.getNumDeletedDocs();
    }

    public PartitionedIndex(int partitions, String name, Path path, Analyzer analyzer, double refreshSeconds, int ramBufferMB, int maxMergeMB, int maxCachedMB) {
        List list;
        this.partitions = partitions;
        this.name = name;
        this.path = path;
        this.analyzer = analyzer;
        this.refreshSeconds = refreshSeconds;
        this.ramBufferMB = ramBufferMB;
        this.maxMergeMB = maxMergeMB;
        this.maxCachedMB = maxCachedMB;
        StrictLogging.$init$(this);
        int n = partitions;
        switch (n) {
            case 1: {
                list = List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new FSIndex[]{new FSIndex(name, path, analyzer, refreshSeconds, ramBufferMB, maxMergeMB, maxCachedMB)}));
                break;
            }
            default: {
                if (n > 1) {
                    String root = path.toFile().getAbsolutePath() + File.separator;
                    list = ((TraversableOnce)((TraversableLike)((TraversableLike)RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), n).map((Function1<Object, String> & Serializable & scala.Serializable)x$1 -> PartitionedIndex.$anonfun$indexes$1(root, BoxesRunTime.unboxToInt(x$1)), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<String, Path> & Serializable & scala.Serializable)x$2 -> Paths.get(x$2, new String[0]), IndexedSeq$.MODULE$.canBuildFrom())).map((Function1<Path, FSIndex> & Serializable & scala.Serializable)x$3 -> new FSIndex($this.name, (Path)x$3, $this.analyzer, $this.refreshSeconds, $this.ramBufferMB, $this.maxMergeMB, $this.maxCachedMB), IndexedSeq$.MODULE$.canBuildFrom())).toList();
                    break;
                }
                throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of partitions should be strictly positive but found ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitions)})));
            }
        }
        this.indexes = list;
    }
}

