/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.index;

import java.io.Serializable;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexWriterConfig;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.store.RAMDirectory;
import scala.Array$;
import scala.Function1;
import scala.Predef$;
import scala.Predef$DummyImplicit$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u0011\u0001BU!N\u0013:$W\r\u001f\u0006\u0003\u0007\u0011\tQ!\u001b8eKbT!!\u0002\u0004\u0002\r1,8-\u001a8f\u0015\t9\u0001\"A\u0005dCN\u001c\u0018M\u001c3sC*\u0011\u0011BC\u0001\bgR\u0014\u0018\r^5p\u0015\u0005Y\u0011aA2p[\u000e\u00011C\u0001\u0001\u000f!\ty!#D\u0001\u0011\u0015\u0005\t\u0012!B:dC2\f\u0017BA\n\u0011\u0005\u0019\te.\u001f*fM\"AQ\u0003\u0001B\u0001B\u0003%a#\u0001\u0005b]\u0006d\u0017P_3s!\t9r$D\u0001\u0019\u0015\tI\"$\u0001\u0005b]\u0006d\u0017p]5t\u0015\t)1D\u0003\u0002\u001d;\u00051\u0011\r]1dQ\u0016T\u0011AH\u0001\u0004_J<\u0017B\u0001\u0011\u0019\u0005!\te.\u00197zu\u0016\u0014\b\"\u0002\u0012\u0001\t\u0003\u0019\u0013A\u0002\u001fj]&$h\b\u0006\u0002%MA\u0011Q\u0005A\u0007\u0002\u0005!)Q#\ta\u0001-!9\u0001\u0006\u0001b\u0001\n\u0013I\u0013!\u00033je\u0016\u001cGo\u001c:z+\u0005Q\u0003CA\u0016/\u001b\u0005a#BA\u0017\u001b\u0003\u0015\u0019Ho\u001c:f\u0013\tyCF\u0001\u0007S\u00036#\u0015N]3di>\u0014\u0018\u0010\u0003\u00042\u0001\u0001\u0006IAK\u0001\u000bI&\u0014Xm\u0019;pef\u0004\u0003bB\u001a\u0001\u0005\u0004%I\u0001N\u0001\fS:$W\r_,sSR,'/F\u00016!\t1\u0004(D\u00018\u0015\t\u0019!$\u0003\u0002:o\tY\u0011J\u001c3fq^\u0013\u0018\u000e^3s\u0011\u0019Y\u0004\u0001)A\u0005k\u0005a\u0011N\u001c3fq^\u0013\u0018\u000e^3sA!)Q\b\u0001C\u0001}\u0005\u0019\u0011\r\u001a3\u0015\u0005}\u0012\u0005CA\bA\u0013\t\t\u0005C\u0001\u0003V]&$\b\"B\"=\u0001\u0004!\u0015\u0001\u00033pGVlWM\u001c;\u0011\u0005\u0015;U\"\u0001$\u000b\u0005\rS\u0012B\u0001%G\u0005!!unY;nK:$\b\"\u0002&\u0001\t\u0003Y\u0015!B2m_N,G#A \t\u000b5\u0003A\u0011\u0001(\u0002\rM,\u0017M]2i)\u0015y5\r[7x!\r\u0001\u0006l\u0017\b\u0003#Zs!AU+\u000e\u0003MS!\u0001\u0016\u0007\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0012BA,\u0011\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u0017.\u0003\u0007M+\u0017O\u0003\u0002X!A!q\u0002\u0018#_\u0013\ti\u0006C\u0001\u0004UkBdWM\r\t\u0003?\u0006l\u0011\u0001\u0019\u0006\u0003\u001bjI!A\u00191\u0003\u0011M\u001bwN]3E_\u000eDQ\u0001\u001a'A\u0002\u0015\fQ!];fef\u0004\"a\u00184\n\u0005\u001d\u0004'!B)vKJL\b\"B5M\u0001\u0004Q\u0017\u0001B:peR\u0004\"aX6\n\u00051\u0004'\u0001B*peRDQA\u001c'A\u0002=\fQaY8v]R\u0004\"\u0001];\u000e\u0003ET!A]:\u0002\t1\fgn\u001a\u0006\u0002i\u0006!!.\u0019<b\u0013\t1\u0018OA\u0004J]R,w-\u001a:\t\u000bad\u0005\u0019A=\u0002\r\u0019LW\r\u001c3t!\rQXp`\u0007\u0002w*\u0011Ap]\u0001\u0005kRLG.\u0003\u0002\u007fw\n\u00191+\u001a;\u0011\t\u0005\u0005\u0011\u0011\u0002\b\u0005\u0003\u0007\t)\u0001\u0005\u0002S!%\u0019\u0011q\u0001\t\u0002\rA\u0013X\rZ3g\u0013\u0011\tY!!\u0004\u0003\rM#(/\u001b8h\u0015\r\t9\u0001\u0005")
public class RAMIndex {
    private final RAMDirectory directory = new RAMDirectory();
    private final IndexWriter indexWriter;

    private RAMDirectory directory() {
        return this.directory;
    }

    private IndexWriter indexWriter() {
        return this.indexWriter;
    }

    public void add(Document document) {
        this.indexWriter().addDocument(document);
    }

    public void close() {
        this.indexWriter().close();
        this.directory().close();
    }

    public Seq<Tuple2<Document, ScoreDoc>> search(Query query, Sort sort, Integer count, Set<String> fields) {
        Seq seq;
        this.indexWriter().commit();
        DirectoryReader reader = DirectoryReader.open(this.directory());
        IndexSearcher searcher = new IndexSearcher(reader);
        try {
            Sort newSort = sort.rewrite(searcher);
            TopFieldDocs topDocs = searcher.search(query, Predef$.MODULE$.Integer2int(count), newSort, true, true);
            seq = new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])topDocs.scoreDocs)).map((Function1<ScoreDoc, Tuple2> & Serializable & scala.Serializable)score -> new Tuple2<Document, ScoreDoc>(searcher.doc(score.doc, fields), (ScoreDoc)score), Array$.MODULE$.fallbackCanBuildFrom(Predef$DummyImplicit$.MODULE$.dummyImplicit()));
        }
        finally {
            searcher.getIndexReader().close();
        }
        return seq;
    }

    public RAMIndex(Analyzer analyzer) {
        this.indexWriter = new IndexWriter(this.directory(), new IndexWriterConfig(analyzer));
    }
}

