/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.index;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.util.Logging;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.util.FilteringTokenFilter;
import scala.Predef$;
import scala.StringContext;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3A!\u0001\u0002\u0001\u001b\t\u0019Bk\\6f]2+gn\u001a;i\u0003:\fG.\u001f>fe*\u00111\u0001B\u0001\u0006S:$W\r\u001f\u0006\u0003\u000b\u0019\ta\u0001\\;dK:,'BA\u0004\t\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002\n\u0015\u000591\u000f\u001e:bi&|'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0007\u0001q\u0011\u0004\u0005\u0002\u0010/5\t\u0001C\u0003\u0002\u0012%\u0005A\u0011M\\1msNL7O\u0003\u0002\u0006')\u0011A#F\u0001\u0007CB\f7\r[3\u000b\u0003Y\t1a\u001c:h\u0013\tA\u0002CA\bB]\u0006d\u0017P_3s/J\f\u0007\u000f]3s!\tQR$D\u0001\u001c\u0015\taB!\u0001\u0003vi&d\u0017B\u0001\u0010\u001c\u0005\u001daunZ4j]\u001eD\u0001\u0002\t\u0001\u0003\u0006\u0004%\t!I\u0001\tC:\fG.\u001f>feV\t!\u0005\u0005\u0002\u0010G%\u0011A\u0005\u0005\u0002\t\u0003:\fG.\u001f>fe\"Aa\u0005\u0001B\u0001B\u0003%!%A\u0005b]\u0006d\u0017P_3sA!)\u0001\u0006\u0001C\u0001S\u00051A(\u001b8jiz\"\"A\u000b\u0017\u0011\u0005-\u0002Q\"\u0001\u0002\t\u000b\u0001:\u0003\u0019\u0001\u0012\t\u000b9\u0002A\u0011K\u0018\u0002%\u001d,Go\u0016:baB,G-\u00118bYfTXM\u001d\u000b\u0003EABQ!M\u0017A\u0002I\n\u0011BZ5fY\u0012t\u0015-\\3\u0011\u0005MbdB\u0001\u001b;!\t)\u0004(D\u00017\u0015\t9D\"\u0001\u0004=e>|GO\u0010\u0006\u0002s\u0005)1oY1mC&\u00111\bO\u0001\u0007!J,G-\u001a4\n\u0005ur$AB*ue&twM\u0003\u0002<q!)\u0001\t\u0001C)\u0003\u0006qqO]1q\u0007>l\u0007o\u001c8f]R\u001cHc\u0001\"R'B\u00111I\u0014\b\u0003\t2s!!R&\u000f\u0005\u0019SeBA$J\u001d\t)\u0004*C\u0001\u0017\u0013\t!R#\u0003\u0002\u0006'%\u0011\u0011CE\u0005\u0003\u001bB\t\u0001\"\u00118bYfTXM]\u0005\u0003\u001fB\u0013Q\u0003V8lK:\u001cFO]3b[\u000e{W\u000e]8oK:$8O\u0003\u0002N!!)!k\u0010a\u0001e\u0005)a-[3mI\")Ak\u0010a\u0001\u0005\u0006Q1m\\7q_:,g\u000e^:\t\u000bY\u0003A\u0011I,\u0002\u0011Q|7\u000b\u001e:j]\u001e$\u0012A\r")
public class TokenLengthAnalyzer
extends AnalyzerWrapper
implements Logging {
    private final Analyzer analyzer;
    private final Logger logger;

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    public Analyzer analyzer() {
        return this.analyzer;
    }

    @Override
    public Analyzer getWrappedAnalyzer(String fieldName) {
        return this.analyzer();
    }

    @Override
    public Analyzer.TokenStreamComponents wrapComponents(String field2, Analyzer.TokenStreamComponents components) {
        FilteringTokenFilter tokenFilter = new FilteringTokenFilter(this, field2, components){
            private final CharTermAttribute term;
            private final int maxSize;
            private final /* synthetic */ TokenLengthAnalyzer $outer;
            private final String field$1;

            public CharTermAttribute term() {
                return this.term;
            }

            public int maxSize() {
                return this.maxSize;
            }

            public boolean accept() {
                boolean bl;
                int size = this.term().length();
                if (size <= this.maxSize()) {
                    bl = true;
                } else {
                    BoxedUnit boxedUnit;
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Discarding immense term in field='", "', "})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.field$1})) + new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Lucene only allows terms with at most ", " bytes in length; got ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.maxSize()), BoxesRunTime.boxToInteger(size)})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    bl = false;
                }
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.field$1 = field$1;
                super(components$1.getTokenStream());
                this.term = this.addAttribute(CharTermAttribute.class);
                this.maxSize = 32766;
            }
        };
        return new Analyzer.TokenStreamComponents(components.getTokenizer(), tokenFilter);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("analyzer", (Object)this.analyzer()).toString();
    }

    public TokenLengthAnalyzer(Analyzer analyzer) {
        this.analyzer = analyzer;
        super(analyzer.getReuseStrategy());
        StrictLogging.$init$(this);
    }
}

