/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.google.common.primitives.Longs;
import com.stratio.cassandra.lucene.mapping.TokenMapper$;
import org.apache.cassandra.db.BufferDecoratedKey;
import org.apache.cassandra.db.ClusteringBound;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.filter.ClusteringIndexFilter;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.ByteBufferUtil;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.IndexOptions;
import scala.None$;
import scala.Option;
import scala.Some;

public final class ClusteringMapper$ {
    public static ClusteringMapper$ MODULE$;
    private final String FIELD_NAME;
    private final FieldType FIELD_TYPE;
    private final int PREFIX_SIZE;

    static {
        new ClusteringMapper$();
    }

    public String FIELD_NAME() {
        return this.FIELD_NAME;
    }

    public FieldType FIELD_TYPE() {
        return this.FIELD_TYPE;
    }

    public int PREFIX_SIZE() {
        return this.PREFIX_SIZE;
    }

    public byte[] prefix(Token token) {
        long value = TokenMapper$.MODULE$.longValue(token);
        long collated = Long.MIN_VALUE + value;
        return Longs.toByteArray((long)collated);
    }

    public Option<ClusteringPrefix> startClusteringPrefix(DataRange range) {
        Option option;
        ClusteringIndexFilter filter;
        ClusteringIndexFilter clusteringIndexFilter;
        PartitionPosition partitionPosition = range.startKey();
        if (partitionPosition instanceof DecoratedKey) {
            DecoratedKey decoratedKey = (DecoratedKey)partitionPosition;
            clusteringIndexFilter = range.clusteringIndexFilter(decoratedKey);
        } else {
            clusteringIndexFilter = range.clusteringIndexFilter((DecoratedKey)new BufferDecoratedKey(partitionPosition.getToken(), ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        ClusteringIndexFilter clusteringIndexFilter2 = filter = clusteringIndexFilter;
        if (clusteringIndexFilter2 instanceof ClusteringIndexSliceFilter) {
            ClusteringIndexSliceFilter clusteringIndexSliceFilter = (ClusteringIndexSliceFilter)clusteringIndexFilter2;
            option = new Some<ClusteringBound>(clusteringIndexSliceFilter.requestedSlices().get(0).start());
        } else if (clusteringIndexFilter2 instanceof ClusteringIndexNamesFilter) {
            ClusteringIndexNamesFilter clusteringIndexNamesFilter = (ClusteringIndexNamesFilter)clusteringIndexFilter2;
            option = new Some(clusteringIndexNamesFilter.requestedRows().first());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    public Option<ClusteringPrefix> stopClusteringPrefix(DataRange range) {
        Option option;
        ClusteringIndexFilter filter;
        ClusteringIndexFilter clusteringIndexFilter;
        PartitionPosition partitionPosition = range.stopKey();
        if (partitionPosition instanceof DecoratedKey) {
            DecoratedKey decoratedKey = (DecoratedKey)partitionPosition;
            clusteringIndexFilter = range.clusteringIndexFilter(decoratedKey);
        } else {
            clusteringIndexFilter = range.clusteringIndexFilter((DecoratedKey)new BufferDecoratedKey(partitionPosition.getToken(), ByteBufferUtil.EMPTY_BYTE_BUFFER));
        }
        ClusteringIndexFilter clusteringIndexFilter2 = filter = clusteringIndexFilter;
        if (clusteringIndexFilter2 instanceof ClusteringIndexSliceFilter) {
            ClusteringIndexSliceFilter clusteringIndexSliceFilter = (ClusteringIndexSliceFilter)clusteringIndexFilter2;
            option = new Some<ClusteringBound>(clusteringIndexSliceFilter.requestedSlices().get(clusteringIndexSliceFilter.requestedSlices().size() - 1).end());
        } else if (clusteringIndexFilter2 instanceof ClusteringIndexNamesFilter) {
            ClusteringIndexNamesFilter clusteringIndexNamesFilter = (ClusteringIndexNamesFilter)clusteringIndexFilter2;
            option = new Some(clusteringIndexNamesFilter.requestedRows().last());
        } else {
            option = None$.MODULE$;
        }
        return option;
    }

    private ClusteringMapper$() {
        MODULE$ = this;
        this.FIELD_NAME = "_clustering";
        this.FIELD_TYPE = new FieldType();
        this.FIELD_TYPE().setOmitNorms(true);
        this.FIELD_TYPE().setIndexOptions(IndexOptions.DOCS);
        this.FIELD_TYPE().setTokenized(false);
        this.FIELD_TYPE().setStored(false);
        this.FIELD_TYPE().setDocValuesType(DocValuesType.SORTED);
        this.FIELD_TYPE().freeze();
        this.PREFIX_SIZE = 8;
    }
}

