/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.stratio.cassandra.lucene.mapping.ClusteringMapper$;
import com.stratio.cassandra.lucene.mapping.ClusteringQuery;
import com.stratio.cassandra.lucene.mapping.ClusteringSort;
import com.stratio.cassandra.lucene.util.ByteBufferUtils$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.config.ColumnDefinition;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.db.Slice;
import org.apache.cassandra.db.filter.ClusteringIndexSliceFilter;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.cassandra.dht.Token;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.StoredField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\t\u0005a\u0001B\u0001\u0003\u00015\u0011\u0001c\u00117vgR,'/\u001b8h\u001b\u0006\u0004\b/\u001a:\u000b\u0005\r!\u0011aB7baBLgn\u001a\u0006\u0003\u000b\u0019\ta\u0001\\;dK:,'BA\u0004\t\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002\n\u0015\u000591\u000f\u001e:bi&|'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!iW\r^1eCR\f\u0007CA\f \u001b\u0005A\"BA\r\u001b\u0003\u0019\u0019wN\u001c4jO*\u0011qa\u0007\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014x-\u0003\u0002!1\tQ1IR'fi\u0006$\u0015\r^1\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0001C\u0003\u0016C\u0001\u0007a\u0003C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002\u0015\r|W\u000e]1sCR|'/F\u0001+!\tYc&D\u0001-\u0015\ti#$\u0001\u0002eE&\u0011q\u0006\f\u0002\u0015\u00072,8\u000f^3sS:<7i\\7qCJ\fGo\u001c:\t\rE\u0002\u0001\u0015!\u0003+\u0003-\u0019w.\u001c9be\u0006$xN\u001d\u0011\t\u000fM\u0002!\u0019!C\u0001i\u0005q1\r\\;ti\u0016\u0014\u0018N\\4UsB,W#A\u001b\u0011\u0005YJT\"A\u001c\u000b\u0005ab\u0013aB7beND\u0017\r\\\u0005\u0003u]\u0012QbQ8na>\u001c\u0018\u000e^3UsB,\u0007B\u0002\u001f\u0001A\u0003%Q'A\bdYV\u001cH/\u001a:j]\u001e$\u0016\u0010]3!\u0011\u001dq\u0004A1A\u0005\u0002}\n\u0011c\u00197vgR,'/\u001b8h\u0007>dW/\u001c8t+\u0005\u0001\u0005cA!J\u0019:\u0011!i\u0012\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000b2\ta\u0001\u0010:p_Rt\u0014\"A\t\n\u0005!\u0003\u0012a\u00029bG.\fw-Z\u0005\u0003\u0015.\u0013A\u0001T5ti*\u0011\u0001\n\u0005\t\u0003/5K!A\u0014\r\u0003!\r{G.^7o\t\u00164\u0017N\\5uS>t\u0007B\u0002)\u0001A\u0003%\u0001)\u0001\ndYV\u001cH/\u001a:j]\u001e\u001cu\u000e\\;n]N\u0004\u0003\"\u0002*\u0001\t\u0003\u0019\u0016aD5oI\u0016D\u0018M\u00197f\r&,G\u000eZ:\u0015\u0007Qc\u0016\rE\u0002B\u0013V\u0003\"A\u0016.\u000e\u0003]S!\u0001W-\u0002\u000b%tG-\u001a=\u000b\u0005\u0015Y\u0012BA.X\u00059Ie\u000eZ3yC\ndWMR5fY\u0012DQ!X)A\u0002y\u000b1a[3z!\tYs,\u0003\u0002aY\taA)Z2pe\u0006$X\rZ&fs\")!-\u0015a\u0001G\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u0011\u0005-\"\u0017BA3-\u0005)\u0019E.^:uKJLgn\u001a\u0005\u0006O\u0002!\t\u0001[\u0001\u000bEf$XMQ;gM\u0016\u0014HCA5r!\tQw.D\u0001l\u0015\taW.A\u0002oS>T\u0011A\\\u0001\u0005U\u00064\u0018-\u0003\u0002qW\nQ!)\u001f;f\u0005V4g-\u001a:\t\u000b\t4\u0007\u0019A2\t\u000bM\u0004A\u0011\u0001;\u0002\u0011Q|7\u000b\u001e:j]\u001e$\"!^?\u0011\u0005YThBA<y!\t\u0019\u0005#\u0003\u0002z!\u00051\u0001K]3eK\u001aL!a\u001f?\u0003\rM#(/\u001b8h\u0015\tI\b\u0003C\u0003\u007fe\u0002\u0007q0\u0001\u0004qe\u00164\u0017\u000e\u001f\t\u0006\u001f\u0005\u0005\u0011QA\u0005\u0004\u0003\u0007\u0001\"AB(qi&|g\u000eE\u0002,\u0003\u000fI1!!\u0003-\u0005A\u0019E.^:uKJLgn\u001a)sK\u001aL\u0007\u0010\u0003\u0004c\u0001\u0011\u0005\u0011Q\u0002\u000b\u0004G\u0006=\u0001B\u00022\u0002\f\u0001\u0007\u0011\u000e\u0003\u0004c\u0001\u0011\u0005\u00111\u0003\u000b\u0004G\u0006U\u0001\u0002CA\f\u0003#\u0001\r!!\u0007\u0002\u0011\u0011|7-^7f]R\u0004B!a\u0007\u0002 5\u0011\u0011Q\u0004\u0006\u0004\u0003/I\u0016\u0002BA\u0011\u0003;\u0011\u0001\u0002R8dk6,g\u000e\u001e\u0005\b\u0003K\u0001A\u0011AA\u0014\u0003%\u0019xN\u001d;GS\u0016dG-\u0006\u0002\u0002*A!\u00111FA\u0019\u001b\t\tiCC\u0002\u00020e\u000baa]3be\u000eD\u0017\u0002BA\u001a\u0003[\u0011\u0011bU8si\u001aKW\r\u001c3\t\u000f\u0005]\u0002\u0001\"\u0001\u0002:\u0005)\u0011/^3ssRA\u00111HA!\u0003\u0017\ny\u0005\u0005\u0003\u0002,\u0005u\u0012\u0002BA \u0003[\u0011Q!U;fefD\u0001\"a\u0011\u00026\u0001\u0007\u0011QI\u0001\ta>\u001c\u0018\u000e^5p]B\u00191&a\u0012\n\u0007\u0005%CFA\tQCJ$\u0018\u000e^5p]B{7/\u001b;j_:Dq!!\u0014\u00026\u0001\u0007q0A\u0003ti\u0006\u0014H\u000fC\u0004\u0002R\u0005U\u0002\u0019A@\u0002\tM$x\u000e\u001d\u0005\b\u0003o\u0001A\u0011AA+)\u0019\tY$a\u0016\u0002Z!1Q,a\u0015A\u0002yC\u0001\"a\u0017\u0002T\u0001\u0007\u0011QL\u0001\u0006g2L7-\u001a\t\u0004W\u0005}\u0013bAA1Y\t)1\u000b\\5dK\"9\u0011q\u0007\u0001\u0005\u0002\u0005\u0015DCBA\u001e\u0003O\nI\u0007\u0003\u0004^\u0003G\u0002\rA\u0018\u0005\t\u0003W\n\u0019\u00071\u0001\u0002n\u00051a-\u001b7uKJ\u0004B!a\u001c\u0002t5\u0011\u0011\u0011\u000f\u0006\u0004\u0003Wb\u0013\u0002BA;\u0003c\u0012!d\u00117vgR,'/\u001b8h\u0013:$W\r_*mS\u000e,g)\u001b7uKJ<q!!\u001f\u0003\u0011\u0003\tY(\u0001\tDYV\u001cH/\u001a:j]\u001el\u0015\r\u001d9feB\u0019Q%! \u0007\r\u0005\u0011\u0001\u0012AA@'\r\tiH\u0004\u0005\bE\u0005uD\u0011AAB)\t\tY\b\u0003\u0006\u0002\b\u0006u$\u0019!C\u0001\u0003\u0013\u000b!BR%F\u0019\u0012{f*Q'F+\t\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t*\\\u0001\u0005Y\u0006tw-C\u0002|\u0003\u001fC\u0011\"a&\u0002~\u0001\u0006I!a#\u0002\u0017\u0019KU\t\u0014#`\u001d\u0006kU\t\t\u0005\u000b\u00037\u000biH1A\u0005\u0002\u0005u\u0015A\u0003$J\u000b2#u\fV-Q\u000bV\u0011\u0011q\u0014\t\u0005\u00037\t\t+\u0003\u0003\u0002$\u0006u!!\u0003$jK2$G+\u001f9f\u0011%\t9+! !\u0002\u0013\ty*A\u0006G\u0013\u0016cEi\u0018+Z!\u0016\u0003\u0003BCAV\u0003{\u0012\r\u0011\"\u0001\u0002.\u0006Y\u0001KU#G\u0013b{6+\u0013.F+\t\ty\u000bE\u0002\u0010\u0003cK1!a-\u0011\u0005\rIe\u000e\u001e\u0005\n\u0003o\u000bi\b)A\u0005\u0003_\u000bA\u0002\u0015*F\r&CvlU%[\u000b\u0002BqA`A?\t\u0003\tY\f\u0006\u0003\u0002>\u0006%\u0007#B\b\u0002@\u0006\r\u0017bAAa!\t)\u0011I\u001d:bsB\u0019q\"!2\n\u0007\u0005\u001d\u0007C\u0001\u0003CsR,\u0007\u0002CAf\u0003s\u0003\r!!4\u0002\u000bQ|7.\u001a8\u0011\t\u0005=\u0017Q[\u0007\u0003\u0003#T1!a5\u001b\u0003\r!\u0007\u000e^\u0005\u0005\u0003/\f\tNA\u0003U_.,g\u000e\u000b\u0005\u0002:\u0006m\u0017\u0011]Ar!\u0011\ti)!8\n\t\u0005}\u0017q\u0012\u0002\u0011'V\u0004\bO]3tg^\u000b'O\\5oON\fQA^1mk\u0016d#!!:\"\u0005\u0005\u001d\u0018a\u0004(v[\u0016\u0014\u0018nY(wKJ4Gn\\<\t\u0011\u0005-\u0018Q\u0010C\u0001\u0003[\fQc\u001d;beR\u001cE.^:uKJLgn\u001a)sK\u001aL\u0007\u0010F\u0002\u0000\u0003_D\u0001\"!=\u0002j\u0002\u0007\u00111_\u0001\u0006e\u0006tw-\u001a\t\u0004W\u0005U\u0018bAA|Y\tIA)\u0019;b%\u0006tw-\u001a\u0005\t\u0003w\fi\b\"\u0001\u0002~\u0006!2\u000f^8q\u00072,8\u000f^3sS:<\u0007K]3gSb$2a`A\u0000\u0011!\t\t0!?A\u0002\u0005M\b")
public class ClusteringMapper {
    private final CFMetaData metadata;
    private final ClusteringComparator comparator;
    private final CompositeType clusteringType;
    private final List<ColumnDefinition> clusteringColumns;

    public static Option<ClusteringPrefix> stopClusteringPrefix(DataRange dataRange) {
        return ClusteringMapper$.MODULE$.stopClusteringPrefix(dataRange);
    }

    public static Option<ClusteringPrefix> startClusteringPrefix(DataRange dataRange) {
        return ClusteringMapper$.MODULE$.startClusteringPrefix(dataRange);
    }

    public static byte[] prefix(Token token) {
        return ClusteringMapper$.MODULE$.prefix(token);
    }

    public static int PREFIX_SIZE() {
        return ClusteringMapper$.MODULE$.PREFIX_SIZE();
    }

    public static FieldType FIELD_TYPE() {
        return ClusteringMapper$.MODULE$.FIELD_TYPE();
    }

    public static String FIELD_NAME() {
        return ClusteringMapper$.MODULE$.FIELD_NAME();
    }

    public ClusteringComparator comparator() {
        return this.comparator;
    }

    public CompositeType clusteringType() {
        return this.clusteringType;
    }

    public List<ColumnDefinition> clusteringColumns() {
        return this.clusteringColumns;
    }

    public List<IndexableField> indexableFields(DecoratedKey key, Clustering clustering) {
        BytesRef plainClustering = ByteBufferUtils$.MODULE$.bytesRef(this.byteBuffer(clustering));
        StoredField storedField = new StoredField(ClusteringMapper$.MODULE$.FIELD_NAME(), plainClustering);
        ByteBuffer bb = ByteBuffer.allocate(ClusteringMapper$.MODULE$.PREFIX_SIZE() + plainClustering.length);
        bb.put(ClusteringMapper$.MODULE$.prefix(key.getToken())).put(plainClustering.bytes).flip();
        Field indexedField = new Field(ClusteringMapper$.MODULE$.FIELD_NAME(), ByteBufferUtils$.MODULE$.bytesRef(bb), ClusteringMapper$.MODULE$.FIELD_TYPE());
        return List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Field[]{indexedField, storedField}));
    }

    public ByteBuffer byteBuffer(Clustering clustering) {
        CompositeType.Builder builder = this.clusteringType().builder();
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])clustering.getRawValues())).$div$colon(builder, (Function2<CompositeType.Builder, ByteBuffer, CompositeType.Builder> & Serializable & scala.Serializable)(x$2, x$3) -> x$2.add(x$3)).build();
    }

    public String toString(Option<ClusteringPrefix> prefix) {
        return (String)prefix.map((Function1<ClusteringPrefix, String> & Serializable & scala.Serializable)x$4 -> x$4.toString($this.metadata)).orNull(Predef$.MODULE$.$conforms());
    }

    public Clustering clustering(ByteBuffer clustering) {
        return Clustering.make((ByteBuffer[])this.clusteringType().split(clustering));
    }

    public Clustering clustering(Document document) {
        BytesRef bytesRef = document.getBinaryValue(ClusteringMapper$.MODULE$.FIELD_NAME());
        return this.clustering(ByteBufferUtils$.MODULE$.byteBuffer(bytesRef));
    }

    public SortField sortField() {
        return new ClusteringSort(this);
    }

    public Query query(PartitionPosition position, Option<ClusteringPrefix> start, Option<ClusteringPrefix> stop) {
        return new ClusteringQuery(this, position, start, stop);
    }

    public Query query(DecoratedKey key, Slice slice) {
        return this.query((PartitionPosition)key, Option$.MODULE$.apply(slice.start()), Option$.MODULE$.apply(slice.end()));
    }

    public Query query(DecoratedKey key, ClusteringIndexSliceFilter filter) {
        BooleanQuery.Builder builder2 = new BooleanQuery.Builder();
        return ((TraversableOnce)JavaConverters$.MODULE$.iterableAsScalaIterableConverter(filter.requestedSlices()).asScala()).$div$colon(builder2, (Function2<BooleanQuery.Builder, Slice, BooleanQuery.Builder> & Serializable & scala.Serializable)(builder, slice) -> builder.add(this.query(key, (Slice)slice), BooleanClause.Occur.SHOULD)).build();
    }

    public ClusteringMapper(CFMetaData metadata) {
        this.metadata = metadata;
        this.comparator = metadata.comparator;
        this.clusteringType = CompositeType.getInstance((java.util.List)this.comparator().subtypes());
        this.clusteringColumns = ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(metadata.clusteringColumns()).asScala()).toList();
    }
}

