/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.mapping.ClusteringMapper;
import com.stratio.cassandra.lucene.mapping.ClusteringMapper$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.ClusteringPrefix;
import org.apache.cassandra.db.PartitionPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.utils.FastByteOperations;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;
import scala.Function1;
import scala.Option;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0$mcI$sp;

@ScalaSignature(bytes="\u0006\u0001\u0005\re\u0001B\u0001\u0003\u00015\u0011qb\u00117vgR,'/\u001b8h#V,'/\u001f\u0006\u0003\u0007\u0011\tq!\\1qa&twM\u0003\u0002\u0006\r\u00051A.^2f]\u0016T!a\u0002\u0005\u0002\u0013\r\f7o]1oIJ\f'BA\u0005\u000b\u0003\u001d\u0019HO]1uS>T\u0011aC\u0001\u0004G>l7\u0001A\n\u0003\u00019\u0001\"aD\f\u000e\u0003AQ!!\u0005\n\u0002\rM,\u0017M]2i\u0015\t)1C\u0003\u0002\u0015+\u00051\u0011\r]1dQ\u0016T\u0011AF\u0001\u0004_J<\u0017B\u0001\r\u0011\u00059iU\u000f\u001c;j)\u0016\u0014X.U;fefD\u0001B\u0007\u0001\u0003\u0006\u0004%\taG\u0001\u0007[\u0006\u0004\b/\u001a:\u0016\u0003q\u0001\"!\b\u0010\u000e\u0003\tI!a\b\u0002\u0003!\rcWo\u001d;fe&tw-T1qa\u0016\u0014\b\u0002C\u0011\u0001\u0005\u0003\u0005\u000b\u0011\u0002\u000f\u0002\u000f5\f\u0007\u000f]3sA!A1\u0005\u0001BC\u0002\u0013\u0005A%\u0001\u0005q_NLG/[8o+\u0005)\u0003C\u0001\u0014+\u001b\u00059#B\u0001\u0015*\u0003\t!'M\u0003\u0002\b'%\u00111f\n\u0002\u0012!\u0006\u0014H/\u001b;j_:\u0004vn]5uS>t\u0007\u0002C\u0017\u0001\u0005\u0003\u0005\u000b\u0011B\u0013\u0002\u0013A|7/\u001b;j_:\u0004\u0003\u0002C\u0018\u0001\u0005\u000b\u0007I\u0011\u0001\u0019\u0002\u000bM$\u0018M\u001d;\u0016\u0003E\u00022AM\u001b8\u001b\u0005\u0019$\"\u0001\u001b\u0002\u000bM\u001c\u0017\r\\1\n\u0005Y\u001a$AB(qi&|g\u000e\u0005\u0002'q%\u0011\u0011h\n\u0002\u0011\u00072,8\u000f^3sS:<\u0007K]3gSbD\u0001b\u000f\u0001\u0003\u0002\u0003\u0006I!M\u0001\u0007gR\f'\u000f\u001e\u0011\t\u0011u\u0002!Q1A\u0005\u0002A\nAa\u001d;pa\"Aq\b\u0001B\u0001B\u0003%\u0011'A\u0003ti>\u0004\b\u0005C\u0003B\u0001\u0011\u0005!)\u0001\u0004=S:LGO\u0010\u000b\u0006\u0007\u0012+ei\u0012\t\u0003;\u0001AQA\u0007!A\u0002qAQa\t!A\u0002\u0015BQa\f!A\u0002EBQ!\u0010!A\u0002EBq!\u0013\u0001C\u0002\u0013\u0005!*A\u0003u_.,g.F\u0001L!\tau*D\u0001N\u0015\tq\u0015&A\u0002eQRL!\u0001U'\u0003\u000bQ{7.\u001a8\t\rI\u0003\u0001\u0015!\u0003L\u0003\u0019!xn[3oA!9A\u000b\u0001b\u0001\n\u0003)\u0016\u0001B:fK.,\u0012A\u0016\t\u0004e]K\u0016B\u0001-4\u0005\u0015\t%O]1z!\t\u0011$,\u0003\u0002\\g\t!!)\u001f;f\u0011\u0019i\u0006\u0001)A\u0005-\u0006)1/Z3lA!9q\f\u0001b\u0001\n\u0003\u0001\u0017AC2p[B\f'/\u0019;peV\t\u0011\r\u0005\u0002'E&\u00111m\n\u0002\u0015\u00072,8\u000f^3sS:<7i\\7qCJ\fGo\u001c:\t\r\u0015\u0004\u0001\u0015!\u0003b\u0003-\u0019w.\u001c9be\u0006$xN\u001d\u0011\t\u000b\u001d\u0004A\u0011\t5\u0002\u0019\u001d,G\u000fV3s[N,e.^7\u0015\u0007%|G\u000f\u0005\u0002k[6\t1N\u0003\u0002m%\u0005)\u0011N\u001c3fq&\u0011an\u001b\u0002\n)\u0016\u0014Xn]#ok6DQ\u0001\u001d4A\u0002E\fQ\u0001^3s[N\u0004\"A\u001b:\n\u0005M\\'!\u0002+fe6\u001c\b\"B;g\u0001\u00041\u0018AC1uiJL'-\u001e;fgB\u0011qO_\u0007\u0002q*\u0011\u0011PE\u0001\u0005kRLG.\u0003\u0002|q\ny\u0011\t\u001e;sS\n,H/Z*pkJ\u001cW\rC\u0003~\u0001\u0011\u0005c0\u0001\u0004fcV\fGn\u001d\u000b\u0004\u007f\u0006\u0015\u0001c\u0001\u001a\u0002\u0002%\u0019\u00111A\u001a\u0003\u000f\t{w\u000e\\3b]\"9\u0011q\u0001?A\u0002\u0005%\u0011!A8\u0011\u0007I\nY!C\u0002\u0002\u000eM\u00121!\u00118z\u0011\u001d\t\t\u0002\u0001C!\u0003'\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0003\u0003+\u00012AMA\f\u0013\r\tIb\r\u0002\u0004\u0013:$\bbBA\u000f\u0001\u0011\u0005\u0013qD\u0001\ti>\u001cFO]5oOR!\u0011\u0011EA\u001c!\u0011\t\u0019#!\r\u000f\t\u0005\u0015\u0012Q\u0006\t\u0004\u0003O\u0019TBAA\u0015\u0015\r\tY\u0003D\u0001\u0007yI|w\u000e\u001e \n\u0007\u0005=2'\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003g\t)D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003_\u0019\u0004\u0002CA\u001d\u00037\u0001\r!!\t\u0002\u000b\u0019LW\r\u001c3\u0007\r\u0005u\u0002\u0001AA \u0005\u00052U\u000f\u001c7LKf$\u0015\r^1SC:<WMR5mi\u0016\u0014X\r\u001a+fe6\u001cXI\\;n'\u0011\tY$!\u0011\u0011\u0007)\f\u0019%C\u0002\u0002F-\u0014\u0011CR5mi\u0016\u0014X\r\u001a+fe6\u001cXI\\;n\u0011)\tI%a\u000f\u0003\u0002\u0003\u0006I![\u0001\u0006i\u0016tW/\u001c\u0005\b\u0003\u0006mB\u0011AA')\u0011\ty%a\u0015\u0011\t\u0005E\u00131H\u0007\u0002\u0001!9\u0011\u0011JA&\u0001\u0004I\u0007\u0002CA,\u0003w!\t%!\u0017\u0002\r\u0005\u001c7-\u001a9u)\u0011\tY&!\u001f\u0011\t\u0005u\u00131\u000f\b\u0005\u0003?\nyG\u0004\u0003\u0002b\u00055d\u0002BA2\u0003WrA!!\u001a\u0002j9!\u0011qEA4\u0013\u00051\u0012B\u0001\u000b\u0016\u0013\t)1#\u0003\u0002m%%\u0019\u0011\u0011O6\u0002#\u0019KG\u000e^3sK\u0012$VM]7t\u000b:,X.\u0003\u0003\u0002v\u0005]$\u0001D!dG\u0016\u0004Ho\u0015;biV\u001c(bAA9W\"A\u00111PA+\u0001\u0004\ti(\u0001\u0003uKJl\u0007cA<\u0002\u0000%\u0019\u0011\u0011\u0011=\u0003\u0011\tKH/Z:SK\u001a\u0004")
public class ClusteringQuery
extends MultiTermQuery {
    private final ClusteringMapper mapper;
    private final PartitionPosition position;
    private final Option<ClusteringPrefix> start;
    private final Option<ClusteringPrefix> stop;
    private final Token token;
    private final byte[] seek;
    private final ClusteringComparator comparator;

    public ClusteringMapper mapper() {
        return this.mapper;
    }

    public PartitionPosition position() {
        return this.position;
    }

    public Option<ClusteringPrefix> start() {
        return this.start;
    }

    public Option<ClusteringPrefix> stop() {
        return this.stop;
    }

    public Token token() {
        return this.token;
    }

    public byte[] seek() {
        return this.seek;
    }

    public ClusteringComparator comparator() {
        return this.comparator;
    }

    @Override
    public TermsEnum getTermsEnum(Terms terms, AttributeSource attributes) {
        return new FullKeyDataRangeFilteredTermsEnum(terms.iterator());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object o) {
        Object object = o;
        if (!(object instanceof ClusteringQuery)) return false;
        ClusteringQuery clusteringQuery = (ClusteringQuery)object;
        Token token = this.token();
        Token token2 = clusteringQuery.token();
        if (token == null) {
            if (token2 != null) {
                return false;
            }
        } else if (!token.equals(token2)) return false;
        Option<ClusteringPrefix> option = this.start();
        Option<ClusteringPrefix> option2 = clusteringQuery.start();
        if (option == null) {
            if (option2 != null) {
                return false;
            }
        } else if (!option.equals(option2)) return false;
        Option<ClusteringPrefix> option3 = this.stop();
        Option<ClusteringPrefix> option4 = clusteringQuery.stop();
        if (option3 == null) {
            if (option4 == null) return true;
            return false;
        } else {
            if (!option3.equals(option4)) return false;
            return true;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int result2 = super.hashCode();
        result2 = 31 * result2 + this.token().hashCode();
        result2 = 31 * result2 + BoxesRunTime.unboxToInt(this.start().map((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$8 -> BoxesRunTime.boxToInteger(x$8.hashCode())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
        result2 = 31 * result2 + BoxesRunTime.unboxToInt(this.stop().map((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$9 -> BoxesRunTime.boxToInteger(x$9.hashCode())).getOrElse((JFunction0$mcI$sp & scala.Serializable)() -> 0));
        return (int)var1_1;
    }

    @Override
    public String toString(String field2) {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)field2).add("token", (Object)this.token()).add("start", (Object)this.mapper().toString(this.start())).add("stop", (Object)this.mapper().toString(this.stop())).toString();
    }

    public ClusteringQuery(ClusteringMapper mapper, PartitionPosition position, Option<ClusteringPrefix> start, Option<ClusteringPrefix> stop) {
        this.mapper = mapper;
        this.position = position;
        this.start = start;
        this.stop = stop;
        super(ClusteringMapper$.MODULE$.FIELD_NAME());
        this.token = position.getToken();
        this.seek = ClusteringMapper$.MODULE$.prefix(this.token());
        this.comparator = mapper.comparator();
    }

    public class FullKeyDataRangeFilteredTermsEnum
    extends FilteredTermsEnum {
        @Override
        public FilteredTermsEnum.AcceptStatus accept(BytesRef term) {
            int comp = FastByteOperations.compareUnsigned((byte[])term.bytes, (int)0, (int)ClusteringMapper$.MODULE$.PREFIX_SIZE(), (byte[])this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().seek(), (int)0, (int)ClusteringMapper$.MODULE$.PREFIX_SIZE());
            if (comp < 0) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            if (comp > 0) {
                return FilteredTermsEnum.AcceptStatus.END;
            }
            ByteBuffer bb = ByteBuffer.wrap(term.bytes, ClusteringMapper$.MODULE$.PREFIX_SIZE(), term.length - ClusteringMapper$.MODULE$.PREFIX_SIZE());
            Clustering clustering = this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().mapper().clustering(bb);
            if (this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().start().exists((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean(FullKeyDataRangeFilteredTermsEnum.$anonfun$accept$1(this, clustering, x$10)))) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            if (this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().stop().exists((Function1<ClusteringPrefix, Object> & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean(FullKeyDataRangeFilteredTermsEnum.$anonfun$accept$2(this, clustering, x$11)))) {
                return FilteredTermsEnum.AcceptStatus.NO;
            }
            return FilteredTermsEnum.AcceptStatus.YES;
        }

        public /* synthetic */ ClusteringQuery com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer() {
            return ClusteringQuery.this;
        }

        public static final /* synthetic */ boolean $anonfun$accept$1(FullKeyDataRangeFilteredTermsEnum $this, Clustering clustering$1, ClusteringPrefix x$10) {
            return $this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().comparator().compare(x$10, (ClusteringPrefix)clustering$1) > 0;
        }

        public static final /* synthetic */ boolean $anonfun$accept$2(FullKeyDataRangeFilteredTermsEnum $this, Clustering clustering$1, ClusteringPrefix x$11) {
            return $this.com$stratio$cassandra$lucene$mapping$ClusteringQuery$FullKeyDataRangeFilteredTermsEnum$$$outer().comparator().compare(x$11, (ClusteringPrefix)clustering$1) < 0;
        }

        public FullKeyDataRangeFilteredTermsEnum(TermsEnum tenum) {
            if (ClusteringQuery.this == null) {
                throw null;
            }
            super(tenum);
            this.setInitialSeekTerm(new BytesRef(ClusteringQuery.this.seek()));
        }
    }
}

