/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.column.Column$;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.column.Columns$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ListType;
import org.apache.cassandra.db.marshal.MapType;
import org.apache.cassandra.db.marshal.SetType;
import org.apache.cassandra.db.marshal.TupleType;
import org.apache.cassandra.db.marshal.UserType;
import org.apache.cassandra.db.rows.Cell;
import org.apache.cassandra.db.rows.CellPath;
import org.apache.cassandra.serializers.CollectionSerializer;
import org.apache.cassandra.transport.ProtocolVersion;
import org.apache.cassandra.utils.ByteBufferUtil;
import scala.Function2;
import scala.Predef$;
import scala.collection.Seq;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichInt$;

public final class ColumnsMapper$ {
    public static ColumnsMapper$ MODULE$;

    static {
        new ColumnsMapper$();
    }

    public Columns columns(Cell cell) {
        MapType mapType;
        ListType listType;
        Columns columns;
        SetType setType;
        if (cell == null) {
            return Columns$.MODULE$.apply(Nil$.MODULE$);
        }
        String name = cell.column().name.toString();
        AbstractType comparator = cell.column().type;
        ByteBuffer value = cell.value();
        Column column = Column$.MODULE$.apply(name);
        AbstractType abstractType = comparator;
        if (abstractType instanceof SetType && !(setType = (SetType)abstractType).isFrozenCollection()) {
            AbstractType itemComparator = setType.nameComparator();
            ByteBuffer itemValue = cell.path().get(0);
            columns = this.columns(column, itemComparator, itemValue);
        } else if (abstractType instanceof ListType && !(listType = (ListType)abstractType).isFrozenCollection()) {
            AbstractType itemComparator = listType.valueComparator();
            columns = this.columns(column, itemComparator, value);
        } else if (abstractType instanceof MapType && !(mapType = (MapType)abstractType).isFrozenCollection()) {
            AbstractType valueType = mapType.valueComparator();
            ByteBuffer keyValue = cell.path().get(0);
            AbstractType keyType = mapType.nameComparator();
            String keyName = keyType.compose(keyValue).toString();
            Column keyColumn = column.withUDTName(Column$.MODULE$.MAP_KEY_SUFFIX()).withValue(keyValue, keyType);
            Columns valueColumn = this.columns(column.withUDTName(Column$.MODULE$.MAP_VALUE_SUFFIX()), valueType, value);
            Columns entryColumn = this.columns(column.withMapName(keyName), valueType, value);
            columns = keyColumn.$plus(valueColumn).$plus$plus(entryColumn);
        } else if (abstractType instanceof UserType) {
            Columns columns2;
            UserType userType = (UserType)abstractType;
            CellPath cellPath = cell.path();
            if (cellPath == null) {
                columns2 = this.columns(column, comparator, value);
            } else {
                short position = ByteBufferUtil.toShort((ByteBuffer)cellPath.get(0));
                String name2 = userType.fieldNameAsString((int)position);
                AbstractType typo = userType.type((int)position);
                columns2 = this.columns(column.withUDTName(name2), typo, value);
            }
            columns = columns2;
        } else {
            columns = this.columns(column, comparator, value);
        }
        return columns;
    }

    public Columns columns(Column column, AbstractType<?> serializer, ByteBuffer value) {
        Columns columns;
        AbstractType<?> abstractType = serializer;
        if (abstractType instanceof SetType) {
            SetType setType = (SetType)abstractType;
            columns = this.columns(column, setType, value);
        } else if (abstractType instanceof ListType) {
            ListType listType = (ListType)abstractType;
            columns = this.columns(column, listType, value);
        } else if (abstractType instanceof MapType) {
            MapType mapType = (MapType)abstractType;
            columns = this.columns(column, mapType, value);
        } else if (abstractType instanceof UserType) {
            UserType userType = (UserType)abstractType;
            columns = this.columns(column, userType, value);
        } else if (abstractType instanceof TupleType) {
            TupleType tupleType = (TupleType)abstractType;
            columns = this.columns(column, tupleType, value);
        } else {
            columns = Columns$.MODULE$.apply((Seq<Column>)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{column.withValue(value, serializer)}));
        }
        return columns;
    }

    public Columns columns(Column column, SetType<?> set, ByteBuffer value) {
        AbstractType nameType = set.nameComparator();
        ByteBuffer bb = ByteBufferUtil.clone((ByteBuffer)value);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.frozenCollectionSize(bb)).$colon$bslash(Columns$.MODULE$.apply(Nil$.MODULE$), (Function2<Object, Columns, Columns> & Serializable & scala.Serializable)(x$2, columns) -> ColumnsMapper$.$anonfun$columns$5(this, column, nameType, bb, BoxesRunTime.unboxToInt(x$2), columns));
    }

    public Columns columns(Column column, ListType<?> list, ByteBuffer value) {
        AbstractType valueType = list.valueComparator();
        ByteBuffer bb = ByteBufferUtil.clone((ByteBuffer)value);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.frozenCollectionSize(bb)).$colon$bslash(Columns$.MODULE$.apply(Nil$.MODULE$), (Function2<Object, Columns, Columns> & Serializable & scala.Serializable)(x$3, columns) -> ColumnsMapper$.$anonfun$columns$6(this, column, valueType, bb, BoxesRunTime.unboxToInt(x$3), columns));
    }

    public Columns columns(Column column, MapType<?, ?> map, ByteBuffer value) {
        AbstractType itemKeysType = map.nameComparator();
        AbstractType itemValuesType = map.valueComparator();
        ByteBuffer bb = ByteBufferUtil.clone((ByteBuffer)value);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.frozenCollectionSize(bb)).$colon$bslash(Columns$.MODULE$.apply(Nil$.MODULE$), (Function2<Object, Columns, Columns> & Serializable & scala.Serializable)(x$4, columns) -> ColumnsMapper$.$anonfun$columns$7(this, column, itemKeysType, itemValuesType, bb, BoxesRunTime.unboxToInt(x$4), columns));
    }

    public Columns columns(Column column, UserType udt, ByteBuffer value) {
        ByteBuffer[] itemValues = udt.split(value);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), udt.fieldNames().size()).$colon$bslash(Columns$.MODULE$.apply(Nil$.MODULE$), (Function2<Object, Columns, Columns> & Serializable & scala.Serializable)(i, columns) -> ColumnsMapper$.$anonfun$columns$8(this, column, udt, itemValues, BoxesRunTime.unboxToInt(i), columns));
    }

    public Columns columns(Column column, TupleType tuple, ByteBuffer value) {
        ByteBuffer[] itemValues = tuple.split(value);
        return RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), tuple.size()).$colon$bslash(Columns$.MODULE$.apply(Nil$.MODULE$), (Function2<Object, Columns, Columns> & Serializable & scala.Serializable)(i, columns) -> ColumnsMapper$.$anonfun$columns$9(this, column, tuple, itemValues, BoxesRunTime.unboxToInt(i), columns));
    }

    private int frozenCollectionSize(ByteBuffer bb) {
        return CollectionSerializer.readCollectionSize((ByteBuffer)bb, (ProtocolVersion)ProtocolVersion.CURRENT);
    }

    private ByteBuffer frozenCollectionValue(ByteBuffer bb) {
        return CollectionSerializer.readValue((ByteBuffer)bb, (ProtocolVersion)ProtocolVersion.CURRENT);
    }

    public static final /* synthetic */ Columns $anonfun$columns$5(ColumnsMapper$ $this, Column column$5, AbstractType nameType$1, ByteBuffer bb$1, int x$2, Columns columns) {
        ByteBuffer itemValue = $this.frozenCollectionValue(bb$1);
        return $this.columns(column$5, nameType$1, itemValue).$plus$plus(columns);
    }

    public static final /* synthetic */ Columns $anonfun$columns$6(ColumnsMapper$ $this, Column column$4, AbstractType valueType$1, ByteBuffer bb$2, int x$3, Columns columns) {
        ByteBuffer itemValue = $this.frozenCollectionValue(bb$2);
        return $this.columns(column$4, valueType$1, itemValue).$plus$plus(columns);
    }

    public static final /* synthetic */ Columns $anonfun$columns$7(ColumnsMapper$ $this, Column column$3, AbstractType itemKeysType$1, AbstractType itemValuesType$1, ByteBuffer bb$3, int x$4, Columns columns) {
        ByteBuffer itemKey = $this.frozenCollectionValue(bb$3);
        ByteBuffer itemValue = $this.frozenCollectionValue(bb$3);
        String itemName = itemKeysType$1.compose(itemKey).toString();
        Column keyColumn = column$3.withUDTName(Column$.MODULE$.MAP_KEY_SUFFIX()).withValue(itemKey, itemKeysType$1);
        Columns valueColumn = $this.columns(column$3.withUDTName(Column$.MODULE$.MAP_VALUE_SUFFIX()), itemValuesType$1, itemValue);
        Columns entryColumn = $this.columns(column$3.withMapName(itemName), itemValuesType$1, itemValue);
        return keyColumn.$plus(valueColumn).$plus$plus(entryColumn).$plus$plus(columns);
    }

    public static final /* synthetic */ Columns $anonfun$columns$8(ColumnsMapper$ $this, Column column$2, UserType udt$1, ByteBuffer[] itemValues$1, int i, Columns columns) {
        Columns columns2;
        ByteBuffer itemValue = itemValues$1[i];
        if (itemValue == null) {
            columns2 = columns;
        } else {
            String itemName = udt$1.fieldNameAsString(i);
            AbstractType itemType = udt$1.fieldType(i);
            Column itemColumn = column$2.withUDTName(itemName);
            columns2 = $this.columns(itemColumn, itemType, itemValue).$plus$plus(columns);
        }
        return columns2;
    }

    public static final /* synthetic */ Columns $anonfun$columns$9(ColumnsMapper$ $this, Column column$1, TupleType tuple$1, ByteBuffer[] itemValues$2, int i, Columns columns) {
        Columns columns2;
        ByteBuffer itemValue = itemValues$2[i];
        if (itemValue == null) {
            columns2 = columns;
        } else {
            String itemName = ((Object)BoxesRunTime.boxToInteger(i)).toString();
            AbstractType itemType = tuple$1.type(i);
            Column itemColumn = column$1.withUDTName(itemName);
            columns2 = $this.columns(itemColumn, itemType, itemValue).$plus$plus(columns);
        }
        return columns2;
    }

    private ColumnsMapper$() {
        MODULE$ = this;
    }
}

