/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.stratio.cassandra.lucene.mapping.KeyMapper$;
import com.stratio.cassandra.lucene.util.ByteBufferUtils$;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.Clustering;
import org.apache.cassandra.db.ClusteringComparator;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.filter.ClusteringIndexNamesFilter;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.CompositeType;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.StringField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import scala.Function2;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005]b\u0001B\u0001\u0003\u00015\u0011\u0011bS3z\u001b\u0006\u0004\b/\u001a:\u000b\u0005\r!\u0011aB7baBLgn\u001a\u0006\u0003\u000b\u0019\ta\u0001\\;dK:,'BA\u0004\t\u0003%\u0019\u0017m]:b]\u0012\u0014\u0018M\u0003\u0002\n\u0015\u000591\u000f\u001e:bi&|'\"A\u0006\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001q\u0001CA\b\u0013\u001b\u0005\u0001\"\"A\t\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0001\"AB!osJ+g\r\u0003\u0005\u0016\u0001\t\u0005\t\u0015!\u0003\u0017\u0003!iW\r^1eCR\f\u0007CA\f \u001b\u0005A\"BA\r\u001b\u0003\u0019\u0019wN\u001c4jO*\u0011qa\u0007\u0006\u00039u\ta!\u00199bG\",'\"\u0001\u0010\u0002\u0007=\u0014x-\u0003\u0002!1\tQ1IR'fi\u0006$\u0015\r^1\t\u000b\t\u0002A\u0011A\u0012\u0002\rqJg.\u001b;?)\t!c\u0005\u0005\u0002&\u00015\t!\u0001C\u0003\u0016C\u0001\u0007a\u0003C\u0004)\u0001\t\u0007I\u0011A\u0015\u0002)\rdWo\u001d;fe&twmQ8na\u0006\u0014\u0018\r^8s+\u0005Q\u0003CA\u0016/\u001b\u0005a#BA\u0017\u001b\u0003\t!'-\u0003\u00020Y\t!2\t\\;ti\u0016\u0014\u0018N\\4D_6\u0004\u0018M]1u_JDa!\r\u0001!\u0002\u0013Q\u0013!F2mkN$XM]5oO\u000e{W\u000e]1sCR|'\u000f\t\u0005\bg\u0001\u0011\r\u0011\"\u00015\u00039\u0019G.^:uKJLgn\u001a+za\u0016,\u0012!\u000e\t\u0003mej\u0011a\u000e\u0006\u0003q1\nq!\\1sg\"\fG.\u0003\u0002;o\ti1i\\7q_NLG/\u001a+za\u0016Da\u0001\u0010\u0001!\u0002\u0013)\u0014aD2mkN$XM]5oORK\b/\u001a\u0011\t\u000fy\u0002!\u0019!C\u0001i\u000591.Z=UsB,\u0007B\u0002!\u0001A\u0003%Q'\u0001\u0005lKf$\u0016\u0010]3!\u0011\u0015\u0011\u0005\u0001\"\u0003D\u0003)\u0011\u0017\u0010^3Ck\u001a4WM\u001d\u000b\u0003\t2\u0003\"!\u0012&\u000e\u0003\u0019S!a\u0012%\u0002\u00079LwNC\u0001J\u0003\u0011Q\u0017M^1\n\u0005-3%A\u0003\"zi\u0016\u0014UO\u001a4fe\")Q*\u0011a\u0001\u001d\u0006Q1\r\\;ti\u0016\u0014\u0018N\\4\u0011\u0005-z\u0015B\u0001)-\u0005)\u0019E.^:uKJLgn\u001a\u0005\u0006%\u0002!\taU\u0001\u000fS:$W\r_1cY\u00164\u0015.\u001a7e)\r!6\f\u0019\t\u0003+fk\u0011A\u0016\u0006\u0003/b\u000bQ!\u001b8eKbT!!B\u000e\n\u0005i3&AD%oI\u0016D\u0018M\u00197f\r&,G\u000e\u001a\u0005\u00069F\u0003\r!X\u0001\u0004W\u0016L\bCA\u0016_\u0013\tyFF\u0001\u0007EK\u000e|'/\u0019;fI.+\u0017\u0010C\u0003N#\u0002\u0007a\nC\u0003c\u0001\u0011\u00051-\u0001\u0003uKJlGc\u00013hQB\u0011Q+Z\u0005\u0003MZ\u0013A\u0001V3s[\")A,\u0019a\u0001;\")Q*\u0019a\u0001\u001d\")!\u000e\u0001C\u0005W\u0006A!-\u001f;fgJ+g\rF\u0002meN\u0004\"!\u001c9\u000e\u00039T!a\u001c-\u0002\tU$\u0018\u000e\\\u0005\u0003c:\u0014\u0001BQ=uKN\u0014VM\u001a\u0005\u00069&\u0004\r!\u0018\u0005\u0006\u001b&\u0004\rA\u0014\u0005\u0006k\u0002!\tA^\u0001\u0006cV,'/\u001f\u000b\u0004ovt\bC\u0001=|\u001b\u0005I(B\u0001>Y\u0003\u0019\u0019X-\u0019:dQ&\u0011A0\u001f\u0002\u0006#V,'/\u001f\u0005\u00069R\u0004\r!\u0018\u0005\u0006\u001bR\u0004\rA\u0014\u0005\u0007k\u0002!\t!!\u0001\u0015\u000b]\f\u0019!!\u0002\t\u000bq{\b\u0019A/\t\u000f\u0005\u001dq\u00101\u0001\u0002\n\u00051a-\u001b7uKJ\u0004B!a\u0003\u0002\u00105\u0011\u0011Q\u0002\u0006\u0004\u0003\u000fa\u0013\u0002BA\t\u0003\u001b\u0011!d\u00117vgR,'/\u001b8h\u0013:$W\r\u001f(b[\u0016\u001ch)\u001b7uKJ<q!!\u0006\u0003\u0011\u0003\t9\"A\u0005LKfl\u0015\r\u001d9feB\u0019Q%!\u0007\u0007\r\u0005\u0011\u0001\u0012AA\u000e'\r\tIB\u0004\u0005\bE\u0005eA\u0011AA\u0010)\t\t9\u0002\u0003\u0006\u0002$\u0005e!\u0019!C\u0001\u0003K\t!BR%F\u0019\u0012{f*Q'F+\t\t9\u0003\u0005\u0003\u0002*\u0005=RBAA\u0016\u0015\r\ti\u0003S\u0001\u0005Y\u0006tw-\u0003\u0003\u00022\u0005-\"AB*ue&tw\rC\u0005\u00026\u0005e\u0001\u0015!\u0003\u0002(\u0005Ya)S#M\t~s\u0015)T#!\u0001")
public class KeyMapper {
    private final ClusteringComparator clusteringComparator;
    private final CompositeType clusteringType;
    private final CompositeType keyType;

    public static String FIELD_NAME() {
        return KeyMapper$.MODULE$.FIELD_NAME();
    }

    public ClusteringComparator clusteringComparator() {
        return this.clusteringComparator;
    }

    public CompositeType clusteringType() {
        return this.clusteringType;
    }

    public CompositeType keyType() {
        return this.keyType;
    }

    private ByteBuffer byteBuffer(Clustering clustering) {
        CompositeType.Builder builder = this.clusteringType().builder();
        return new ArrayOps.ofRef<Object>(Predef$.MODULE$.refArrayOps((Object[])clustering.getRawValues())).$div$colon(builder, (Function2<CompositeType.Builder, ByteBuffer, CompositeType.Builder> & Serializable & scala.Serializable)(x$2, x$3) -> x$2.add(x$3)).build();
    }

    public IndexableField indexableField(DecoratedKey key, Clustering clustering) {
        return new StringField(KeyMapper$.MODULE$.FIELD_NAME(), this.bytesRef(key, clustering), Field.Store.NO);
    }

    public Term term(DecoratedKey key, Clustering clustering) {
        return new Term(KeyMapper$.MODULE$.FIELD_NAME(), this.bytesRef(key, clustering));
    }

    private BytesRef bytesRef(DecoratedKey key, Clustering clustering) {
        return ByteBufferUtils$.MODULE$.bytesRef(this.keyType().builder().add(key.getKey()).add(this.byteBuffer(clustering)).build());
    }

    public Query query(DecoratedKey key, Clustering clustering) {
        return new TermQuery(this.term(key, clustering));
    }

    public Query query(DecoratedKey key, ClusteringIndexNamesFilter filter) {
        BooleanQuery.Builder builder2 = new BooleanQuery.Builder();
        return ((TraversableOnce)JavaConverters$.MODULE$.asScalaSetConverter(filter.requestedRows()).asScala()).$div$colon(builder2, (Function2<BooleanQuery.Builder, Clustering, BooleanQuery.Builder> & Serializable & scala.Serializable)(builder, clustering) -> builder.add(this.query(key, (Clustering)clustering), BooleanClause.Occur.SHOULD)).build();
    }

    public KeyMapper(CFMetaData metadata) {
        this.clusteringComparator = metadata.comparator;
        this.clusteringType = CompositeType.getInstance((List)this.clusteringComparator().subtypes());
        this.keyType = CompositeType.getInstance((AbstractType[])new AbstractType[]{metadata.getKeyValidator(), this.clusteringType()});
    }
}

