/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.mapping.TokenMapper$;
import org.apache.cassandra.config.DatabaseDescriptor;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.Token;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.DocValuesRangeQuery;
import org.apache.lucene.search.NumericRangeQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0001\u0003\u00015\u00111\u0002V8lK:l\u0015\r\u001d9fe*\u00111\u0001B\u0001\b[\u0006\u0004\b/\u001b8h\u0015\t)a!\u0001\u0004mk\u000e,g.\u001a\u0006\u0003\u000f!\t\u0011bY1tg\u0006tGM]1\u000b\u0005%Q\u0011aB:ue\u0006$\u0018n\u001c\u0006\u0002\u0017\u0005\u00191m\\7\u0004\u0001M\u0011\u0001A\u0004\t\u0003\u001fIi\u0011\u0001\u0005\u0006\u0002#\u0005)1oY1mC&\u00111\u0003\u0005\u0002\u0007\u0003:L(+\u001a4\t\u000bU\u0001A\u0011\u0001\f\u0002\rqJg.\u001b;?)\u00059\u0002C\u0001\r\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e\u0001\t\u0003Y\u0012AD5oI\u0016D\u0018M\u00197f\r&,G\u000e\u001a\u000b\u00039\u001d\u0002\"!H\u0013\u000e\u0003yQ!a\b\u0011\u0002\u000b%tG-\u001a=\u000b\u0005\u0015\t#B\u0001\u0012$\u0003\u0019\t\u0007/Y2iK*\tA%A\u0002pe\u001eL!A\n\u0010\u0003\u001d%sG-\u001a=bE2,g)[3mI\")\u0001&\u0007a\u0001S\u0005\u00191.Z=\u0011\u0005)rS\"A\u0016\u000b\u00051j\u0013A\u00013c\u0015\t9\u0011%\u0003\u00020W\taA)Z2pe\u0006$X\rZ&fs\")\u0011\u0007\u0001C\u0001e\u0005I1o\u001c:u\r&,G\u000eZ\u000b\u0002gA\u0011AgN\u0007\u0002k)\u0011a\u0007I\u0001\u0007g\u0016\f'o\u00195\n\u0005a*$!C*peR4\u0015.\u001a7e\u0011\u0015Q\u0004\u0001\"\u0001<\u0003\u0015\tX/\u001a:z)\u0015a$I\u0013'R!\ryQhP\u0005\u0003}A\u0011aa\u00149uS>t\u0007C\u0001\u001bA\u0013\t\tUGA\u0003Rk\u0016\u0014\u0018\u0010C\u0003Ds\u0001\u0007A)A\u0003m_^,'\u000f\u0005\u0002F\u00116\taI\u0003\u0002H[\u0005\u0019A\r\u001b;\n\u0005%3%!\u0002+pW\u0016t\u0007\"B&:\u0001\u0004!\u0015!B;qa\u0016\u0014\b\"B':\u0001\u0004q\u0015\u0001D5oG2,H-\u001a'po\u0016\u0014\bCA\bP\u0013\t\u0001\u0006CA\u0004C_>dW-\u00198\t\u000bIK\u0004\u0019\u0001(\u0002\u0019%t7\r\\;eKV\u0003\b/\u001a:\t\u000bi\u0002A\u0011\u0001+\u0015\u0005}*\u0006\"\u0002,T\u0001\u0004!\u0015!\u0002;pW\u0016tw!\u0002-\u0003\u0011\u0003I\u0016a\u0003+pW\u0016tW*\u00199qKJ\u0004\"\u0001\u0007.\u0007\u000b\u0005\u0011\u0001\u0012A.\u0014\u0005is\u0001\"B\u000b[\t\u0003iF#A-\t\u000f}S&\u0019!C\u0001A\u0006Qa)S#M\t~s\u0015)T#\u0016\u0003\u0005\u0004\"AY4\u000e\u0003\rT!\u0001Z3\u0002\t1\fgn\u001a\u0006\u0002M\u0006!!.\u0019<b\u0013\tA7M\u0001\u0004TiJLgn\u001a\u0005\u0007Uj\u0003\u000b\u0011B1\u0002\u0017\u0019KU\t\u0014#`\u001d\u0006kU\t\t\u0005\bYj\u0013\r\u0011\"\u0001n\u0003)1\u0015*\u0012'E?RK\u0006+R\u000b\u0002]B\u0011qN]\u0007\u0002a*\u0011\u0011\u000fI\u0001\tI>\u001cW/\\3oi&\u00111\u000f\u001d\u0002\n\r&,G\u000e\u001a+za\u0016Da!\u001e.!\u0002\u0013q\u0017a\u0003$J\u000b2#u\fV-Q\u000b\u0002BQa\u001e.\u0005\u0002a\f\u0011\u0002\\8oOZ\u000bG.^3\u0015\u0005ed\bCA\b{\u0013\tY\bC\u0001\u0003M_:<\u0007\"\u0002,w\u0001\u0004!\u0005\"\u0002@[\t\u0003y\u0018\u0001\u00032zi\u0016\u001c(+\u001a4\u0015\t\u0005\u0005\u0011Q\u0002\t\u0005\u0003\u0007\tI!\u0004\u0002\u0002\u0006)\u0019\u0011q\u0001\u0011\u0002\tU$\u0018\u000e\\\u0005\u0005\u0003\u0017\t)A\u0001\u0005CsR,7OU3g\u0011\u00151V\u00101\u0001E\u0001")
public class TokenMapper {
    public static BytesRef bytesRef(Token token) {
        return TokenMapper$.MODULE$.bytesRef(token);
    }

    public static long longValue(Token token) {
        return TokenMapper$.MODULE$.longValue(token);
    }

    public static FieldType FIELD_TYPE() {
        return TokenMapper$.MODULE$.FIELD_TYPE();
    }

    public static String FIELD_NAME() {
        return TokenMapper$.MODULE$.FIELD_NAME();
    }

    public IndexableField indexableField(DecoratedKey key) {
        Token token = key.getToken();
        long value = TokenMapper$.MODULE$.longValue(token);
        return new LongField(TokenMapper$.MODULE$.FIELD_NAME(), value, TokenMapper$.MODULE$.FIELD_TYPE());
    }

    public SortField sortField() {
        return new SortField(TokenMapper$.MODULE$.FIELD_NAME(), SortField.Type.LONG);
    }

    public Option<Query> query(Token lower, Token upper, boolean includeLower, boolean includeUpper) {
        if (lower.isMinimum() && upper.isMinimum()) {
            return None$.MODULE$;
        }
        Long min = lower.isMinimum() ? Predef$.MODULE$.long2Long(Long.MIN_VALUE) : Predef$.MODULE$.long2Long(TokenMapper$.MODULE$.longValue(lower));
        Long max = upper.isMinimum() ? Predef$.MODULE$.long2Long(Long.MAX_VALUE) : Predef$.MODULE$.long2Long(TokenMapper$.MODULE$.longValue(upper));
        return Predef$.MODULE$.Long2long(max) / 10L - Predef$.MODULE$.Long2long(min) / 10L > 1222337203685480000L ? new Some<Query>(DocValuesRangeQuery.newLongRange(TokenMapper$.MODULE$.FIELD_NAME(), min, max, includeLower, includeUpper)) : new Some<NumericRangeQuery<Long>>(NumericRangeQuery.newLongRange(TokenMapper$.MODULE$.FIELD_NAME(), min, max, includeLower, includeUpper));
    }

    public Query query(Token token) {
        return new TermQuery(new Term(TokenMapper$.MODULE$.FIELD_NAME(), TokenMapper$.MODULE$.bytesRef(token)));
    }

    public TokenMapper() {
        if (!(DatabaseDescriptor.getPartitioner() instanceof Murmur3Partitioner)) {
            throw new IndexException("Only Murmur3 partitioner is supported");
        }
    }
}

