/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.partitioning;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.partitioning.Partitioner;
import com.stratio.cassandra.lucene.partitioning.PartitionerOnVirtualNode$;
import com.stratio.cassandra.lucene.util.Logging;
import com.typesafe.scalalogging.Logger;
import com.typesafe.scalalogging.StrictLogging;
import java.io.Serializable;
import org.apache.cassandra.config.CFMetaData;
import org.apache.cassandra.db.DataRange;
import org.apache.cassandra.db.DecoratedKey;
import org.apache.cassandra.db.PartitionRangeReadCommand;
import org.apache.cassandra.db.ReadCommand;
import org.apache.cassandra.db.SinglePartitionReadCommand;
import org.apache.cassandra.dht.Bounds;
import org.apache.cassandra.dht.Murmur3Partitioner;
import org.apache.cassandra.dht.RingPosition;
import org.apache.cassandra.dht.Token;
import org.apache.cassandra.service.StorageService;
import scala.Function1;
import scala.Option;
import scala.Predef$;
import scala.Product;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenTraversable;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.mutable.HashMap;
import scala.math.Ordering$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.RichDouble$;
import scala.runtime.RichInt$;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import scala.runtime.java8.JFunction1$mcVI$sp;

@ScalaSignature(bytes="\u0006\u0001\t%d\u0001B\u0001\u0003\u00016\u0011\u0001\u0004U1si&$\u0018n\u001c8fe>sg+\u001b:uk\u0006dgj\u001c3f\u0015\t\u0019A!\u0001\u0007qCJ$\u0018\u000e^5p]&twM\u0003\u0002\u0006\r\u00051A.^2f]\u0016T!a\u0002\u0005\u0002\u0013\r\f7o]1oIJ\f'BA\u0005\u000b\u0003\u001d\u0019HO]1uS>T\u0011aC\u0001\u0004G>l7\u0001A\n\u0007\u00019!\u0002DH\u0011\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)b#D\u0001\u0003\u0013\t9\"AA\u0006QCJ$\u0018\u000e^5p]\u0016\u0014\bCA\r\u001d\u001b\u0005Q\"BA\u000e\u0005\u0003\u0011)H/\u001b7\n\u0005uQ\"a\u0002'pO\u001eLgn\u001a\t\u0003\u001f}I!\u0001\t\t\u0003\u000fA\u0013x\u000eZ;diB\u0011qBI\u0005\u0003GA\u0011AbU3sS\u0006d\u0017N_1cY\u0016D\u0001\"\n\u0001\u0003\u0016\u0004%\tAJ\u0001\u0015m:|G-Z:`a\u0016\u0014x\f]1si&$\u0018n\u001c8\u0016\u0003\u001d\u0002\"a\u0004\u0015\n\u0005%\u0002\"aA%oi\"A1\u0006\u0001B\tB\u0003%q%A\u000bw]>$Wm]0qKJ|\u0006/\u0019:uSRLwN\u001c\u0011\t\u00115\u0002!Q3A\u0005\u00029\na\u0001^8lK:\u001cX#A\u0018\u0011\u0007AB4H\u0004\u00022m9\u0011!'N\u0007\u0002g)\u0011A\u0007D\u0001\u0007yI|w\u000e\u001e \n\u0003EI!a\u000e\t\u0002\u000fA\f7m[1hK&\u0011\u0011H\u000f\u0002\u0005\u0019&\u001cHO\u0003\u00028!A\u0011A\bR\u0007\u0002{)\u0011ahP\u0001\u0004I\"$(BA\u0004A\u0015\t\t%)\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0007\u0006\u0019qN]4\n\u0005\u0015k$!\u0002+pW\u0016t\u0007\u0002C$\u0001\u0005#\u0005\u000b\u0011B\u0018\u0002\u000fQ|7.\u001a8tA!)\u0011\n\u0001C\u0001\u0015\u00061A(\u001b8jiz\"2a\u0013'N!\t)\u0002\u0001C\u0003&\u0011\u0002\u0007q\u0005C\u0003.\u0011\u0002\u0007q\u0006C\u0004P\u0001\t\u0007I\u0011\u0001\u0014\u0002\u00139,X\u000eV8lK:\u001c\bBB)\u0001A\u0003%q%\u0001\u0006ok6$vn[3og\u0002Bqa\u0015\u0001C\u0002\u0013\u0005A+A\tqCJ$\u0018\u000e^5p]B+'OQ8v]\u0012,\u0012!\u0016\t\u0005-nkv%D\u0001X\u0015\tA\u0016,A\u0004nkR\f'\r\\3\u000b\u0005i\u0003\u0012AC2pY2,7\r^5p]&\u0011Al\u0016\u0002\b\u0011\u0006\u001c\b.T1q!\radlO\u0005\u0003?v\u0012aAQ8v]\u0012\u001c\bBB1\u0001A\u0003%Q+\u0001\nqCJ$\u0018\u000e^5p]B+'OQ8v]\u0012\u0004\u0003bB2\u0001\u0005\u0004%\tAJ\u0001\na\u0006\u0014H/\u001b;j_:Da!\u001a\u0001!\u0002\u00139\u0013A\u00039beRLG/[8oA!)q\r\u0001C!M\u0005ia.^7QCJ$\u0018\u000e^5p]NDQ!\u001b\u0001\u0005B)\f!\u0002]1si&$\u0018n\u001c8t)\tYG\u000eE\u00021q\u001dBQ!\u001c5A\u00029\fqaY8n[\u0006tG\r\u0005\u0002pe6\t\u0001O\u0003\u0002r\u007f\u0005\u0011AMY\u0005\u0003gB\u00141BU3bI\u000e{W.\\1oI\")\u0011\u000e\u0001C\u0001kR\u00191N\u001e=\t\u000b]$\b\u0019A\u001e\u0002\u000b1|w/\u001a:\t\u000be$\b\u0019A\u001e\u0002\u000bU\u0004\b/\u001a:\t\u000b\r\u0004A\u0011I>\u0015\u0005\u001db\b\"B?{\u0001\u0004q\u0018aA6fsB\u0011qn`\u0005\u0004\u0003\u0003\u0001(\u0001\u0004#fG>\u0014\u0018\r^3e\u0017\u0016L\bbB2\u0001A\u0013%\u0011Q\u0001\u000b\u0004O\u0005\u001d\u0001bBA\u0005\u0003\u0007\u0001\raO\u0001\u0006i>\\WM\u001c\u0005\n\u0003\u001b\u0001\u0011\u0011!C\u0001\u0003\u001f\tAaY8qsR)1*!\u0005\u0002\u0014!AQ%a\u0003\u0011\u0002\u0003\u0007q\u0005\u0003\u0005.\u0003\u0017\u0001\n\u00111\u00010\u0011%\t9\u0002AI\u0001\n\u0003\tI\"\u0001\bd_BLH\u0005Z3gCVdG\u000fJ\u0019\u0016\u0005\u0005m!fA\u0014\u0002\u001e-\u0012\u0011q\u0004\t\u0005\u0003C\tY#\u0004\u0002\u0002$)!\u0011QEA\u0014\u0003%)hn\u00195fG.,GMC\u0002\u0002*A\t!\"\u00198o_R\fG/[8o\u0013\u0011\ti#a\t\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\rC\u0005\u00022\u0001\t\n\u0011\"\u0001\u00024\u0005q1m\u001c9zI\u0011,g-Y;mi\u0012\u0012TCAA\u001bU\ry\u0013Q\u0004\u0005\n\u0003s\u0001\u0011\u0011!C!\u0003w\tQ\u0002\u001d:pIV\u001cG\u000f\u0015:fM&DXCAA\u001f!\u0011\ty$!\u0013\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\nA\u0001\\1oO*\u0011\u0011qI\u0001\u0005U\u00064\u0018-\u0003\u0003\u0002L\u0005\u0005#AB*ue&tw\r\u0003\u0005\u0002P\u0001\t\t\u0011\"\u0001'\u00031\u0001(o\u001c3vGR\f%/\u001b;z\u0011%\t\u0019\u0006AA\u0001\n\u0003\t)&\u0001\bqe>$Wo\u0019;FY\u0016lWM\u001c;\u0015\t\u0005]\u0013Q\f\t\u0004\u001f\u0005e\u0013bAA.!\t\u0019\u0011I\\=\t\u0013\u0005}\u0013\u0011KA\u0001\u0002\u00049\u0013a\u0001=%c!I\u00111\r\u0001\u0002\u0002\u0013\u0005\u0013QM\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011\u0011q\r\t\u0007\u0003S\nY'a\u0016\u000e\u0003eK1!!\u001cZ\u0005!IE/\u001a:bi>\u0014\b\"CA9\u0001\u0005\u0005I\u0011AA:\u0003!\u0019\u0017M\\#rk\u0006dG\u0003BA;\u0003w\u00022aDA<\u0013\r\tI\b\u0005\u0002\b\u0005>|G.Z1o\u0011)\ty&a\u001c\u0002\u0002\u0003\u0007\u0011q\u000b\u0005\n\u0003\u007f\u0002\u0011\u0011!C!\u0003\u0003\u000b\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002O!I\u0011Q\u0011\u0001\u0002\u0002\u0013\u0005\u0013qQ\u0001\ti>\u001cFO]5oOR\u0011\u0011Q\b\u0005\n\u0003\u0017\u0003\u0011\u0011!C!\u0003\u001b\u000ba!Z9vC2\u001cH\u0003BA;\u0003\u001fC!\"a\u0018\u0002\n\u0006\u0005\t\u0019AA,\u000f\u001d\t\u0019J\u0001E\u0001\u0003+\u000b\u0001\u0004U1si&$\u0018n\u001c8fe>sg+\u001b:uk\u0006dgj\u001c3f!\r)\u0012q\u0013\u0004\u0007\u0003\tA\t!!'\u0014\t\u0005]e\"\t\u0005\b\u0013\u0006]E\u0011AAO)\t\t)JB\u0004\u0002\"\u0006]\u0005)a)\u0003\u000f\t+\u0018\u000e\u001c3feN9\u0011q\u0014\b\u0002&z\t\u0003\u0003BAT\u0003[s1!FAU\u0013\r\tYKA\u0001\f!\u0006\u0014H/\u001b;j_:,'/\u0003\u0003\u0002\"\u0006=&bAAV\u0005!IQ%a(\u0003\u0016\u0004%\tA\n\u0005\nW\u0005}%\u0011#Q\u0001\n\u001dBq!SAP\t\u0003\t9\f\u0006\u0003\u0002:\u0006u\u0006\u0003BA^\u0003?k!!a&\t\r\u0015\n)\f1\u0001(Q!\ti,!1\u0002T\u0006U\u0007\u0003BAb\u0003\u001fl!!!2\u000b\t\u0005%\u0012q\u0019\u0006\u0005\u0003\u0013\fY-A\u0004kC\u000e\\7o\u001c8\u000b\u0007\u00055'\"A\u0005gCN$XM\u001d=nY&!\u0011\u0011[Ac\u00051Q5o\u001c8Qe>\u0004XM\u001d;z\u0003\u00151\u0018\r\\;fC\u0005)\u0003\u0002CAm\u0003?#\t%a7\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u0007-\u000bi\u000e\u0003\u0005\u0002`\u0006]\u0007\u0019AAq\u0003!iW\r^1eCR\f\u0007\u0003BAr\u0003Sl!!!:\u000b\u0007\u0005\u001dx(\u0001\u0004d_:4\u0017nZ\u0005\u0005\u0003W\f)O\u0001\u0006D\r6+G/\u0019#bi\u0006D!\"!\u0004\u0002 \u0006\u0005I\u0011AAx)\u0011\tI,!=\t\u0011\u0015\ni\u000f%AA\u0002\u001dB!\"a\u0006\u0002 F\u0005I\u0011AA\r\u0011)\tI$a(\u0002\u0002\u0013\u0005\u00131\b\u0005\n\u0003\u001f\ny*!A\u0005\u0002\u0019B!\"a\u0015\u0002 \u0006\u0005I\u0011AA~)\u0011\t9&!@\t\u0013\u0005}\u0013\u0011`A\u0001\u0002\u00049\u0003BCA2\u0003?\u000b\t\u0011\"\u0011\u0002f!Q\u0011\u0011OAP\u0003\u0003%\tAa\u0001\u0015\t\u0005U$Q\u0001\u0005\u000b\u0003?\u0012\t!!AA\u0002\u0005]\u0003BCA@\u0003?\u000b\t\u0011\"\u0011\u0002\u0002\"Q\u0011QQAP\u0003\u0003%\t%a\"\t\u0015\u0005-\u0015qTA\u0001\n\u0003\u0012i\u0001\u0006\u0003\u0002v\t=\u0001BCA0\u0005\u0017\t\t\u00111\u0001\u0002X\u001dQ!1CAL\u0003\u0003E\tA!\u0006\u0002\u000f\t+\u0018\u000e\u001c3feB!\u00111\u0018B\f\r)\t\t+a&\u0002\u0002#\u0005!\u0011D\n\u0006\u0005/\u0011Y\"\t\t\b\u0005;\u0011\u0019cJA]\u001b\t\u0011yBC\u0002\u0003\"A\tqA];oi&lW-\u0003\u0003\u0003&\t}!!E!cgR\u0014\u0018m\u0019;Gk:\u001cG/[8oc!9\u0011Ja\u0006\u0005\u0002\t%BC\u0001B\u000b\u0011)\t)Ia\u0006\u0002\u0002\u0013\u0015\u0013q\u0011\u0005\u000b\u0005_\u00119\"!A\u0005\u0002\nE\u0012!B1qa2LH\u0003BA]\u0005gAa!\nB\u0017\u0001\u00049\u0003B\u0003B\u001c\u0005/\t\t\u0011\"!\u0003:\u00059QO\\1qa2LH\u0003\u0002B\u001e\u0005\u0003\u0002Ba\u0004B\u001fO%\u0019!q\b\t\u0003\r=\u0003H/[8o\u0011)\u0011\u0019E!\u000e\u0002\u0002\u0003\u0007\u0011\u0011X\u0001\u0004q\u0012\u0002\u0004B\u0003B$\u0005/\t\t\u0011\"\u0003\u0003J\u0005Y!/Z1e%\u0016\u001cx\u000e\u001c<f)\t\u0011Y\u0005\u0005\u0003\u0002@\t5\u0013\u0002\u0002B(\u0003\u0003\u0012aa\u00142kK\u000e$\bB\u0003B\u0018\u0003/\u000b\t\u0011\"!\u0003TQ)1J!\u0016\u0003X!1QE!\u0015A\u0002\u001dBa!\fB)\u0001\u0004y\u0003B\u0003B\u001c\u0003/\u000b\t\u0011\"!\u0003\\Q!!Q\fB3!\u0015y!Q\bB0!\u0015y!\u0011M\u00140\u0013\r\u0011\u0019\u0007\u0005\u0002\u0007)V\u0004H.\u001a\u001a\t\u0013\t\r#\u0011LA\u0001\u0002\u0004Y\u0005B\u0003B$\u0003/\u000b\t\u0011\"\u0003\u0003J\u0001")
public class PartitionerOnVirtualNode
implements Partitioner,
Logging,
Product,
scala.Serializable {
    private final int vnodes_per_partition;
    private final List<Token> tokens;
    private final int numTokens;
    private final HashMap<Bounds<Token>, Object> partitionPerBound;
    private final int partition;
    private final Logger logger;
    private List<Object> allPartitions;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<Object, List<Token>>> unapply(PartitionerOnVirtualNode partitionerOnVirtualNode) {
        return PartitionerOnVirtualNode$.MODULE$.unapply(partitionerOnVirtualNode);
    }

    public static PartitionerOnVirtualNode apply(int n, List<Token> list) {
        return PartitionerOnVirtualNode$.MODULE$.apply(n, list);
    }

    @Override
    public Logger logger() {
        return this.logger;
    }

    @Override
    public void com$typesafe$scalalogging$StrictLogging$_setter_$logger_$eq(Logger x$1) {
        this.logger = x$1;
    }

    private List<Object> allPartitions$lzycompute() {
        PartitionerOnVirtualNode partitionerOnVirtualNode = this;
        synchronized (partitionerOnVirtualNode) {
            if (!this.bitmap$0) {
                this.allPartitions = Partitioner.allPartitions$(this);
                this.bitmap$0 = true;
            }
        }
        return this.allPartitions;
    }

    @Override
    public List<Object> allPartitions() {
        return !this.bitmap$0 ? this.allPartitions$lzycompute() : this.allPartitions;
    }

    public int vnodes_per_partition() {
        return this.vnodes_per_partition;
    }

    public List<Token> tokens() {
        return this.tokens;
    }

    public int numTokens() {
        return this.numTokens;
    }

    public HashMap<Bounds<Token>, Object> partitionPerBound() {
        return this.partitionPerBound;
    }

    public int partition() {
        return this.partition;
    }

    @Override
    public int numPartitions() {
        return (int)RichDouble$.MODULE$.ceil$extension(Predef$.MODULE$.doubleWrapper((double)this.numTokens() / (double)this.vnodes_per_partition()));
    }

    @Override
    public List<Object> partitions(ReadCommand command) {
        List<Object> list;
        ReadCommand readCommand = command;
        if (readCommand instanceof SinglePartitionReadCommand) {
            SinglePartitionReadCommand singlePartitionReadCommand = (SinglePartitionReadCommand)readCommand;
            list = List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.partition(singlePartitionReadCommand.partitionKey())}));
        } else if (readCommand instanceof PartitionRangeReadCommand) {
            PartitionRangeReadCommand partitionRangeReadCommand = (PartitionRangeReadCommand)readCommand;
            DataRange range = partitionRangeReadCommand.dataRange();
            list = this.partitions(range.startKey().getToken(), range.stopKey().getToken());
        } else {
            throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported read command type: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{command.getClass()})));
        }
        return list;
    }

    public List<Object> partitions(Token lower, Token upper) {
        GenTraversable<Object> genTraversable;
        if (lower.equals((Object)upper)) {
            genTraversable = lower.isMinimum() ? this.allPartitions() : List$.MODULE$.apply(Predef$.MODULE$.wrapIntArray(new int[]{this.partition(lower)}));
        } else {
            int upperPartition;
            int lowerPartition = this.partition(lower);
            if (lowerPartition <= (upperPartition = this.partition(upper))) {
                genTraversable = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lowerPartition), upperPartition).toList();
            } else {
                List list = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(lowerPartition), this.numTokens()).toList();
                genTraversable = RichInt$.MODULE$.to$extension0(Predef$.MODULE$.intWrapper(0), upperPartition).toList().$colon$colon$colon(list);
            }
        }
        return genTraversable;
    }

    @Override
    public int partition(DecoratedKey key) {
        return this.partition(key.getToken());
    }

    private int partition(Token token) {
        return ((Tuple2)((TraversableOnce)this.partitionPerBound().filter((Function1<Tuple2, Object> & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean(PartitionerOnVirtualNode.$anonfun$partition$1(token, x$2)))).toList().head())._2$mcI$sp();
    }

    public PartitionerOnVirtualNode copy(int vnodes_per_partition, List<Token> tokens) {
        return new PartitionerOnVirtualNode(vnodes_per_partition, tokens);
    }

    public int copy$default$1() {
        return this.vnodes_per_partition();
    }

    public List<Token> copy$default$2() {
        return this.tokens();
    }

    @Override
    public String productPrefix() {
        return "PartitionerOnVirtualNode";
    }

    @Override
    public int productArity() {
        return 2;
    }

    @Override
    public Object productElement(int x$1) {
        Serializable serializable;
        int n = x$1;
        switch (n) {
            case 0: {
                serializable = BoxesRunTime.boxToInteger(this.vnodes_per_partition());
                break;
            }
            case 1: {
                serializable = this.tokens();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
            }
        }
        return serializable;
    }

    @Override
    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator(this);
    }

    @Override
    public boolean canEqual(Object x$1) {
        return x$1 instanceof PartitionerOnVirtualNode;
    }

    public int hashCode() {
        int n = -889275714;
        n = Statics.mix(n, this.vnodes_per_partition());
        n = Statics.mix(n, Statics.anyHash(this.tokens()));
        return Statics.finalizeHash(n, 2);
    }

    public String toString() {
        return ScalaRunTime$.MODULE$._toString(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof PartitionerOnVirtualNode)) return false;
        boolean bl = true;
        if (!bl) return false;
        PartitionerOnVirtualNode partitionerOnVirtualNode = (PartitionerOnVirtualNode)x$1;
        if (this.vnodes_per_partition() != partitionerOnVirtualNode.vnodes_per_partition()) return false;
        List<Token> list = this.tokens();
        List<Token> list2 = partitionerOnVirtualNode.tokens();
        if (list == null) {
            if (list2 != null) {
                return false;
            }
        } else if (!((Object)list).equals(list2)) return false;
        if (!partitionerOnVirtualNode.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ boolean $anonfun$partition$1(Token token$1, Tuple2 x$2) {
        return ((Bounds)x$2._1()).contains((RingPosition)token$1);
    }

    public PartitionerOnVirtualNode(int vnodes_per_partition, List<Token> tokens) {
        block5: {
            BoxedUnit boxedUnit;
            this.vnodes_per_partition = vnodes_per_partition;
            this.tokens = tokens;
            Partitioner.$init$(this);
            StrictLogging.$init$(this);
            Product.$init$(this);
            if (vnodes_per_partition <= 0) {
                throw new IndexException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"The number of virtual nodes per partition should be strictly positive but found ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(vnodes_per_partition)})));
            }
            this.numTokens = tokens.size();
            this.partitionPerBound = new HashMap();
            if (this.numTokens() == 1) {
                if (this.logger().underlying().isWarnEnabled()) {
                    this.logger().underlying().warn("You are using a PartitionerOnVirtualNode but cassandra is only configured with one token (not using virtual nodes.)");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.partition = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)(this.numPartitions() - 1) / (double)vnodes_per_partition));
            RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), this.numPartitions() - 1).foreach$mVc$sp((JFunction1$mcVI$sp & scala.Serializable)i -> {
                Bounds bound = new Bounds((RingPosition)this.tokens().apply(i), (RingPosition)new Murmur3Partitioner.LongToken(BoxesRunTime.unboxToLong(this.tokens().apply(i + 1).getTokenValue()) - 1L));
                int partition = (int)RichDouble$.MODULE$.floor$extension(Predef$.MODULE$.doubleWrapper((double)i / (double)this.vnodes_per_partition()));
                this.partitionPerBound().update((Bounds<Token>)bound, BoxesRunTime.boxToInteger(partition));
            });
            this.partitionPerBound().update((Bounds<Token>)new Bounds((RingPosition)tokens.apply(this.numPartitions() - 1), (RingPosition)new Murmur3Partitioner.LongToken(Long.MAX_VALUE)), BoxesRunTime.boxToInteger(this.partition()));
            if (BoxesRunTime.unboxToLong(tokens.head().getTokenValue()) == Long.MIN_VALUE) break block5;
            this.partitionPerBound().update((Bounds<Token>)new Bounds((RingPosition)new Murmur3Partitioner.LongToken(Long.MIN_VALUE), (RingPosition)tokens.head()), BoxesRunTime.boxToInteger(this.partition()));
        }
    }

    public static class Builder
    implements Partitioner.Builder,
    Product,
    scala.Serializable {
        private final int vnodes_per_partition;

        public int vnodes_per_partition() {
            return this.vnodes_per_partition;
        }

        @Override
        public PartitionerOnVirtualNode build(CFMetaData metadata) {
            return new PartitionerOnVirtualNode(this.vnodes_per_partition(), (List)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(StorageService.instance.getLocalTokens()).asScala()).toList().sorted(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms())));
        }

        public Builder copy(int vnodes_per_partition) {
            return new Builder(vnodes_per_partition);
        }

        public int copy$default$1() {
            return this.vnodes_per_partition();
        }

        @Override
        public String productPrefix() {
            return "Builder";
        }

        @Override
        public int productArity() {
            return 1;
        }

        @Override
        public Object productElement(int x$1) {
            int n = x$1;
            switch (n) {
                case 0: {
                    break;
                }
                default: {
                    throw new IndexOutOfBoundsException(((Object)BoxesRunTime.boxToInteger(x$1)).toString());
                }
            }
            return BoxesRunTime.boxToInteger(this.vnodes_per_partition());
        }

        @Override
        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator(this);
        }

        @Override
        public boolean canEqual(Object x$1) {
            return x$1 instanceof Builder;
        }

        public int hashCode() {
            int n = -889275714;
            n = Statics.mix(n, this.vnodes_per_partition());
            return Statics.finalizeHash(n, 1);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString(this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            Object object = x$1;
            if (!(object instanceof Builder)) return false;
            boolean bl = true;
            if (!bl) return false;
            Builder builder = (Builder)x$1;
            if (this.vnodes_per_partition() != builder.vnodes_per_partition()) return false;
            if (!builder.canEqual(this)) return false;
            return true;
        }

        public Builder(@JsonProperty(value="vnodes_per_partition") int vnodes_per_partition) {
            this.vnodes_per_partition = vnodes_per_partition;
            Product.$init$(this);
        }
    }
}

