/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.schema.SchemaAnalyzer;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.search.Search;
import java.io.Closeable;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.index.IndexableField;

public class Schema
implements Closeable {
    public final Map<String, Mapper> mappers;
    public final SchemaAnalyzer analyzer;
    public final Analyzer defaultAnalyzer;
    private final Set<String> mappedCells;

    public Schema(Analyzer defaultAnalyzer, Map<String, Mapper> mappers, Map<String, Analyzer> analyzers) {
        this.mappers = mappers;
        this.defaultAnalyzer = defaultAnalyzer;
        this.analyzer = new SchemaAnalyzer(defaultAnalyzer, analyzers, mappers);
        this.mappedCells = mappers.values().stream().flatMap(x -> x.mappedColumns.stream()).map(Column::parseCellName).collect(Collectors.toSet());
    }

    public Analyzer analyzer(String fieldName) {
        return this.analyzer.getAnalyzer(fieldName).analyzer();
    }

    public Mapper mapper(String field2) {
        String mapperName = Column.parseMapperName(field2);
        return this.mappers.get(mapperName);
    }

    public Set<String> mappedCells() {
        return this.mappedCells;
    }

    public void validate(Columns columns) {
        for (Mapper mapper : this.mappers.values()) {
            mapper.validate(columns);
        }
    }

    public List<IndexableField> indexableFields(Columns columns) {
        LinkedList<IndexableField> fields = new LinkedList<IndexableField>();
        this.mappers.values().forEach(mapper -> fields.addAll(mapper.bestEffortIndexableFields(columns)));
        return fields;
    }

    public List<IndexableField> postProcessingIndexableFields(Columns columns, Search search) {
        LinkedList<IndexableField> fields = new LinkedList<IndexableField>();
        search.postProcessingFields().forEach(field2 -> {
            Mapper mapper = this.mapper((String)field2);
            if (mapper != null) {
                fields.addAll(mapper.indexableFields(columns));
            }
        });
        return fields;
    }

    public boolean mapsCell(String cell) {
        return this.mappers.values().stream().anyMatch(mapper -> mapper.mapsCell(cell));
    }

    @Override
    public void close() {
        this.analyzer.close();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("mappers", this.mappers).add("analyzer", (Object)this.analyzer).toString();
    }
}

