/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.index.TokenLengthAnalyzer;
import com.stratio.cassandra.lucene.schema.analysis.ClasspathAnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.StandardAnalyzers;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.DelegatingAnalyzerWrapper;

public class SchemaAnalyzer
extends DelegatingAnalyzerWrapper {
    private final TokenLengthAnalyzer defaultAnalyzer;
    private final Map<String, TokenLengthAnalyzer> fieldAnalyzers;

    public SchemaAnalyzer(Analyzer defaultAnalyzer, Map<String, Analyzer> analyzers, Map<String, Mapper> mappers) {
        super(PER_FIELD_REUSE_STRATEGY);
        this.defaultAnalyzer = new TokenLengthAnalyzer(defaultAnalyzer);
        this.fieldAnalyzers = new HashMap<String, TokenLengthAnalyzer>();
        for (Map.Entry<String, Mapper> entry : mappers.entrySet()) {
            String name = entry.getKey();
            Mapper mapper = entry.getValue();
            String analyzerName = mapper.analyzer;
            if (analyzerName == null) continue;
            Analyzer analyzer = SchemaAnalyzer.getAnalyzer(analyzers, analyzerName);
            TokenLengthAnalyzer fieldAnalyzer = new TokenLengthAnalyzer(analyzer);
            this.fieldAnalyzers.put(name, fieldAnalyzer);
        }
    }

    protected static Analyzer getAnalyzer(Map<String, Analyzer> analyzers, String name) {
        if (StringUtils.isBlank((CharSequence)name)) {
            throw new IndexException("Not empty analyzer name required");
        }
        Analyzer analyzer = analyzers.get(name);
        if (analyzer == null && (analyzer = StandardAnalyzers.get(name)) == null) {
            try {
                analyzer = new ClasspathAnalyzerBuilder(name).analyzer();
            }
            catch (Exception e) {
                throw new IndexException(e, "Not found analyzer '{}'", (Object)name);
            }
        }
        return analyzer;
    }

    public TokenLengthAnalyzer getAnalyzer(String fieldName) {
        if (StringUtils.isBlank((CharSequence)fieldName)) {
            throw new IllegalArgumentException("Not empty analyzer name required");
        }
        String name = Column.parseMapperName(fieldName);
        TokenLengthAnalyzer analyzer = this.fieldAnalyzers.get(name);
        if (analyzer != null) {
            return analyzer;
        }
        for (Map.Entry<String, TokenLengthAnalyzer> entry : this.fieldAnalyzers.entrySet()) {
            if (!name.startsWith(entry.getKey() + ".")) continue;
            return entry.getValue();
        }
        return this.defaultAnalyzer;
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        return this.getAnalyzer(fieldName);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("defaultAnalyzer", (Object)this.defaultAnalyzer).add("fieldAnalyzers", this.fieldAnalyzers).toString();
    }
}

