/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.JsonSerializer;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.schema.analysis.AnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.ClasspathAnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.StandardAnalyzers;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import com.stratio.cassandra.lucene.schema.mapping.builder.MapperBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.lucene.analysis.Analyzer;

public class SchemaBuilder {
    @JsonProperty(value="default_analyzer")
    private String defaultAnalyzerName;
    @JsonProperty(value="analyzers")
    private final Map<String, AnalyzerBuilder> analyzerBuilders;
    @JsonProperty(value="fields")
    private final Map<String, MapperBuilder<?, ?>> mapperBuilders;

    @JsonCreator
    SchemaBuilder(@JsonProperty(value="default_analyzer") String defaultAnalyzerName, @JsonProperty(value="analyzers") Map<String, AnalyzerBuilder> analyzerBuilders, @JsonProperty(value="fields") Map<String, MapperBuilder<?, ?>> mapperBuilders) {
        this.defaultAnalyzerName = defaultAnalyzerName;
        this.analyzerBuilders = analyzerBuilders != null ? analyzerBuilders : new LinkedHashMap();
        this.mapperBuilders = mapperBuilders != null ? mapperBuilders : new LinkedHashMap();
    }

    public SchemaBuilder defaultAnalyzer(String name) {
        this.defaultAnalyzerName = name;
        return this;
    }

    public SchemaBuilder analyzer(String name, AnalyzerBuilder analyzer) {
        this.analyzerBuilders.put(name, analyzer);
        return this;
    }

    public SchemaBuilder mapper(String field2, MapperBuilder<?, ?> mapper) {
        this.mapperBuilders.put(field2, mapper);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public Schema build() {
        void var3_10;
        LinkedHashMap<String, Mapper> mappers = new LinkedHashMap<String, Mapper>(this.mapperBuilders.size());
        for (Map.Entry<String, MapperBuilder<?, ?>> entry : this.mapperBuilders.entrySet()) {
            String string = entry.getKey();
            MapperBuilder<?, ?> builder = entry.getValue();
            Object mapper = builder.build(string);
            mappers.put(string, (Mapper)mapper);
        }
        LinkedHashMap<String, Analyzer> analyzers = new LinkedHashMap<String, Analyzer>();
        for (Map.Entry<String, AnalyzerBuilder> entry : this.analyzerBuilders.entrySet()) {
            String name = entry.getKey();
            Analyzer analyzer = entry.getValue().analyzer();
            analyzers.put(name, analyzer);
        }
        if (this.defaultAnalyzerName == null) {
            Analyzer analyzer = StandardAnalyzers.DEFAULT.get();
        } else {
            Analyzer analyzer = (Analyzer)analyzers.get(this.defaultAnalyzerName);
            if (analyzer == null) {
                void var3_9;
                Analyzer analyzer2 = StandardAnalyzers.get(this.defaultAnalyzerName);
                if (analyzer2 == null) {
                    try {
                        Analyzer analyzer3 = new ClasspathAnalyzerBuilder(this.defaultAnalyzerName).analyzer();
                    }
                    catch (Exception exception) {
                        throw new IndexException(exception, "Not found analyzer: '{}'", (Object)this.defaultAnalyzerName);
                    }
                }
                analyzers.put(this.defaultAnalyzerName, (Analyzer)var3_9);
            }
        }
        return new Schema((Analyzer)var3_10, mappers, analyzers);
    }

    public String toJson() {
        try {
            return JsonSerializer.toString(this);
        }
        catch (IOException e) {
            throw new IndexException(e, "Unformateable JSON schema: {}", (Object)e.getMessage());
        }
    }

    public static SchemaBuilder fromJson(String json2) {
        try {
            return JsonSerializer.fromString(json2, SchemaBuilder.class);
        }
        catch (IOException e) {
            throw new IndexException(e, "Unparseable JSON schema: {}: {}", (Object)e.getMessage(), (Object)json2);
        }
    }
}

