/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.analysis.AnalyzerBuilder;
import com.stratio.cassandra.lucene.schema.analysis.SnowballFilter;
import com.stratio.cassandra.lucene.schema.analysis.StandardStopwords;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.core.LowerCaseFilter;
import org.apache.lucene.analysis.core.StopFilter;
import org.apache.lucene.analysis.standard.StandardFilter;
import org.apache.lucene.analysis.standard.StandardTokenizer;
import org.apache.lucene.analysis.util.CharArraySet;

public class SnowballAnalyzerBuilder
extends AnalyzerBuilder {
    @JsonProperty(value="language")
    private final String language;
    @JsonProperty(value="stopwords")
    private final String stopwords;

    @JsonCreator
    public SnowballAnalyzerBuilder(@JsonProperty(value="language") String language2, @JsonProperty(value="stopwords") String stopwords) {
        if (StringUtils.isBlank((CharSequence)language2)) {
            throw new IndexException("Language must be specified");
        }
        this.language = language2;
        this.stopwords = stopwords;
    }

    @Override
    public Analyzer analyzer() {
        CharArraySet stops = this.stopwords == null ? SnowballAnalyzerBuilder.getDefaultStopwords(this.language) : SnowballAnalyzerBuilder.getStopwords(this.stopwords);
        return SnowballAnalyzerBuilder.buildAnalyzer(this.language, stops);
    }

    private static Analyzer buildAnalyzer(String language2, CharArraySet stopwords) {
        return new SnowballAnalyzer(language2, stopwords);
    }

    private static CharArraySet getStopwords(String stopwords) {
        ArrayList<String> stopwordsList = new ArrayList<String>();
        for (String stop : stopwords.split(",")) {
            stopwordsList.add(stop.trim());
        }
        return new CharArraySet(stopwordsList, true);
    }

    private static CharArraySet getDefaultStopwords(String language2) {
        return StandardStopwords.get(language2);
    }

    public static class SnowballAnalyzer
    extends Analyzer {
        private final String language;
        private final CharArraySet stopwords;

        public SnowballAnalyzer(String language2, CharArraySet stopwords) {
            this.language = language2;
            this.stopwords = stopwords;
        }

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            StandardTokenizer source = new StandardTokenizer();
            TokenFilter result2 = new StandardFilter(source);
            result2 = new LowerCaseFilter(result2);
            result2 = new StopFilter(result2, this.stopwords);
            result2 = new SnowballFilter(result2, this.language);
            return new Analyzer.TokenStreamComponents(source, result2);
        }
    }
}

