/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import com.stratio.cassandra.lucene.IndexException;
import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.analysis.TokenFilter;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.KeywordAttribute;
import org.tartarus.snowball.SnowballStemmer;

public final class SnowballFilter
extends TokenFilter {
    private final SnowballStemmer stemmer;
    private final CharTermAttribute termAtt = this.addAttribute(CharTermAttribute.class);
    private final KeywordAttribute keywordAttr = this.addAttribute(KeywordAttribute.class);

    public SnowballFilter(TokenStream stream, String language2) {
        super(stream);
        try {
            this.stemmer = Class.forName("org.tartarus.snowball.ext." + language2.toLowerCase() + "Stemmer").asSubclass(SnowballStemmer.class).newInstance();
        }
        catch (Exception e) {
            throw new IndexException(e, "The specified language '{}' is not valid", (Object)language2);
        }
    }

    @Override
    public final boolean incrementToken() throws IOException {
        if (this.input.incrementToken()) {
            if (!this.keywordAttr.isKeyword()) {
                char[] termBuffer = this.termAtt.buffer();
                int length = this.termAtt.length();
                this.stemmer.setCurrent(new String(Arrays.copyOf(termBuffer, length)));
                if (this.stemmer.stem()) {
                    char[] finalTerm = this.stemmer.getCurrent().toCharArray();
                    int newLength = finalTerm.length;
                    this.termAtt.copyBuffer(finalTerm, 0, newLength);
                } else {
                    this.termAtt.setLength(length);
                }
            }
            return true;
        }
        return false;
    }
}

