/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.analysis;

import java.util.Locale;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.ar.ArabicAnalyzer;
import org.apache.lucene.analysis.bg.BulgarianAnalyzer;
import org.apache.lucene.analysis.br.BrazilianAnalyzer;
import org.apache.lucene.analysis.ca.CatalanAnalyzer;
import org.apache.lucene.analysis.cjk.CJKAnalyzer;
import org.apache.lucene.analysis.ckb.SoraniAnalyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.analysis.core.SimpleAnalyzer;
import org.apache.lucene.analysis.core.StopAnalyzer;
import org.apache.lucene.analysis.core.WhitespaceAnalyzer;
import org.apache.lucene.analysis.cz.CzechAnalyzer;
import org.apache.lucene.analysis.da.DanishAnalyzer;
import org.apache.lucene.analysis.de.GermanAnalyzer;
import org.apache.lucene.analysis.el.GreekAnalyzer;
import org.apache.lucene.analysis.en.EnglishAnalyzer;
import org.apache.lucene.analysis.es.SpanishAnalyzer;
import org.apache.lucene.analysis.eu.BasqueAnalyzer;
import org.apache.lucene.analysis.fa.PersianAnalyzer;
import org.apache.lucene.analysis.fi.FinnishAnalyzer;
import org.apache.lucene.analysis.fr.FrenchAnalyzer;
import org.apache.lucene.analysis.ga.IrishAnalyzer;
import org.apache.lucene.analysis.gl.GalicianAnalyzer;
import org.apache.lucene.analysis.hi.HindiAnalyzer;
import org.apache.lucene.analysis.hu.HungarianAnalyzer;
import org.apache.lucene.analysis.hy.ArmenianAnalyzer;
import org.apache.lucene.analysis.id.IndonesianAnalyzer;
import org.apache.lucene.analysis.it.ItalianAnalyzer;
import org.apache.lucene.analysis.lv.LatvianAnalyzer;
import org.apache.lucene.analysis.nl.DutchAnalyzer;
import org.apache.lucene.analysis.no.NorwegianAnalyzer;
import org.apache.lucene.analysis.pt.PortugueseAnalyzer;
import org.apache.lucene.analysis.ro.RomanianAnalyzer;
import org.apache.lucene.analysis.ru.RussianAnalyzer;
import org.apache.lucene.analysis.standard.ClassicAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.analysis.sv.SwedishAnalyzer;
import org.apache.lucene.analysis.th.ThaiAnalyzer;
import org.apache.lucene.analysis.tr.TurkishAnalyzer;

public enum StandardAnalyzers {
    STANDARD{

        @Override
        protected Analyzer build() {
            return new StandardAnalyzer();
        }
    }
    ,
    DEFAULT{

        @Override
        protected Analyzer build() {
            return STANDARD.build();
        }
    }
    ,
    KEYWORD{

        @Override
        protected Analyzer build() {
            return new KeywordAnalyzer();
        }
    }
    ,
    STOP{

        @Override
        protected Analyzer build() {
            return new StopAnalyzer();
        }
    }
    ,
    WHITESPACE{

        @Override
        protected Analyzer build() {
            return new WhitespaceAnalyzer();
        }
    }
    ,
    SIMPLE{

        @Override
        protected Analyzer build() {
            return new SimpleAnalyzer();
        }
    }
    ,
    CLASSIC{

        @Override
        protected Analyzer build() {
            return new ClassicAnalyzer();
        }
    }
    ,
    ARABIC{

        @Override
        protected Analyzer build() {
            return new ArabicAnalyzer();
        }
    }
    ,
    ARMENIAN{

        @Override
        protected Analyzer build() {
            return new ArmenianAnalyzer();
        }
    }
    ,
    BASQUE{

        @Override
        protected Analyzer build() {
            return new BasqueAnalyzer();
        }
    }
    ,
    BRAZILIAN{

        @Override
        protected Analyzer build() {
            return new BrazilianAnalyzer();
        }
    }
    ,
    BULGARIAN{

        @Override
        protected Analyzer build() {
            return new BulgarianAnalyzer();
        }
    }
    ,
    CATALAN{

        @Override
        protected Analyzer build() {
            return new CatalanAnalyzer();
        }
    }
    ,
    CHINESE{

        @Override
        protected Analyzer build() {
            return new StandardAnalyzer();
        }
    }
    ,
    CJK{

        @Override
        protected Analyzer build() {
            return new CJKAnalyzer();
        }
    }
    ,
    CZECH{

        @Override
        protected Analyzer build() {
            return new CzechAnalyzer();
        }
    }
    ,
    DUTCH{

        @Override
        protected Analyzer build() {
            return new DutchAnalyzer();
        }
    }
    ,
    DANISH{

        @Override
        protected Analyzer build() {
            return new DanishAnalyzer();
        }
    }
    ,
    ENGLISH{

        @Override
        protected Analyzer build() {
            return new EnglishAnalyzer();
        }
    }
    ,
    FINNISH{

        @Override
        protected Analyzer build() {
            return new FinnishAnalyzer();
        }
    }
    ,
    FRENCH{

        @Override
        protected Analyzer build() {
            return new FrenchAnalyzer();
        }
    }
    ,
    GALICIAN{

        @Override
        protected Analyzer build() {
            return new GalicianAnalyzer();
        }
    }
    ,
    GERMAN{

        @Override
        protected Analyzer build() {
            return new GermanAnalyzer();
        }
    }
    ,
    GREEK{

        @Override
        protected Analyzer build() {
            return new GreekAnalyzer();
        }
    }
    ,
    HINDI{

        @Override
        protected Analyzer build() {
            return new HindiAnalyzer();
        }
    }
    ,
    HUNGARIAN{

        @Override
        protected Analyzer build() {
            return new HungarianAnalyzer();
        }
    }
    ,
    INDONESIAN{

        @Override
        protected Analyzer build() {
            return new IndonesianAnalyzer();
        }
    }
    ,
    IRISH{

        @Override
        protected Analyzer build() {
            return new IrishAnalyzer();
        }
    }
    ,
    ITALIAN{

        @Override
        protected Analyzer build() {
            return new ItalianAnalyzer();
        }
    }
    ,
    LATVIAN{

        @Override
        protected Analyzer build() {
            return new LatvianAnalyzer();
        }
    }
    ,
    NORWEGIAN{

        @Override
        protected Analyzer build() {
            return new NorwegianAnalyzer();
        }
    }
    ,
    PERSIAN{

        @Override
        protected Analyzer build() {
            return new PersianAnalyzer();
        }
    }
    ,
    PORTUGUESE{

        @Override
        protected Analyzer build() {
            return new PortugueseAnalyzer();
        }
    }
    ,
    ROMANIAN{

        @Override
        protected Analyzer build() {
            return new RomanianAnalyzer();
        }
    }
    ,
    RUSSIAN{

        @Override
        protected Analyzer build() {
            return new RussianAnalyzer();
        }
    }
    ,
    SORANI{

        @Override
        protected Analyzer build() {
            return new SoraniAnalyzer();
        }
    }
    ,
    SPANISH{

        @Override
        protected Analyzer build() {
            return new SpanishAnalyzer();
        }
    }
    ,
    SWEDISH{

        @Override
        protected Analyzer build() {
            return new SwedishAnalyzer();
        }
    }
    ,
    TURKISH{

        @Override
        protected Analyzer build() {
            return new TurkishAnalyzer();
        }
    }
    ,
    THAI{

        @Override
        protected Analyzer build() {
            return new ThaiAnalyzer();
        }
    };


    abstract Analyzer build();

    public static Analyzer get(String name) {
        try {
            return StandardAnalyzers.valueOf(name.toUpperCase(Locale.ROOT)).get();
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public Analyzer get() {
        return this.build();
    }
}

