/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import java.math.BigDecimal;
import org.apache.commons.lang3.StringUtils;

public class BigDecimalMapper
extends KeywordMapper {
    public static final int DEFAULT_INTEGER_DIGITS = 32;
    public static final int DEFAULT_DECIMAL_DIGITS = 32;
    private static final int BASE = 10;
    public final int integerDigits;
    public final int decimalDigits;
    private final BigDecimal complement;

    public BigDecimalMapper(String field2, String column, Boolean validated, Integer integerDigits, Integer decimalDigits) {
        super(field2, column, validated, NUMERIC_TYPES);
        if (integerDigits != null && integerDigits <= 0) {
            throw new IndexException("Positive integer part digits required");
        }
        int n = this.integerDigits = integerDigits == null ? 32 : integerDigits;
        if (decimalDigits != null && decimalDigits <= 0) {
            throw new IndexException("Positive decimal part digits required");
        }
        this.decimalDigits = decimalDigits == null ? 32 : decimalDigits;
        int totalDigits = this.integerDigits + this.decimalDigits;
        BigDecimal divisor = BigDecimal.valueOf(10L).pow(this.decimalDigits);
        BigDecimal dividend = BigDecimal.valueOf(10L).pow(totalDigits).subtract(BigDecimal.valueOf(1L));
        this.complement = dividend.divide(divisor);
    }

    @Override
    protected String doBase(String name, Object value) {
        BigDecimal bd;
        try {
            bd = new BigDecimal(value.toString());
        }
        catch (NumberFormatException e) {
            throw new IndexException("Field '{}' requires a base 10 decimal, but found '{}'", (Object)name, value);
        }
        bd = bd.stripTrailingZeros();
        String[] parts = bd.toPlainString().split("\\.");
        this.validateIntegerPart(name, value, parts);
        this.validateDecimalPart(name, value, parts);
        BigDecimal complemented = bd.add(this.complement);
        String[] bds = complemented.toString().split("\\.");
        String integerPart = StringUtils.leftPad((String)bds[0], (int)(this.integerDigits + 1), (char)'0');
        String decimalPart = bds.length == 2 ? bds[1] : "0";
        return integerPart + "." + decimalPart;
    }

    private void validateIntegerPart(String name, Object value, String[] parts) {
        String integerPart = parts[0];
        if (integerPart.replaceFirst("-", "").length() > this.integerDigits) {
            throw new IndexException("Field '{}' with value '{}' has more than %d integer digits", (Object)name, value, (Object)this.integerDigits);
        }
    }

    private void validateDecimalPart(String name, Object value, String[] parts) {
        String decimalPart;
        String string = decimalPart = parts.length == 1 ? "0" : parts[1];
        if (decimalPart.length() > this.decimalDigits) {
            throw new IndexException("Field '{}' with value '{}' has more than %d decimal digits", (Object)name, value, (Object)this.decimalDigits);
        }
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("integerDigits", this.integerDigits).add("decimalDigits", this.decimalDigits).toString();
    }
}

