/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import java.math.BigInteger;
import org.apache.commons.lang3.StringUtils;

public class BigIntegerMapper
extends KeywordMapper {
    public static final int DEFAULT_DIGITS = 32;
    private static final int BASE = 10;
    public final int digits;
    private final BigInteger complement;
    private final int hexDigits;

    public BigIntegerMapper(String field2, String column, Boolean validated, Integer digits) {
        super(field2, column, validated, INTEGER_TYPES);
        if (digits != null && digits <= 0) {
            throw new IndexException("Positive digits required");
        }
        this.digits = digits == null ? 32 : digits;
        this.complement = BigInteger.valueOf(10L).pow(this.digits).subtract(BigInteger.valueOf(1L));
        BigInteger maxValue = this.complement.multiply(BigInteger.valueOf(2L));
        this.hexDigits = BigIntegerMapper.encode(maxValue).length();
    }

    private static String encode(BigInteger bi) {
        return bi.toString(36);
    }

    @Override
    protected String doBase(String name, Object value) {
        BigInteger bi;
        String svalue = value.toString();
        try {
            bi = new BigInteger(svalue);
        }
        catch (NumberFormatException e) {
            throw new IndexException("Field '{}' requires a base 10 integer, but found '{}'", (Object)name, (Object)svalue);
        }
        if (bi.abs().toString().length() > this.digits) {
            throw new IndexException("Field '{}' with value '{}' has more than %d digits", (Object)name, value, (Object)this.digits);
        }
        bi = bi.add(this.complement);
        String bis = BigIntegerMapper.encode(bi);
        return StringUtils.leftPad((String)bis, (int)(this.hexDigits + 1), (char)'0');
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("digits", this.digits).toString();
    }
}

