/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.common.DateParser;
import com.stratio.cassandra.lucene.schema.mapping.MultipleColumnMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.LongField;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;

public class BitemporalMapper
extends MultipleColumnMapper {
    public static final String VT_FROM_FIELD_SUFFIX = ".vtFrom";
    public static final String VT_TO_FIELD_SUFFIX = ".vtTo";
    public static final String TT_FROM_FIELD_SUFFIX = ".ttFrom";
    public static final String TT_TO_FIELD_SUFFIX = ".ttTo";
    final String vtFrom;
    final String vtTo;
    final String ttFrom;
    final String ttTo;
    final Long nowValue;
    public final DateParser parser;

    public BitemporalMapper(String field2, Boolean validated, String vtFrom, String vtTo, String ttFrom, String ttTo, String pattern, Object nowValue) {
        super(field2, validated, Arrays.asList(vtFrom, vtTo, ttFrom, ttTo), DATE_TYPES);
        if (StringUtils.isBlank((CharSequence)vtFrom)) {
            throw new IndexException("vt_from column name is required");
        }
        if (StringUtils.isBlank((CharSequence)vtTo)) {
            throw new IndexException("vt_to column name is required");
        }
        if (StringUtils.isBlank((CharSequence)ttFrom)) {
            throw new IndexException("tt_from column name is required");
        }
        if (StringUtils.isBlank((CharSequence)ttTo)) {
            throw new IndexException("tt_to column name is required");
        }
        this.vtFrom = vtFrom;
        this.vtTo = vtTo;
        this.ttFrom = ttFrom;
        this.ttTo = ttTo;
        this.parser = new DateParser(pattern);
        this.nowValue = nowValue == null ? Long.MAX_VALUE : this.parser.parse(nowValue).getTime();
    }

    @Override
    public List<IndexableField> indexableFields(Columns columns) {
        BitemporalDateTime vtFromTime = this.readBitemporalDate(columns, this.vtFrom);
        BitemporalDateTime vtToTime = this.readBitemporalDate(columns, this.vtTo);
        BitemporalDateTime ttFromTime = this.readBitemporalDate(columns, this.ttFrom);
        BitemporalDateTime ttToTime = this.readBitemporalDate(columns, this.ttTo);
        if (vtFromTime == null && vtToTime == null && ttFromTime == null && ttToTime == null) {
            return Collections.emptyList();
        }
        this.validate(vtFromTime, vtToTime, ttFromTime, ttToTime);
        ArrayList<IndexableField> fields = new ArrayList<IndexableField>(4);
        fields.add(new LongField(this.field + VT_FROM_FIELD_SUFFIX, (long)vtFromTime.toTimestamp(), STORE));
        fields.add(new LongField(this.field + VT_TO_FIELD_SUFFIX, (long)vtToTime.toTimestamp(), STORE));
        fields.add(new LongField(this.field + TT_FROM_FIELD_SUFFIX, (long)ttFromTime.toTimestamp(), STORE));
        fields.add(new LongField(this.field + TT_TO_FIELD_SUFFIX, (long)ttToTime.toTimestamp(), STORE));
        return fields;
    }

    private void validate(BitemporalDateTime vtFrom, BitemporalDateTime vtTo, BitemporalDateTime ttFrom, BitemporalDateTime ttTo) {
        if (vtFrom == null) {
            throw new IndexException("vt_from column required");
        }
        if (vtTo == null) {
            throw new IndexException("vt_to column required");
        }
        if (ttFrom == null) {
            throw new IndexException("tt_from column required");
        }
        if (ttTo == null) {
            throw new IndexException("tt_to column required");
        }
        if (vtFrom.after(vtTo)) {
            throw new IndexException("vt_from:'{}' is after vt_to:'{}'", (Object)vtTo.toString(this.parser), (Object)vtFrom.toString(this.parser));
        }
        if (ttFrom.after(ttTo)) {
            throw new IndexException("tt_from:'{}' is after tt_to:'{}'", (Object)ttTo.toString(this.parser), (Object)ttFrom.toString(this.parser));
        }
    }

    BitemporalDateTime readBitemporalDate(Columns columns, String field2) {
        return this.parseBitemporalDate(columns.valueForField(field2));
    }

    public BitemporalDateTime parseBitemporalDate(Object value) {
        Date date = this.parser.parse(value);
        return date == null ? null : this.checkIfNow(date.getTime());
    }

    private BitemporalDateTime checkIfNow(Long in) {
        if (in > this.nowValue) {
            throw new IndexException("BitemporalDateTime value '{}' exceeds Max Value: '{}'", in, (Object)this.nowValue);
        }
        if (in < this.nowValue) {
            return new BitemporalDateTime(in);
        }
        return new BitemporalDateTime(Long.MAX_VALUE);
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("Bitemporal mapper '{}' does not support sorting", (Object)name);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("vtFrom", (Object)this.vtFrom).add("vtTo", (Object)this.vtTo).add("ttFrom", (Object)this.ttFrom).add("ttTo", (Object)this.ttTo).add("pattern", (Object)this.parser.pattern).add("nowValue", (Object)this.nowValue).toString();
    }

    public static class BitemporalDateTime
    implements Comparable<BitemporalDateTime> {
        public static final BitemporalDateTime MAX = new BitemporalDateTime(Long.MAX_VALUE);
        public static final BitemporalDateTime MIN = new BitemporalDateTime(0L);
        private final Long timestamp;
        private final Date date;

        BitemporalDateTime(Date date) {
            this.timestamp = date.getTime();
            this.date = date;
        }

        public BitemporalDateTime(Long timestamp) {
            if (timestamp < 0L) {
                throw new IndexException("Cannot build a BitemporalDateTime with a negative unix time");
            }
            this.timestamp = timestamp;
            this.date = new Date(timestamp);
        }

        public boolean isNow() {
            return this.timestamp.equals(BitemporalDateTime.MAX.timestamp);
        }

        public boolean isMax() {
            return this.timestamp.equals(BitemporalDateTime.MAX.timestamp);
        }

        public boolean isMin() {
            return this.timestamp.equals(0L);
        }

        public Date toDate() {
            return this.date;
        }

        public Long toTimestamp() {
            return this.timestamp;
        }

        public boolean after(BitemporalDateTime time) {
            return this.date.after(time.date);
        }

        @Override
        public int compareTo(BitemporalDateTime other) {
            return this.timestamp.compareTo(other.timestamp);
        }

        public static BitemporalDateTime max(BitemporalDateTime bt1, BitemporalDateTime bt2) {
            int result2 = bt1.compareTo(bt2);
            return result2 <= 0 ? bt2 : bt1;
        }

        public String toString() {
            return this.timestamp.toString();
        }

        public String toString(DateParser dateParser) {
            return dateParser.toString(this.date);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            BitemporalDateTime that = (BitemporalDateTime)o;
            return this.timestamp.equals(that.timestamp);
        }

        public int hashCode() {
            return this.timestamp.hashCode();
        }
    }
}

