/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.cassandra.utils.Hex;

public class BlobMapper
extends KeywordMapper {
    public BlobMapper(String field2, String column, Boolean validated) {
        super(field2, column, validated, Arrays.asList(String.class, ByteBuffer.class));
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof ByteBuffer) {
            return this.base((ByteBuffer)value);
        }
        if (value instanceof byte[]) {
            return this.base((byte[])value);
        }
        if (value instanceof String) {
            return this.base((String)value);
        }
        throw new IndexException("Field '{}' requires a byte array, but found '{}'", (Object)this.field, value);
    }

    private String base(ByteBuffer value) {
        return ByteBufferUtils.toHex(value);
    }

    private String base(byte[] value) {
        return ByteBufferUtils.toHex(value);
    }

    private String base(String value) {
        try {
            byte[] bytes = Hex.hexToBytes((String)value.replaceFirst("0x", ""));
            return Hex.bytesToHex((byte[])bytes);
        }
        catch (NumberFormatException e) {
            throw new IndexException(e, "Field '{}' requires an hex string, but found '{}'", (Object)this.field, (Object)value);
        }
    }
}

