/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.KeywordMapper;
import java.util.Arrays;

public class BooleanMapper
extends KeywordMapper {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    public BooleanMapper(String field2, String column, Boolean validated) {
        super(field2, column, validated, Arrays.asList(String.class, Boolean.class));
    }

    @Override
    protected String doBase(String name, Object value) {
        if (value instanceof Boolean) {
            return (Boolean)value != false ? TRUE : FALSE;
        }
        if (value instanceof String) {
            return this.base(name, (String)value);
        }
        throw new IndexException("Field '{}' requires a boolean, but found '{}'", (Object)name, value);
    }

    private String base(String name, String value) {
        if (value.equalsIgnoreCase(TRUE)) {
            return TRUE;
        }
        if (value.equalsIgnoreCase(FALSE)) {
            return FALSE;
        }
        throw new IndexException("Boolean field '{}' requires either '{}' or '{}', but found '{}'", (Object)name, (Object)TRUE, (Object)FALSE, (Object)value);
    }
}

