/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.common.DateParser;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Date;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;

public class DateMapper
extends SingleColumnMapper.SingleFieldMapper<Long> {
    public final DateParser parser;

    public DateMapper(String field2, String column, Boolean validated, String pattern) {
        super(field2, column, true, validated, null, Long.class, DATE_TYPES);
        this.parser = new DateParser(pattern);
    }

    @Override
    protected Long doBase(String name, Object value) {
        Date date = this.parser.parse(value);
        return date == null ? null : Long.valueOf(date.getTime());
    }

    @Override
    public Optional<Field> indexedField(String name, Long value) {
        return Optional.of(new LongField(name, (long)value, STORE));
    }

    @Override
    public Optional<Field> sortedField(String name, Long value) {
        return Optional.of(new SortedNumericDocValuesField(name, value));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.LONG, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("pattern", (Object)this.parser).toString();
    }
}

