/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.common.DateParser;
import com.stratio.cassandra.lucene.schema.mapping.MultipleColumnMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.prefix.NumberRangePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.DateRangePrefixTree;
import org.apache.lucene.spatial.prefix.tree.NumberRangePrefixTree;

public class DateRangeMapper
extends MultipleColumnMapper {
    public final String from;
    public final String to;
    public final DateParser parser;
    private final DateRangePrefixTree tree;
    public final NumberRangePrefixTreeStrategy strategy;

    public DateRangeMapper(String field2, Boolean validated, String from, String to, String pattern) {
        super(field2, validated, Arrays.asList(from, to), DATE_TYPES);
        if (StringUtils.isBlank((CharSequence)from)) {
            throw new IndexException("from column name is required");
        }
        if (StringUtils.isBlank((CharSequence)to)) {
            throw new IndexException("to column name is required");
        }
        this.from = from;
        this.to = to;
        this.parser = new DateParser(pattern);
        this.tree = DateRangePrefixTree.INSTANCE;
        this.strategy = new NumberRangePrefixTreeStrategy(this.tree, field2);
    }

    @Override
    public List<IndexableField> indexableFields(Columns columns) {
        Date fromDate = this.readFrom(columns);
        Date toDate = this.readTo(columns);
        if (fromDate == null && toDate == null) {
            return Collections.emptyList();
        }
        this.validate(fromDate, toDate);
        NumberRangePrefixTree.NRShape shape = this.makeShape(fromDate, toDate);
        return Arrays.asList(this.strategy.createIndexableFields(shape));
    }

    private void validate(Date from, Date to) {
        if (from == null) {
            throw new IndexException("From column required");
        }
        if (to == null) {
            throw new IndexException("To column required");
        }
        if (from.after(to)) {
            throw new IndexException("From:'{}' is after To:'{}'", (Object)this.parser.toString(to), (Object)this.parser.toString(from));
        }
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("Date range mapper '{}' does not support sorting", (Object)name);
    }

    public NumberRangePrefixTree.NRShape makeShape(Date from, Date to) {
        NumberRangePrefixTree.UnitNRShape fromShape = this.tree.toUnitShape(from);
        NumberRangePrefixTree.UnitNRShape toShape = this.tree.toUnitShape(to);
        return this.tree.toRangeShape(fromShape, toShape);
    }

    Date readFrom(Columns columns) {
        return this.parser.parse(columns.valueForField(this.from));
    }

    Date readTo(Columns columns) {
        return this.parser.parse(columns.valueForField(this.to));
    }

    public Date base(Object value) {
        return this.parser.parse(value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("from", (Object)this.from).add("to", (Object)this.to).add("pattern", (Object)this.parser).toString();
    }
}

