/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Optional;
import org.apache.lucene.document.DoubleField;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;

public class DoubleMapper
extends SingleColumnMapper.SingleFieldMapper<Double> {
    public static final float DEFAULT_BOOST = 1.0f;
    public final Float boost;

    public DoubleMapper(String field2, String column, Boolean validated, Float boost) {
        super(field2, column, true, validated, null, Double.class, NUMERIC_TYPES);
        this.boost = Float.valueOf(boost == null ? 1.0f : boost.floatValue());
    }

    @Override
    protected Double doBase(String name, Object value) {
        if (value instanceof Number) {
            return ((Number)value).doubleValue();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value);
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '{}' with value '{}' can not be parsed as double", (Object)name, value);
            }
        }
        throw new IndexException("Field '{}' requires a double, but found '{}'", (Object)name, value);
    }

    @Override
    public Optional<Field> indexedField(String name, Double value) {
        DoubleField doubleField = new DoubleField(name, (double)value, STORE);
        doubleField.setBoost(this.boost.floatValue());
        return Optional.of(doubleField);
    }

    @Override
    public Optional<Field> sortedField(String name, Double value) {
        long sortable = NumericUtils.doubleToSortableLong(value);
        return Optional.of(new SortedNumericDocValuesField(name, sortable));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.DOUBLE, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

