/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;
import org.apache.lucene.util.NumericUtils;

public class FloatMapper
extends SingleColumnMapper.SingleFieldMapper<Float> {
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    @JsonCreator
    public FloatMapper(String field2, String column, Boolean validated, Float boost) {
        super(field2, column, true, validated, null, Float.class, NUMERIC_TYPES);
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Float doBase(String name, Object value) {
        if (value instanceof Number) {
            return Float.valueOf(((Number)value).floatValue());
        }
        if (value instanceof String) {
            try {
                return Float.valueOf(Double.valueOf((String)value).floatValue());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '{}' with value '{}' can not be parsed as float", (Object)name, value);
            }
        }
        throw new IndexException("Field '{}' requires a float, but found '{}'", (Object)name, value);
    }

    @Override
    public Optional<Field> indexedField(String name, Float value) {
        FloatField floatField = new FloatField(name, value.floatValue(), STORE);
        floatField.setBoost(this.boost.floatValue());
        return Optional.of(floatField);
    }

    @Override
    public Optional<Field> sortedField(String name, Float value) {
        int sortable = NumericUtils.floatToSortableInt(value.floatValue());
        return Optional.of(new SortedNumericDocValuesField(name, sortable));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.FLOAT, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

