/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.Point;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.common.GeospatialUtils;
import com.stratio.cassandra.lucene.schema.mapping.MultipleColumnMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;

public class GeoPointMapper
extends MultipleColumnMapper {
    public static final int DEFAULT_MAX_LEVELS = 11;
    public final String latitude;
    public final String longitude;
    public final int maxLevels;
    public final CompositeSpatialStrategy strategy;

    public GeoPointMapper(String field2, Boolean validated, String latitude, String longitude, Integer maxLevels) {
        super(field2, validated, Arrays.asList(latitude, longitude), NUMERIC_TYPES, Collections.singletonList(Byte.class));
        if (StringUtils.isBlank((CharSequence)latitude)) {
            throw new IndexException("latitude column name is required");
        }
        if (StringUtils.isBlank((CharSequence)longitude)) {
            throw new IndexException("longitude column name is required");
        }
        this.latitude = latitude;
        this.longitude = longitude;
        this.maxLevels = GeospatialUtils.validateGeohashMaxLevels(maxLevels, 11);
        GeohashPrefixTree grid = new GeohashPrefixTree(GeospatialUtils.CONTEXT, this.maxLevels);
        RecursivePrefixTreeStrategy indexStrategy = new RecursivePrefixTreeStrategy(grid, field2);
        SerializedDVStrategy geometryStrategy = new SerializedDVStrategy(GeospatialUtils.CONTEXT, field2);
        this.strategy = new CompositeSpatialStrategy(field2, indexStrategy, geometryStrategy);
    }

    @Override
    public List<IndexableField> indexableFields(Columns columns) {
        Double lon = this.readLongitude(columns);
        Double lat = this.readLatitude(columns);
        if (lon == null && lat == null) {
            return Collections.emptyList();
        }
        if (lat == null) {
            throw new IndexException("Latitude column required if there is a longitude");
        }
        if (lon == null) {
            throw new IndexException("Longitude column required if there is a latitude");
        }
        Point point = GeospatialUtils.CONTEXT.makePoint(lon, lat);
        return Arrays.asList(this.strategy.createIndexableFields(point));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("GeoPoint mapper '{}' does not support simple sorting", (Object)name);
    }

    Double readLatitude(Columns columns) {
        Object value = columns.valueForField(this.latitude);
        return value == null ? null : GeoPointMapper.readLatitude(value);
    }

    Double readLongitude(Columns columns) {
        Object value = columns.valueForField(this.longitude);
        return value == null ? null : GeoPointMapper.readLongitude(value);
    }

    private static Double readLatitude(Object o) {
        Double value;
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            value = ((Number)o).doubleValue();
        } else {
            try {
                value = Double.valueOf(o.toString());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Unparseable latitude: {}", o);
            }
        }
        return GeospatialUtils.checkLatitude("latitude", value);
    }

    private static Double readLongitude(Object o) {
        Double value;
        if (o == null) {
            return null;
        }
        if (o instanceof Number) {
            value = ((Number)o).doubleValue();
        } else {
            try {
                value = Double.valueOf(o.toString());
            }
            catch (NumberFormatException e) {
                throw new IndexException("Unparseable longitude: {}", o);
            }
        }
        return GeospatialUtils.checkLongitude("longitude", value);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("validated", (Object)this.validated).add("latitude", (Object)this.latitude).add("longitude", (Object)this.longitude).add("maxLevels", this.maxLevels).toString();
    }
}

