/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.spatial4j.core.shape.jts.JtsGeometry;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.common.GeoTransformation;
import com.stratio.cassandra.lucene.common.GeospatialUtils;
import com.stratio.cassandra.lucene.common.GeospatialUtilsJTS;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.spatial.composite.CompositeSpatialStrategy;
import org.apache.lucene.spatial.prefix.RecursivePrefixTreeStrategy;
import org.apache.lucene.spatial.prefix.tree.GeohashPrefixTree;
import org.apache.lucene.spatial.serialized.SerializedDVStrategy;

public class GeoShapeMapper
extends SingleColumnMapper<String> {
    public static final int DEFAULT_MAX_LEVELS = 5;
    public final String column;
    public final int maxLevels;
    public final CompositeSpatialStrategy strategy;
    public final List<GeoTransformation> transformations;

    public GeoShapeMapper(String field2, String column, Boolean validated, Integer maxLevels, List<GeoTransformation> transformations) {
        super(field2, column, false, validated, null, String.class, TEXT_TYPES);
        String string = this.column = column == null ? field2 : column;
        if (StringUtils.isWhitespace((CharSequence)column)) {
            throw new IndexException("Column must not be whitespace, but found '{}'", (Object)column);
        }
        this.maxLevels = GeospatialUtils.validateGeohashMaxLevels(maxLevels, 5);
        GeohashPrefixTree grid = new GeohashPrefixTree(GeospatialUtilsJTS.CONTEXT, this.maxLevels);
        RecursivePrefixTreeStrategy indexStrategy = new RecursivePrefixTreeStrategy(grid, field2);
        SerializedDVStrategy geometryStrategy = new SerializedDVStrategy(GeospatialUtilsJTS.CONTEXT, field2);
        this.strategy = new CompositeSpatialStrategy(field2, indexStrategy, geometryStrategy);
        this.transformations = transformations == null ? Collections.emptyList() : transformations;
    }

    @Override
    public List<IndexableField> indexableFields(String name, String value) {
        JtsGeometry shape = GeospatialUtilsJTS.geometry(value);
        for (GeoTransformation transformation : this.transformations) {
            shape = transformation.apply(shape);
        }
        return Arrays.asList(this.strategy.createIndexableFields(shape));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        throw new IndexException("GeoShape mapper '{}' does not support simple sorting", (Object)name);
    }

    @Override
    protected String doBase(String field2, Object value) {
        return value.toString();
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("field", (Object)this.field).add("column", (Object)this.column).add("validated", (Object)this.validated).add("maxLevels", this.maxLevels).add("transformations", this.transformations).toString();
    }
}

