/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Date;
import java.util.Optional;
import org.apache.cassandra.serializers.SimpleDateSerializer;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.IntField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;

public class IntegerMapper
extends SingleColumnMapper.SingleFieldMapper<Integer> {
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    public IntegerMapper(String field2, String column, Boolean validated, Float boost) {
        super(field2, column, true, validated, null, Integer.class, NUMERIC_TYPES_WITH_DATE);
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Integer doBase(String name, Object value) {
        if (value instanceof Number) {
            return ((Number)value).intValue();
        }
        if (value instanceof Date) {
            return SimpleDateSerializer.timeInMillisToDay((long)((Date)value).getTime());
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).intValue();
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '{}' with value '{}' can not be parsed as integer", (Object)name, value);
            }
        }
        throw new IndexException("Field '{}' requires an integer, but found '{}'", (Object)name, value);
    }

    @Override
    public Optional<Field> indexedField(String name, Integer value) {
        IntField intField = new IntField(name, (int)value, STORE);
        intField.setBoost(this.boost.floatValue());
        return Optional.of(intField);
    }

    @Override
    public Optional<Field> sortedField(String name, Integer value) {
        return Optional.of(new SortedNumericDocValuesField(name, value.intValue()));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.INT, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

