/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.List;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.document.SortedSetDocValuesField;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedSetSortField;
import org.apache.lucene.util.BytesRef;

public abstract class KeywordMapper
extends SingleColumnMapper.SingleFieldMapper<String> {
    static final FieldType FIELD_TYPE = new FieldType();

    KeywordMapper(String field2, String column, Boolean validated, List<Class<?>> supportedTypes) {
        super(field2, column, true, validated, KEYWORD_ANALYZER, String.class, supportedTypes);
    }

    @Override
    public Optional<Field> indexedField(String name, String value) {
        this.validateTerm(name, new BytesRef(value));
        return Optional.of(new Field(name, value, FIELD_TYPE));
    }

    @Override
    public Optional<Field> sortedField(String name, String value) {
        BytesRef bytes = new BytesRef(value);
        this.validateTerm(name, bytes);
        return Optional.of(new SortedSetDocValuesField(name, bytes));
    }

    @Override
    public final SortField sortField(String name, boolean reverse) {
        return new SortedSetSortField(name, reverse);
    }

    static {
        FIELD_TYPE.setOmitNorms(true);
        FIELD_TYPE.setIndexOptions(IndexOptions.DOCS);
        FIELD_TYPE.setTokenized(true);
        FIELD_TYPE.freeze();
    }
}

