/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.schema.mapping.SingleColumnMapper;
import java.util.Date;
import java.util.Optional;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.LongField;
import org.apache.lucene.document.SortedNumericDocValuesField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.SortedNumericSortField;

public class LongMapper
extends SingleColumnMapper.SingleFieldMapper<Long> {
    public static final Float DEFAULT_BOOST = Float.valueOf(1.0f);
    public final Float boost;

    public LongMapper(String field2, String column, Boolean validated, Float boost) {
        super(field2, column, true, validated, null, Long.class, NUMERIC_TYPES_WITH_DATE);
        this.boost = boost == null ? DEFAULT_BOOST : boost;
    }

    @Override
    protected Long doBase(String name, Object value) {
        if (value instanceof Number) {
            return ((Number)value).longValue();
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof String) {
            try {
                return Double.valueOf((String)value).longValue();
            }
            catch (NumberFormatException e) {
                throw new IndexException("Field '{}' with value '{}' can not be parsed as long", (Object)name, value);
            }
        }
        throw new IndexException("Field '{}' requires a long, but found '{}'", (Object)name, value);
    }

    @Override
    public Optional<Field> indexedField(String name, Long value) {
        LongField longField = new LongField(name, (long)value, STORE);
        longField.setBoost(this.boost.floatValue());
        return Optional.of(longField);
    }

    @Override
    public Optional<Field> sortedField(String name, Long value) {
        return Optional.of(new SortedNumericDocValuesField(name, value));
    }

    @Override
    public SortField sortField(String name, boolean reverse) {
        return new SortedNumericSortField(name, SortField.Type.LONG, reverse);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).add("boost", (Object)this.boost).toString();
    }
}

