/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.schema.analysis.StandardAnalyzers;
import java.math.BigInteger;
import java.net.InetAddress;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BytesRef;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class Mapper {
    private static final Logger logger = LoggerFactory.getLogger(Mapper.class);
    static final String KEYWORD_ANALYZER = StandardAnalyzers.KEYWORD.toString();
    static final List<Class<?>> TEXT_TYPES = Collections.singletonList(String.class);
    static final List<Class<?>> INTEGER_TYPES = Arrays.asList(String.class, Byte.class, Short.class, Integer.class, Long.class, BigInteger.class);
    static final List<Class<?>> NUMERIC_TYPES = Arrays.asList(String.class, Number.class);
    static final List<Class<?>> DATE_TYPES = Arrays.asList(String.class, Integer.class, Long.class, BigInteger.class, Date.class, UUID.class);
    static final List<Class<?>> NUMERIC_TYPES_WITH_DATE = Arrays.asList(String.class, Number.class, Date.class);
    static final List<Class<?>> PRINTABLE_TYPES = Arrays.asList(String.class, Number.class, UUID.class, Boolean.class, InetAddress.class);
    static final List<Class<?>> EMPTY_TYPE_LIST = Collections.emptyList();
    static final Field.Store STORE = Field.Store.NO;
    static final boolean DEFAULT_VALIDATED = false;
    public final String field;
    public final Boolean docValues;
    public final Boolean validated;
    public final String analyzer;
    public final List<String> mappedColumns;
    public final List<String> mappedCells;
    public final List<Class<?>> supportedTypes;
    public final List<Class<?>> excludedTypes;
    public final Boolean supportsCollections;

    protected Mapper(String field2, Boolean docValues, Boolean validated, String analyzer, List<String> mappedColumns, List<Class<?>> supportedTypes, List<Class<?>> excludedTypes, Boolean supportsCollections) {
        if (StringUtils.isBlank((CharSequence)field2)) {
            throw new IndexException("Field name is required");
        }
        this.field = field2;
        this.docValues = docValues;
        this.validated = validated == null ? false : validated;
        this.analyzer = analyzer;
        this.mappedColumns = mappedColumns.stream().filter(Objects::nonNull).collect(Collectors.toList());
        this.mappedCells = this.mappedColumns.stream().map(Column::parseCellName).collect(Collectors.toList());
        this.supportedTypes = supportedTypes;
        this.excludedTypes = excludedTypes;
        this.supportsCollections = supportsCollections;
    }

    public abstract List<IndexableField> indexableFields(Columns var1);

    public List<IndexableField> bestEffortIndexableFields(Columns columns) {
        return this.bestEffort(columns, this::indexableFields);
    }

    <T> List<IndexableField> bestEffort(T base, Function<T, List<IndexableField>> mapping) {
        try {
            return mapping.apply(base);
        }
        catch (IndexException e) {
            logger.warn("Error in Lucene index:\n\twhile mapping : {}\n\twith mapper   : {}\n\tcaused by     : {}", new Object[]{base, this, e.getMessage()});
            return Collections.emptyList();
        }
    }

    public void validate(Columns columns) {
        if (this.validated.booleanValue()) {
            this.indexableFields(columns);
        }
    }

    public abstract SortField sortField(String var1, boolean var2);

    public boolean mapsCell(String cell) {
        return this.mappedCells.stream().anyMatch(x -> x.equals(cell));
    }

    void validateTerm(String name, BytesRef term) {
        int size = term.length;
        int maxSize = 32766;
        if (size > maxSize) {
            throw new IndexException("Discarding immense term in field='{}', Lucene only allows terms with at most {} bytes in length; got {} bytes: {}...", (Object)name, (Object)maxSize, (Object)size, (Object)term.utf8ToString().substring(0, 10));
        }
    }

    protected MoreObjects.ToStringHelper toStringHelper(Object self) {
        return MoreObjects.toStringHelper((Object)self).add("field", (Object)this.field).add("validated", (Object)this.validated);
    }

    public String toString() {
        return this.toStringHelper(this).toString();
    }
}

