/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.column.Column;
import com.stratio.cassandra.lucene.column.Columns;
import com.stratio.cassandra.lucene.schema.mapping.Mapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.StringUtils;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexableField;

public abstract class SingleColumnMapper<T extends Comparable<T>>
extends Mapper {
    public final String column;
    public final Class<T> base;

    public SingleColumnMapper(String field2, String column, Boolean docValues, Boolean validated, String analyzer, Class<T> base, List<Class<?>> supportedTypes) {
        this(field2, column, docValues, validated, analyzer, base, supportedTypes, EMPTY_TYPE_LIST);
    }

    public SingleColumnMapper(String field2, String column, Boolean docValues, Boolean validated, String analyzer, Class<T> base, List<Class<?>> supportedTypes, List<Class<?>> excludedTypes) {
        super(field2, docValues, validated, analyzer, Collections.singletonList(column == null ? field2 : column), supportedTypes, excludedTypes, true);
        if (StringUtils.isWhitespace((CharSequence)column)) {
            throw new IndexException("Column must not be whitespace, but found '{}'", (Object)column);
        }
        this.column = column == null ? field2 : column;
        this.base = base;
    }

    @Override
    public List<IndexableField> bestEffortIndexableFields(Columns columns) {
        LinkedList<IndexableField> fields = new LinkedList<IndexableField>();
        columns.foreachWithMapper(this.column, c -> fields.addAll(this.bestEffort(c, this::indexableFields)));
        return fields;
    }

    @Override
    public List<IndexableField> indexableFields(Columns columns) {
        LinkedList<IndexableField> fields = new LinkedList<IndexableField>();
        columns.foreachWithMapper(this.column, c -> fields.addAll(this.indexableFields((Column)c)));
        return fields;
    }

    private List<IndexableField> indexableFields(Column c) {
        String name = this.column.equals(this.field) ? c.field() : c.fieldName(this.field);
        Object value = c.valueOrNull();
        if (value != null) {
            T base = this.base(c);
            return this.indexableFields(name, base);
        }
        return Collections.emptyList();
    }

    public abstract List<IndexableField> indexableFields(String var1, T var2);

    public final T base(String field2, Object value) {
        return value == null ? null : (T)this.doBase(field2, value);
    }

    public final T base(Column column) {
        return column == null ? null : (column.valueOrNull() == null ? null : this.doBase(column));
    }

    protected abstract T doBase(@NotNull String var1, @NotNull Object var2);

    protected final T doBase(Column column) {
        return this.doBase(column.fieldName(this.field), column.valueOrNull());
    }

    @Override
    protected MoreObjects.ToStringHelper toStringHelper(Object self) {
        return super.toStringHelper(self).add("column", (Object)this.column);
    }

    @Override
    public String toString() {
        return this.toStringHelper(this).toString();
    }

    public static abstract class SingleFieldMapper<T extends Comparable<T>>
    extends SingleColumnMapper<T> {
        public SingleFieldMapper(String field2, String column, Boolean docValues, Boolean validated, String analyzer, Class<T> base, List<Class<?>> supportedTypes) {
            super(field2, column, docValues, validated, analyzer, base, supportedTypes);
        }

        @Override
        public List<IndexableField> indexableFields(String name, T value) {
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>(2);
            this.indexedField(name, value).ifPresent(fields::add);
            this.sortedField(name, value).ifPresent(fields::add);
            return fields;
        }

        public abstract Optional<Field> indexedField(String var1, T var2);

        public abstract Optional<Field> sortedField(String var1, T var2);
    }
}

