/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.schema.mapping.builder;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.common.GeoTransformation;
import com.stratio.cassandra.lucene.common.JTSNotFoundException;
import com.stratio.cassandra.lucene.schema.mapping.GeoShapeMapper;
import com.stratio.cassandra.lucene.schema.mapping.builder.MapperBuilder;
import java.util.Arrays;
import java.util.List;

public class GeoShapeMapperBuilder
extends MapperBuilder<GeoShapeMapper, GeoShapeMapperBuilder> {
    @JsonProperty(value="column")
    private String column;
    @JsonProperty(value="max_levels")
    private Integer maxLevels;
    @JsonProperty(value="transformations")
    private List<GeoTransformation> transformations;

    public final GeoShapeMapperBuilder column(String column) {
        this.column = column;
        return this;
    }

    public GeoShapeMapperBuilder maxLevels(Integer maxLevels) {
        this.maxLevels = maxLevels;
        return this;
    }

    public GeoShapeMapperBuilder transformations(List<GeoTransformation> transformations) {
        this.transformations = transformations;
        return this;
    }

    public GeoShapeMapperBuilder transformations(GeoTransformation ... transformations) {
        return this.transformations(Arrays.asList(transformations));
    }

    @Override
    public GeoShapeMapper build(String field2) {
        try {
            return new GeoShapeMapper(field2, this.column, this.validated, this.maxLevels, this.transformations);
        }
        catch (NoClassDefFoundError e) {
            throw new JTSNotFoundException();
        }
    }
}

