/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.google.common.base.MoreObjects;
import com.stratio.cassandra.lucene.IndexPagingState;
import com.stratio.cassandra.lucene.schema.Schema;
import com.stratio.cassandra.lucene.search.condition.Condition;
import com.stratio.cassandra.lucene.search.sort.SortField;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.MatchAllDocsQuery;
import org.apache.lucene.search.Query;

public class Search {
    private static final boolean DEFAULT_FORCE_REFRESH = false;
    public final List<Condition> filter;
    public final List<Condition> query;
    private final List<SortField> sort;
    private final Boolean refresh;
    private final IndexPagingState paging;

    public Search(List<Condition> filter, List<Condition> query, List<SortField> sort, IndexPagingState paging, Boolean refresh) {
        this.filter = filter == null ? Collections.EMPTY_LIST : filter;
        this.query = query == null ? Collections.EMPTY_LIST : query;
        this.sort = sort == null ? Collections.EMPTY_LIST : sort;
        this.paging = paging;
        this.refresh = refresh == null ? false : refresh;
    }

    public boolean requiresPostProcessing() {
        return this.usesRelevance() || this.usesSorting();
    }

    public boolean requiresFullScan() {
        return this.usesRelevance() || this.usesSorting() || this.refresh != false && this.isEmpty();
    }

    public boolean usesRelevance() {
        return !this.query.isEmpty();
    }

    public boolean usesSorting() {
        return !this.sort.isEmpty();
    }

    public boolean isEmpty() {
        return this.filter.isEmpty() && this.query.isEmpty() && this.sort.isEmpty();
    }

    public Query query(Schema schema, Query range) {
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        if (range != null) {
            builder.add(range, BooleanClause.Occur.FILTER);
        }
        this.filter.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.FILTER));
        this.query.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.MUST));
        BooleanQuery booleanQuery = builder.build();
        return booleanQuery.clauses().isEmpty() ? new MatchAllDocsQuery() : booleanQuery;
    }

    public Query postProcessingQuery(Schema schema) {
        if (this.query.isEmpty()) {
            return new MatchAllDocsQuery();
        }
        BooleanQuery.Builder builder = new BooleanQuery.Builder();
        this.query.forEach(condition -> builder.add(condition.query(schema), BooleanClause.Occur.MUST));
        return builder.build();
    }

    public boolean refresh() {
        return this.refresh;
    }

    public List<org.apache.lucene.search.SortField> sortFields(Schema schema) {
        return this.sort.stream().map(s -> s.sortField(schema)).collect(Collectors.toList());
    }

    public IndexPagingState paging() {
        return this.paging;
    }

    public Set<String> postProcessingFields() {
        LinkedHashSet<String> fields = new LinkedHashSet<String>();
        this.query.forEach(condition -> fields.addAll(condition.postProcessingFields()));
        this.sort.forEach(condition -> fields.addAll(condition.postProcessingFields()));
        return fields;
    }

    public Search validate(Schema schema) {
        this.filter.forEach(condition -> condition.query(schema));
        this.query.forEach(condition -> condition.query(schema));
        this.sort.forEach(field2 -> field2.sortField(schema));
        return this;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("filter", this.filter).add("query", this.query).add("sort", this.sort).add("refresh", (Object)this.refresh).add("paging", (Object)this.paging).toString();
    }
}

