/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.stratio.cassandra.lucene.IndexException;
import com.stratio.cassandra.lucene.IndexPagingState;
import com.stratio.cassandra.lucene.common.Builder;
import com.stratio.cassandra.lucene.common.JsonSerializer;
import com.stratio.cassandra.lucene.search.Search;
import com.stratio.cassandra.lucene.search.SearchBuilderLegacy;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SortFieldBuilder;
import com.stratio.cassandra.lucene.util.ByteBufferUtils;
import java.io.IOException;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class SearchBuilder
implements Builder<Search> {
    @JsonProperty(value="filter")
    protected final List<ConditionBuilder<?, ?>> filter = new LinkedList();
    @JsonProperty(value="query")
    protected final List<ConditionBuilder<?, ?>> query = new LinkedList();
    @JsonProperty(value="sort")
    private final List<SortFieldBuilder> sort = new LinkedList<SortFieldBuilder>();
    @JsonProperty(value="refresh")
    private boolean refresh;
    @JsonProperty(value="paging")
    private String paging;

    SearchBuilder() {
    }

    public SearchBuilder filter(ConditionBuilder<?, ?> ... builders) {
        this.filter.addAll(Arrays.asList(builders));
        return this;
    }

    public SearchBuilder query(ConditionBuilder<?, ?> ... builders) {
        this.query.addAll(Arrays.asList(builders));
        return this;
    }

    public SearchBuilder sort(SortFieldBuilder ... builders) {
        this.sort.addAll(Arrays.asList(builders));
        return this;
    }

    public SearchBuilder refresh(boolean refresh) {
        this.refresh = refresh;
        return this;
    }

    public SearchBuilder paging(IndexPagingState pagingState) {
        this.paging = ByteBufferUtils.toHex(pagingState.toByteBuffer());
        return this;
    }

    @Override
    public Search build() {
        return new Search(this.filter.stream().map(ConditionBuilder::build).collect(Collectors.toList()), this.query.stream().map(ConditionBuilder::build).collect(Collectors.toList()), this.sort.stream().map(SortFieldBuilder::build).collect(Collectors.toList()), this.paging == null ? null : IndexPagingState.fromByteBuffer(ByteBufferUtils.byteBuffer(this.paging)), this.refresh);
    }

    public String toJson() {
        this.build();
        try {
            return JsonSerializer.toString(this);
        }
        catch (IOException e) {
            throw new IndexException(e, "Unformateable JSON search: {}", (Object)e.getMessage());
        }
    }

    public static SearchBuilder fromJson(String json2) {
        try {
            return JsonSerializer.fromString(json2, SearchBuilder.class);
        }
        catch (IOException e) {
            return SearchBuilderLegacy.fromJson(json2);
        }
    }
}

