/*
 * Decompiled with CFR 0.152.
 */
package com.stratio.cassandra.lucene.search;

import com.stratio.cassandra.lucene.common.GeoShape;
import com.stratio.cassandra.lucene.search.SearchBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.AllConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.BitemporalConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.BooleanConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.ConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.ContainsConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.DateRangeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.FuzzyConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoBBoxConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoDistanceConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.GeoShapeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.LuceneConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.MatchConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.NoneConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.PhraseConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.PrefixConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.RangeConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.RegexpConditionBuilder;
import com.stratio.cassandra.lucene.search.condition.builder.WildcardConditionBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.GeoDistanceSortFieldBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SimpleSortFieldBuilder;
import com.stratio.cassandra.lucene.search.sort.builder.SortFieldBuilder;

public final class SearchBuilders {
    private SearchBuilders() {
    }

    public static SearchBuilder search() {
        return new SearchBuilder();
    }

    public static SearchBuilder filter(ConditionBuilder<?, ?> ... filters) {
        return SearchBuilders.search().filter(filters);
    }

    public static SearchBuilder query(ConditionBuilder<?, ?> ... queries) {
        return SearchBuilders.search().query(queries);
    }

    public static SearchBuilder sort(SortFieldBuilder ... sortFields) {
        return SearchBuilders.search().sort(sortFields);
    }

    public static SearchBuilder refresh(boolean refresh) {
        return SearchBuilders.search().refresh(refresh);
    }

    public static BooleanConditionBuilder bool() {
        return new BooleanConditionBuilder();
    }

    public static AllConditionBuilder all() {
        return new AllConditionBuilder();
    }

    public static FuzzyConditionBuilder fuzzy(String field2, String value) {
        return new FuzzyConditionBuilder(field2, value);
    }

    public static LuceneConditionBuilder lucene(String query) {
        return new LuceneConditionBuilder(query);
    }

    public static MatchConditionBuilder match(String field2, Object value) {
        return new MatchConditionBuilder(field2, value);
    }

    public static ContainsConditionBuilder contains(String field2, Object ... values) {
        return new ContainsConditionBuilder(field2, values);
    }

    public static NoneConditionBuilder none() {
        return new NoneConditionBuilder();
    }

    public static PhraseConditionBuilder phrase(String field2, String value) {
        return new PhraseConditionBuilder(field2, value);
    }

    public static PrefixConditionBuilder prefix(String field2, String value) {
        return new PrefixConditionBuilder(field2, value);
    }

    public static RangeConditionBuilder range(String field2) {
        return new RangeConditionBuilder(field2);
    }

    public static RegexpConditionBuilder regexp(String field2, String value) {
        return new RegexpConditionBuilder(field2, value);
    }

    public static WildcardConditionBuilder wildcard(String field2, String value) {
        return new WildcardConditionBuilder(field2, value);
    }

    public static GeoBBoxConditionBuilder geoBBox(String field2, double minLongitude, double maxLongitude, double minLatitude, double maxLatitude) {
        return new GeoBBoxConditionBuilder(field2, minLatitude, maxLatitude, minLongitude, maxLongitude);
    }

    public static GeoDistanceConditionBuilder geoDistance(String field2, double latitude, double longitude, String maxDistance) {
        return new GeoDistanceConditionBuilder(field2, latitude, longitude, maxDistance);
    }

    public static GeoShapeConditionBuilder geoShape(String field2, GeoShape shape) {
        return new GeoShapeConditionBuilder(field2, shape);
    }

    public static DateRangeConditionBuilder dateRange(String field2) {
        return new DateRangeConditionBuilder(field2);
    }

    public static SimpleSortFieldBuilder field(String field2) {
        return new SimpleSortFieldBuilder(field2);
    }

    public static GeoDistanceSortFieldBuilder geoDistance(String mapper, double latitude, double longitude) {
        return new GeoDistanceSortFieldBuilder(mapper, latitude, longitude);
    }

    public static BitemporalConditionBuilder bitemporal(String field2) {
        return new BitemporalConditionBuilder(field2);
    }
}

